unit path;

INTERFACE

uses math;

type
	TPath=record
		xi,yi,zi:ShortInt;
		caida,balanza,deriva:0..DEG;
	end;

	TpathCab=record
		magic:array[0..3] of char;
		x,y,z:LongInt;
		total:word;
	end;

function init:boolean;
procedure done;
function load(n:string;var p:TpathCab):boolean;
function save(n:string;p:TpathCab):boolean;
function GetPath(var n:TPath):boolean;
function SetPath(var n:TPath):boolean;
function GetPosition:integer;
function SetPosition(n:integer):boolean;

IMPLEMENTATION

uses mem,files;

const
	MAX=10000;

type
	Tcoordinates=record
		x,y,z:ShortInt;
	end;
	TaCoordinates=array[0..MAX] of Tcoordinates;

	Tangles=record
		caida,balanza,deriva:0..DEG;
	end;
	TaAngles=array[0..MAX] of Tangles;

var
	coordinates:^TaCoordinates;
	angles:^TaAngles;
	total,a:integer;

function init:boolean;
begin
	init:=(GetMem(coordinates,SizeOf(TaCoordinates))) and (GetMem(angles,SizeOf(TaAngles)));

	a:=0;
	total:=MAX;
end;

procedure done;
begin
	FreeMem(coordinates,SizeOf(TaCoordinates));
	FreeMem(angles,SizeOf(TaAngles));
end;

function load(n:string;var p:Tpathcab):boolean;
var
	f:Tfile;
	b,l:word;

begin
	load:=FALSE;

	if open(f,n,RO)>0 then exit;

	read(f,p,SizeOf(TpathCab),l);
	if (p.magic<>'PATH') or (p.total>MAX) then
		begin
			close(f);
			exit;
		end;

	total:=p.total;
	for b:=0 to total do
		begin
			read(f,coordinates^[b],SizeOf(Tcoordinates),l);
			read(f,angles^[b],SizeOf(Tangles),l);
		end;
	close(f);

	a:=0;

	load:=TRUE;
end;

function save(n:string;p:TpathCab):boolean;
var
	f:Tfile;
	b,l:word;

begin
	save:=FALSE;

	if ReWrite(f,n)>0 then exit;

	p.magic:='PATH';
	p.total:=a;
	write(f,p,SizeOf(TpathCab),l);
	for b:=0 to a do
		begin
			write(f,coordinates^[b],SizeOf(Tcoordinates),l);
			write(f,angles^[b],SizeOf(Tangles),l);
		end;
	close(f);

	save:=TRUE;
end;

function GetPath(var n:TPath):boolean;
begin
	GetPath:=FALSE;
	if a>total-1 then exit;

	with coordinates^[a] do
		begin
			n.xi:=x;n.yi:=y;n.zi:=z;
		end;

	with angles^[a] do
		begin
			n.caida:=caida;n.balanza:=balanza;n.deriva:=deriva;
		end;

	inc(a);

	GetPath:=TRUE;
end;

function SetPath(var n:TPath):boolean;
begin
	SetPath:=FALSE;
	if a>MAX then exit;

	with coordinates^[a] do
		begin
			x:=n.xi;y:=n.yi;z:=n.zi;
		end;

	with angles^[a] do
		begin
			caida:=n.caida;balanza:=n.balanza;deriva:=n.deriva;
		end;

	inc(a);

	SetPath:=TRUE;
end;

function GetPosition:integer;
begin
	GetPosition:=a;
end;

function SetPosition(n:integer):boolean;
begin
	SetPosition:=FALSE;
	if (n>total) or (n>MAX) then exit;

	a:=n;
	SetPosition:=TRUE;
end;

end.