unit speaker;

INTERFACE

procedure init;
procedure done;
procedure PlaySmp(var puntero;longitud,frecuencia:word);

IMPLEMENTATION

uses DOS,MyDOS;

var
	anterior:pointer;
	Psample:^byte;
	translate:array[0..255] of byte;
	length:word;

procedure SpeakerON;ASSEMBLER;
ASM
	CLI

	MOV			AL,$90
	OUT			$43,AL					{Prepara el Timer 2: Acceso MSB y modo terminal}

	IN			AL,$61
	OR			AL,3
	OUT			$61,AL					{Hace que el speaker funcione con el timer 2}

	STI
END;

procedure SpeakerOFF;ASSEMBLER;
ASM
	CLI

	IN			AL,$61
	AND			AL,$fc
	OUT			$61,AL			{Para el altavoz}

	MOV			AL,$B6
	OUT			$43,AL			{Restaura el valor del registro de control del Timer 2}

	STI
END;

procedure nueva;INTERRUPT;ASSEMBLER;
ASM
	CMP			length,0
	JBE			@MENOR

	LES			DI,Psample

	MOV			BH,0
	MOV			BL,ES:[DI]

	MOV			AL,BYTE(translate[BX])
	OUT			$42,AL

	DEC			length
	JNZ			@MAYOR

	CALL		SpeakerOFF
	CALL		NormalTimer

@MAYOR:
	INC			WORD(Psample)

@MENOR:
	CLI
	MOV			AL,$20
	OUT			$20,AL
	STI
END;

procedure Init;
begin
	SpeakerON;

	GetIntVec(8,anterior);
	SetIntVec(8,@nueva);
end;

procedure done;
begin
	SpeakerOFF;

	NormalTimer;
	SetIntVec(8,anterior);
end;

procedure PlaySmp(var puntero;longitud,frecuencia:word);
begin
	TimerTicks(frecuencia);

	ASM CLI END;
	Psample:=pointer(puntero);
	length:=longitud;
	ASM STI END;
end;

var
	n:integer;

begin
	Psample:=NIL;
	length:=0;

	for n:=0 to high(translate) do translate[n]:=(n*55) div 50;
end.