unit VESA;

INTERFACE

const
	c640x400=$100;
	c640x480=$101;
	c800x600=$102;
	c1024x768=$103;

	c80x25=3;

var
	XMAX,YMAX,
	CENTERX,CENTERY:word;

function init:boolean;
procedure done;

function SetMode(mode:word):boolean;

procedure DrawBitMap(x,y,xs,ys:integer;ImageData:pointer);
procedure DrawMaskBitMap(x,y,xs,ys:integer;ImageData:pointer);

procedure plot(x,y:integer;c:word);
function test(x,y:integer):byte;

procedure SetDisplayStart(x,y:word);
procedure ClearPage;
procedure SetBank(n:integer);

procedure OutTextXY(x:integer;y:integer;color:byte;cadena:string);
{Escribe la cadena CADENA en las coordenadas XY con color}
procedure OutNumXY(x,y:integer;color:byte;num:LongInt);
{Escribe el nmero num en las coordenadas XY con el color}
procedure print(x,y:integer;color:byte;cadena:string;num:LongInt);

IMPLEMENTATION

uses
	MyDOS,
{$IFDEF __BPPROT__}
	PM,WinApi
{$ELSE}
	DOS
{$ENDIF}
	;

const
	MaxVertical=480*2;       				{ max. vertical lines you need }
	MaxBanks=256;    								{ maximum bank switch }

type
	TVerticalPosInfo=array[0..MaxVertical-1] of record 	 { extra help for finding}
		Address :Word;             		{ memory addres }
		Bank:Byte;             				{ memory bank }
		reserved:byte;
	end;

	TWordArray=array [0..256] of Word;

	TVESARec=record
		sSig:array[0..3] of char;
		uVersion,
		lVersion:byte;
		Manufacturer:pointer;
		flag:LongInt;
		modes:^TWordArray;
		Paddington:array[19..256] of byte;
	end;

	TModeRec=record
		ModeFlag:word;
		WindowFlags:array[0..1] of byte;
		gran,
		WindowSize,
		Window1Seg,Window2Seg:word;
		BankSwitch:pointer;
		BytesPerLine,
		XRes,YRes:word;
		CharWidth,CharHeight,
		NumBitplanes,
		BitsPerPixel,
		MemBlocks,
		MemModel,
		MemBlockSize:byte;
		paddington:array[1..300] of byte;
	end;

var
{$IFDEF __BPPROT__}
	regs:TRMregs;
{$ELSE}
	regs:registers;
{$ENDIF}

	VESARec:^TVESARec;
	ModeRec:^TModeRec;

	VerticalPosInfo:TVerticalPosInfo;
	BytesPerScanLine,
	WinSizeBytes:word;
	BankTable:array[0..MaxBanks] of word;

	CurrentBank,
	WritePage,VisualPage,
	gran:word;

procedure AllocVesaStrucs;
begin
{$IFDEF __BPPROT__}
	ModeRec:=GlobalLock(GlobalDOSAlloc(SizeOf(TModerec)));
	VesaRec:=GlobalLock(GlobalDOSAlloc(SizeOf(TVESARec)));
{$ELSE}
	new(ModeRec);
	new(VesaRec);
{$ENDIF}
end;

procedure done;
begin
{$IFDEF __BPPROT__}
	if GlobalUnlock(seg(VesaRec^)) then GlobalDOSfree(seg(VesaRec^));
	if GlobalUnlock(seg(ModeRec^)) then GlobalDOSfree(seg(ModeRec^));
{$ELSE}
	dispose(ModeRec);
	dispose(VesaRec);
{$ENDIF}

	ASM
		MOV		AX,$4F03
		INT		$10
	END;
end;

function init:boolean;
begin
	AllocVesaStrucs;

{$IFDEF __BPPROT__}
	with regs do
		begin
			EAX:=$4f00;
			EDI:=0;
			ES:=GetSegBaseAddr(seg(VESARec^)) shr 4;
			SS:=0; {Clear stack so DPMI handles it}
			SP:=0  {"}
	 end;
	SimRMI($10,regs);

 {Convert all real mode pointers to protected mode pointers}
	with VesaRec^ do
		begin
			Modes:=ConvertPtr(Modes);
			Manufacturer:=ConvertPtr(Manufacturer);
		end;

	init:=boolean(regs.EAX);
{$ELSE}
	with regs do
		begin
			AX:=$4f00;
			DI:=ofs(VESARec^);
			ES:=seg(VESARec^);
	 end;
	intr($10,regs);

	init:=boolean(regs.AX);
{$ENDIF}
end;

function GetModeInfo(mode:word):boolean;
var
	poy:pointer;
	n:integer;
	b:LongInt;
	bank:word;

begin
{$IFDEF __BPPROT__}
	with regs do
		begin
			EAX:=$4f01;
			ECX:=LongInt(mode);
			EDI:=0;
			ES:=GetSegBaseAddr(seg(ModeRec^)) shr 4;
			SP:=0; {Clear stack so DPMI handles it}
			SS:=0  {"}
		end;
	SimRMI($10,regs);
	with ModeRec^ do BankSwitch:=ConvertPtr(BankSwitch);{}
{$ELSE}
	with regs do
		begin
			AX:=$4f01;
			CX:=mode;
			DI:=ofs(ModeRec^);
			ES:=seg(ModeRec^);
		end;
	intr($10,regs);
{$ENDIF}

	gran:=ModeRec^.gran;
	WinSizeBytes:=ModeRec^.WindowSize;
	b:=0;bank:=0;
	for n:=0 to MaxVertical-1 do with VerticalPosInfo[n] do
		begin
			address:=b;
			bank:=lo(bank);
			reserved:=hi(bank);

			inc(b,ModeRec^.Xres);
			if b mod 65535=0 then inc(bank);	{Pos fale :?}
		end;

	for n:=0 to MaxBanks do
		begin
			if ModeRec^.gran=0 then
				BankTable[n]:=n
			else
				BankTable[n]:=n*64 div gran;
		end;

	CurrentBank:=0;
	WritePage:=0;
	VisualPage:=0;
	BytesPerScanLine:=ModeRec^.BytesPerLine;

{$IFDEF __BPPROT__}
	GetModeInfo:=boolean(regs.EAX);
{$ELSE}
	GetModeInfo:=boolean(regs.AX);
{$ENDIF}
end;

function SetMode(mode:word):boolean;
begin
	SetMode:=FALSE;
	if not GetModeInfo(mode) then exit;

{$IFDEF __BPPROT__}
	with regs do
		begin
			EAX:=$4f02;
			EBX:=mode;
			SP:=0; {Clear stack so DPMI handles it}
			SS:=0  {"}
		end;
	SimRMI($10,regs);
{$ELSE}
	with regs do
		begin
			AX:=$4f02;
			BX:=mode;
		end;
	intr($10,regs);
{$ENDIF}

	case mode of
		c640x400:
			begin
				XMAX:=639;YMAX:=399;
				CENTERX:=(XMAX div 2)+1;CENTERY:=(YMAX div 2)+1;
			end;

		c640x480:
			begin
				XMAX:=639;YMAX:=479;
				CENTERX:=(XMAX div 2)+1;CENTERY:=(YMAX div 2)+1;
			end;

		c800x600:
			begin
				XMAX:=799;YMAX:=599;
				CENTERX:=(XMAX div 2)+1;CENTERY:=(YMAX div 2)+1;
			end;

		c1024x768:
			begin
				XMAX:=1023;YMAX:=767;
				CENTERX:=(XMAX div 2)+1;CENTERY:=(YMAX div 2)+1;
			end;
	end;

	SetMode:=TRUE;
end;

procedure DrawBitMap(x,y,xs,ys:integer;ImageData:pointer);ASSEMBLER;
var
	SaveDS,MemInc,CurBank,
	count,BPLine,WinGran:word;

asm
	cld
	mov     SaveDS,ds
	mov     ax,CurrentBank
	mov     CurBank,ax
	mov     ax,gran
	mov     WinGran,ax
	mov     ax,Y
	add     ax,WritePage

	mov     di,X
	mov     dx,BytesPerScanLine
	mul     dx
	add     di,ax
	adc     dx,0
	cmp     dx,CurBank            { out of current window boundary? }
	je      @@1                    { no }
{==== bankswitch ====}

	MOV     BX,DX
	MOV     CurBank,BX

	ADD     BX, BX
	ADD     BX, OFFSET BankTable
	mov     DX, [BX]
	mov     AX, $4F05
	xor     BX, BX
	int     10h

@@1:
	mov     bx,BytesPerScanLine
{ move from buffer to video memory }
	mov     ES,SegA000
	lds     si,ImageData
	mov     cx, XS
	mov     BPLine,cx
	sub     bx,cx
	mov     MemInc,bx
	mov     ax, YS
	mov     Count,ax

	{ check if switch is necessary, for one line! }
@@2:
	mov     ax,di
	add     ax,CX  { BPLine }
	jnc     @one_row  { no carry so one full row }

	{ check what's before }
	xor     cx,cx
	sub     cx,di

	mov 	 dl,cl
	shr    cx,2         { copy partially line directly }
	rep;db $66;movsw
	mov		 cl,dl
	and 	 cl,3
	rep    movsb

	push    ax           { save rest for later }
	inc     CurBank

{==== bankswitch ====}
	mov     ax,CurBank
	mov     cx, 64
	mul     cx
	mov     cx, WinGran
	jcxz    @@e2
	div     cx

	mov     dx, ax
	mov     ax, $4F05
	xor     bx, bx
	int     10h
@@e2:

	pop     ax
@@2_1: { switch done, do other half }
	mov     cx,ax

@One_Row:
	mov    dl,cl
	shr    cx,2         { copy partially line directly, part 2 after switch }
	rep;db $66;movsw
	mov		 cl,dl
	and		 cl,3
	rep		 movsb

	add     di,MemInc
	jc      @@2_2sw
	mov     cx,BPLine
	dec     Count
	jnz     @@2
	jmp     @@EndDrw
@@2_2sw:
	inc     CurBank

{==== bankswitch ====}
	mov     ax, CurBank
	mov     cx, 64
	mul     cx
	mov     cx, WinGran
	jcxz     @@e3
	div     cx
	mov     dx, ax
	mov     ax, $4F05
	xor     bx, bx
	int     10h
@@e3:

	mov     cx,BPLine
	dec     Count
	jnz     @@2

@@EndDrw:
	mov     ds,SaveDS
	mov     ax,CurBank
	mov     CurrentBank,ax
end;

procedure DrawMaskBitMap(x,y,xs,ys:integer;ImageData:pointer);ASSEMBLER;
var
	SaveDS,MemInc,CurBank,
	count,BPLine,WinGran:word;

asm
	cld
	mov     SaveDS,ds
	mov     ax,CurrentBank
	mov     CurBank,ax
	mov     ax,gran
	mov     WinGran,ax
	mov     ax,Y
	add     ax,WritePage

	mov     di,X
	mov     dx,BytesPerScanLine
	mul     dx
	add     di,ax
	adc     dx,0
	cmp     dx,CurBank            { out of current window boundary? }
	je      @@1                    { no }
{==== bankswitch ====}

	MOV     BX,DX
	MOV     CurBank,BX

	ADD     BX, BX
	ADD     BX, OFFSET BankTable
	mov     DX, [BX]
	mov     AX, $4F05
	xor     BX, BX
	int     10h

@@1:
	mov     bx,BytesPerScanLine
{ move from buffer to video memory }
	mov     ES,SegA000
	lds     si,ImageData
	mov     cx, XS
	mov     BPLine,cx
	sub     bx,cx
	mov     MemInc,bx
	mov     ax, YS
	mov     Count,ax

	{ check if switch is necessary, for one line! }
@@2:
	mov     ax,di
	add     ax,CX  { BPLine }
	jnc     @one_row  { no carry so one full row }

	{ check what's before }
	xor     cx,cx
	sub     cx,di

@M1:
	MOV			AL,[SI]
	INC			SI
	TEST		AL,AL
	JZ			@CERO1
	MOV			ES:[DI],AL
@CERO1:
	INC			DI
	DEC			CX
	JNZ			@M1

	push    ax           { save rest for later }
	inc     CurBank

{==== bankswitch ====}
	mov     ax,CurBank
	mov     cx, 64
	mul     cx
	mov     cx, WinGran
	jcxz    @@e2
	div     cx

	mov     dx, ax
	mov     ax, $4F05
	xor     bx, bx
	int     10h
@@e2:

	pop     ax
@@2_1: { switch done, do other half }
	mov     cx,ax

@One_Row:
	MOV			AL,[SI]
	INC			SI
	TEST		AL,AL
	JZ			@CERO2
	MOV			ES:[DI],AL
@CERO2:
	INC			DI
	DEC			CX
	JNZ			@One_Row

	add     di,MemInc
	jc      @@2_2sw
	mov     cx,BPLine
	dec     Count
	jnz     @@2
	jmp     @@EndDrw
@@2_2sw:
	inc     CurBank

{==== bankswitch ====}
	mov     ax, CurBank
	mov     cx, 64
	mul     cx
	mov     cx, WinGran
	jcxz     @@e3
	div     cx
	mov     dx, ax
	mov     ax, $4F05
	xor     bx, bx
	int     10h
@@e3:

	mov     cx,BPLine
	dec     Count
	jnz     @@2

@@EndDrw:
	mov     ds,SaveDS
	mov     ax,CurBank
	mov     CurrentBank,ax
end;

procedure plot(x,y:integer;c:word);ASSEMBLER;
ASM
	mov     ax,Y
	cmp			ax,YMAX
	ja			@SALIR
	add     ax,WritePage

	mov     di,X
	cmp			di,XMAX
	ja			@salir
	mov     dx,BytesPerScanLine
	mul     dx
	add     di,ax
	adc     dx,0
	cmp     dx,CurrentBank         { out of current window boundary? }
	je      @@1                    { no }
{==== bankswitch ====}
	MOV     BX,DX
	MOV     CurrentBank,BX

	ADD     BX, BX
	ADD     BX, OFFSET BankTable
	mov     DX, [BX]
	mov     AX, $4F05
	xor     BX, BX
	int     10h

@@1:
	mov     ax,c
	mov     es,SegA000
	mov     es:[di], al

@salir:
END;

function test(x,y:integer):byte;ASSEMBLER;
ASM
	mov     ax,y
	add     ax,WritePage

	mov     di,x
	mov     dx,BytesPerScanLine
	mul     dx
	add     di,ax
	adc     dx,0
	cmp     dx,CurrentBank         { out of current window boundary? }
	je      @@1                    { no }
{==== bankswitch ====}
	MOV     bx,dx
	MOV     CurrentBank,bx

	ADD     BX, BX
	ADD     BX, OFFSET BankTable
	mov     DX, [BX]
	mov     AX, $4F05
	xor     BX, BX
	int     10h

@@1:
	mov     es,SegA000
	mov     al,es:[di]
end;

procedure SetDisplayStart(x,y:word);ASSEMBLER;
ASM
	MOV		AX,$4F07
	MOV		BX,0
	MOV		CX,x
	MOV		DX,y
	INT		$10
END;

procedure ClearPage;
var
	n:integer;

begin
	for n:=0 to (ModeRec^.yres*ModeRec^.xres div 64000)-1 do
		begin
			SetBank(n);
			FillChar(ptr(SegA000,0)^,64000,0);
		end;

	FillChar(ptr(SegA000,0)^,(ModeRec^.yres*ModeRec^.xres) mod 64000,0);
end;

procedure SetBank(n:integer);ASSEMBLER;
ASM
	MOV     BX,n
	MOV     CurrentBank,BX
	ADD     BX,BX
	ADD     BX,OFFSET BankTable
	mov     DX,[BX]
	mov     AX,$4F05
	MOV			BX,0
	INT     $10
END;

procedure OutTextXY(x:integer;y:integer;color:byte;cadena:string);

	procedure text(xx,yy:integer;caracter:char;c:byte);
var
	o:word;
	n,m,x:integer;
	b:byte;

begin
	o:=MemW[Seg0000:$43*4];
	inc(o,MemW[Seg0040:$85]*ord(caracter));

	for m:=1 to 8 do
		begin
			b:=mem[SegC000:o];
			x:=xx;

			for n:=7 DownTo 0 do
				begin
					if TestBit(b,n) then plot(x,yy,c);
					inc(x);
				end;

			inc(o);
			inc(yy);
		end;
end;

var
	m:byte;
	cx:integer;

begin
	cx:=x;
	for m:=1 to length(cadena) do
		begin
			text(cx,y,cadena[m],color);
			inc(cx,8);
		end;
end;

procedure OutNumXY(x,y:integer;color:byte;num:LongInt);
var
	s:string;

begin
	str(num,s);
	OutTextXY(x,y,color,s);
end;

procedure print(x,y:integer;color:byte;cadena:string;num:LongInt);
var
	s:string;

begin
	OutTextXY(x,y,color,cadena);
	inc(x,(length(cadena)+1)*8);

	str(num,s);
	OutTextXY(x,y,color,s);
end;

end.