unit graphics;

INTERFACE

const
	CmaX:byte=16;
	XmaX:integer=640;
	YmaX:integer=480;

procedure init(m:byte);
{Cambia el modo de video}

procedure done;
{Cambia al anterior modo de video}

procedure OutTextXY(x,y:integer;color,fondo:byte;s:string);
{Escribe en XY con el color COLOR y el fondo FONDO la cadena S}

procedure circle(cx,cy:integer;radio:real;color:byte);
{Pinta un crculo en CXCY con radio RADIo y color COLOR}

function plot(x,y:integer;color:byte):word;
{escribe un punto en las coordenadas XY con el color COL
en cualquier modo grfico}

procedure plotr(x,y:integer;color:byte);
{escribe un punto en coordenadas relativas en cualquier modo grfico}

procedure draw(x,y,x1,y1:integer;color:byte);
{dibuja una lnea en cualquier modo grfico desde XY hasta X1Y1}

function test(x,y:integer):byte;
{devuelve el color de las coordenadas XY en cualquier modo grfico}

function testr(x,y:integer):byte;
{devuelve el color en coordenadas absolutas en cualquier modo grfico}

procedure MoveXY(x,y:integer);
{mueve al puntero grfico a las coordenadas XY en cualquier modo grfico}

procedure origin(x,y:integer);
{especifica el origen XY de la pantalla en en cualquier modo grfico}

function vga:BOOLEAN;
{TRUE si hay VGA}

procedure ScreenON;
{Enciende la pantalla}

procedure ScreenOFF;
{Apaga la pantalla}

function GetMode:byte;
{devuelve el modo actual de pantalla}

procedure box(x,y,x1,y1:integer;color:byte);
{dibuja una caja desde XY a X1Y1 en modo cualquier modo grfico}

IMPLEMENTATION

type
	FontOrient=(HORIZONTAL,VERTICAL);

const
	xx:integer=0;yy:integer=0;
	XTest:integer=0;YTest:integer=0;
	XOrigin:integer=0;YOrigin:integer=0;

	GraphTextOrientation:FontOrient=HORIZONTAL;
	{texto horizontal o vertical}

	FONT_HEIGHT=6;FONT_WIDTH=6;

type
	FontChar=array[0..5] of byte;
	font=array[0..255] of FontChar;

const
	FontMask:array[0..7] of byte=($80,$40,$20,$10,8,4,2,1);
	FontData:font=(
			(  0,  0,  0,  0,  0,  0), {#0}
			(  0,216,  0,248,112,  0), {#1}
			(248,168,248,136,216,248), {#2}
			(  0, 80,248,248,112, 32), {#3}
			(  0, 32,112,248,112, 32), {#4}
			( 32,112,216,248, 32,112), {#5}
			( 32,112,248,248, 32,112), {#6}
			(  0, 32,216,216, 32,  0), {#7}
			(248,216,168,168,216,248), {#8}
			(  0,112,200,152,112,  0), {#9}
			(248,136,168,168,136,248), {#10}
			( 56, 24, 32,112,136,112), {#11}
			(112,136,112, 32,248, 32), {#12}
			( 56, 40, 32, 32,224,224), {#13}
			(  0,120, 72,120, 72,216), {#14}
			(  0, 32,168, 80,168, 32), {#15}
			(  0,128,224,248,224,128), {#16}
			(  0,  8, 56,248, 56,  8), {#17}
			( 32,112,168,168,112, 32), {#18}
			(  0,216,216,216,  0,216), {#19}
			(  0,120,168,104, 40, 40), {#20}
			( 24, 32, 16, 40,144, 96), {#21}
			(  0,  0,  0,  0,248,248), {#22}
			( 32,112, 32,112, 32,248), {#23}
			(  0, 32,112,248, 32, 32), {#24}
			(  0, 32, 32,248,112, 32), {#25}
			(  0, 32, 16,248, 16, 32), {#26}
			(  0, 32, 64,248, 64, 32), {#27}
			(  0,  0,192,248,  0,  0), {#28}
			(  0,  0, 80,248, 80,  0), {#29}
			(  0,  0,  0, 32,112,248), {#30}
			(  0,  0,248,112, 32,  0), {#31}
			(  0,  0,  0,  0,  0,  0), { }
			(  0, 48, 48, 48,  0, 48), {!}
			(  0, 80, 80,  0,  0,  0), {"}
			(  0, 80,248, 80,248, 80), {#}
			( 32,120,160,112, 40,240), { $}
			(  0,200, 16, 32, 64,152), {%}
			(  0,112,216,112,152,104), {&}
			(  0, 16, 32,  0,  0,  0), {'}
			(  0,112,192,192,192,112), {(}
			(  0,224, 48, 48, 48,224), {)}
			(  0, 80, 32,248, 32, 80), {*}
			(  0,  0, 32,248, 32,  0), {+}
			(  0,  0,  0, 32, 32, 64), {,}
			(  0,  0,  0,248,  0,  0), {-}
			(  0,  0,  0,  0, 48,  0), {.}
			(  4,  8, 16, 32, 64,128), {/}
			(  0,112,152,168,200,112), {0}
			(  0, 48,112, 48, 48,120), {1}
			(  0,240, 24,112,192,248), {2}
			(  0,240, 24,112, 24,240), {3}
			(  0,192,208,248, 48, 48), {4}
			(  0,248,192,240, 24,240), {5}
			(  0,248,128,248,136,248), {6}
			(  0,248, 24, 48, 96, 96), {7}
			(  0,112,216,112,216,112), {8}
			(  0,112,136,120,  8,112), {9}
			(  0,  0, 32,  0, 32,  0), {:}
			(  0,  0, 32,  0, 32, 64), {;}
			(  0, 24, 48, 96, 48, 24), {<}
			(  0,  0,248,  0,248,  0), {=}
			(  0, 96, 48, 24, 48, 96), {>}
			(112,136, 16, 32,  0, 32), {?}
			(  0,112,136,184,128,120), {@}
			(  0,112,200,248,200,200), {A}
			(  0,240,200,240,200,240), {B}
			(  0,120,192,192,192,120), {C}
			(  0,240,216,200,216,240), {D}
			(  0,248,192,240,192,248), {E}
			(  0,248,192,240,192,192), {F}
			(  0,120,192,216,200,120), {G}
			(  0,200,200,248,200,200), {H}
			(  0,120, 48, 48, 48,120), {I}
			(  0,248,  8,  8,200,112), {J}
			(  0,200,208,224,208,200), {K}
			(  0,192,192,192,192,248), {L}
			(  0,136,216,168,136,136), {M}
			(  0,136,200,168,152,136), {N}
			(  0,112,200,200,200,112), {O}
			(  0,240,200,240,192,192), {P}
			(  0, 96,208,208,208,104), {Q}
			(  0,240,136,240,208,200), {R}
			(  0,248,192,248, 24,248), {S}
			(  0,248, 96, 96, 96, 96), {T}
			(  0,200,200,200,200,248), {U}
			(  0,200,200,200,200, 48), {V}
			(  0,136,136,168,248, 80), {W}
			(  0,136,216,112,216,136), {X}
			(  0,200,200,112, 48, 48), {Y}
			(  0,248, 24,112,192,248), {Z}
			(  0,120, 96, 96, 96,120), {[}
			(128, 64, 32, 16,  8,  4), {\}
			(  0,120, 24, 24, 24,120), {]}
			( 32, 80,136,  0,  0,  0), {^}
			(  0,  0,  0,  0,  0,248), {_}
			( 64, 32,  0,  0,  0,  0), {`}
			(  0,  0,112,200,200,120), {a}
			(  0,128,240,136,136,240), {b}
			(  0,  0,120,192,192,120), {c}
			(  0,  8,120,136,136,120), {d}
			(  0,  0,112,248,128,112), {e}
			(  0, 24, 32,120, 32, 32), {f}
			(  0,112,136,120,  8,112), {g}
			(  0,192,240,200,200,200), {h}
			( 48,  0, 48, 48, 48, 48), {i}
			( 24,  0, 24, 24,216,112), {j}
			(  0,192,208,224,216,216), {k}
			(  0, 96, 96, 96, 96, 56), {l}
			(  0,  0,208,248,168,136), {m}
			(  0,  0,240,200,200,200), {n}
			(  0,  0,112,200,200,112), {o}
			(  0,  0,240,200,240,192), {p}
			(  0,  0,112,152,120, 24), {q}
			(  0,  0,176,104, 96, 96), {r}
			(  0, 56, 64, 48,136,112), {s}
			(  0, 96,248, 96,104, 48), {t}
			(  0,  0,200,200,200,120), {u}
			(  0,  0,200,200,200,112), {v}
			(  0,  0,136,168,168,112), {w}
			(  0,  0,216, 96, 48,216), {x}
			(  0,  0,200,248,  8,112), {y}
			(  0,  0,240, 48,192,248), {z}
			(  0, 56, 96,192, 96, 56),(*{*)
			(  0, 16, 16,  0, 16, 16), {|}
			(  0,224, 48, 24, 48,224),(*}*)
			(  0,104,144,  0,  0,  0), {~}
			(  0, 32, 80,136,248,  0), {#127}
			(112,200,128,200,112,192), {#128}
			(  0,200,  0,200,200,120), {#129}
			( 24, 32,112,248,128,112), {#130}
			( 16, 40,  0,120,196,124), {#131}
			(104,  0,112,200,200,120), {#132}
			( 48,  8,112,136,136,120), {#133}
			( 16, 40, 16,112,200,120), {#134}
			(  0,120,192,120, 16, 96), {#135}
			(112,  0,112,248,192,112), {#136}
			( 80,  0,112,248,128,112), {#137}
			( 48,  8,112,248,192,112), {#138}
			(104,  0, 48, 48, 48, 48), {#139}
			( 48, 72,  0, 48, 48, 48), {#140}
			( 96, 16,  0, 48, 48, 48), {#141}
			(200,  0,112,200,248,200), {#142}
			( 48,  0,112,200,248,200), {#143}
			(112,248,192,240,192,248), {#144}
			(  0,208, 40,112,160, 88), {#145}
			(  0, 56, 80,248,144,152), {#146}
			( 32, 80,  0,112,200,112), {#147}
			( 80,  0,112,200,200,112), {#148}
			( 96, 16,  0,112,200,112), {#149}
			( 32, 80,  0,200,200,120), {#150}
			( 96, 16,  0,200,200,120), {#151}
			( 80,  0,200,248,  8,112), {#152}
			( 80,  0,112,200,200,112), {#153}
			(200,  0,200,200,200,248), {#154}
			( 16,120,128,128,120, 16), {#155}
			( 48, 72,224, 64,136,248), {#156}
			(216, 32,248, 32,248, 32), {#157}
			(192,160,208,184,144,152), {#158}
			( 48, 40, 96, 48,160, 96), {#159}
			( 48, 64,  0,112,136,120), {#160}
			( 48, 64,  0, 32, 32, 32), {#161}
			( 48, 64,  0,112,200,112), {#162}
			( 48, 64,  0,200,200,120), {#163}
			(104,144,  0,176, 72, 72), {#164}
			(104,144,  0,200,168,152), {#165}
			(112,144,104,  0,248,  0), {#166}
			(112,136,112,  0,248,  0), {#167}
			( 32,  0, 32, 64,136,112), {#168}
			(  0,  0,252,192,  0,  0), {#169}
			(  0,  0,252, 12,  0,  0), {#170}
			( 72, 80, 32, 64,168, 40), {#171}
			( 72, 80, 32, 80,152,  8), {#172}
			( 48,  0, 48, 48, 48,  0), {#173}
			( 40, 80,160, 80, 40,  0), {#174}
			(160, 80, 40, 80,160,  0), {#175}
			( 84,168, 84,168, 84,168), {#176}
			(252,252,252,252,252,252), {#177}
			(168, 84,168, 84,168, 84), {#178}
			( 16, 16, 16, 16, 16, 16), {#179}
			( 16, 16, 16,240, 16, 16), {#180}
			( 16, 16,240, 16,240, 16), {#181}
			( 40, 40, 40,232, 40, 40), {#182}
			(  0,  0,  0,248, 40, 40), {#183}
			(  0,  0,240, 16,240, 16), {#184}
			( 40, 40,232,  8,232, 40), {#185}
			( 40, 40, 40, 40, 40, 40), {#186}
			(  0,  0,248,  8,232, 40), {#187}
			( 40, 40,232,  8,248,  0), {#188}
			( 40, 40, 40,248,  0,  0), {#189}
			( 16, 16,240, 16,240,  0), {#190}
			(  0,  0,  0,240, 16, 16), {#191}
			( 16, 16, 16, 28,  0,  0), {#192}
			( 16, 16, 16,252,  0,  0), {#193}
			(  0,  0,  0,252, 16, 16), {#194}
			( 16, 16, 16, 28, 16, 16), {#195}
			(  0,  0,  0,252,  0,  0), {#196}
			( 16, 16, 16,252, 16, 16), {#197}
			( 16, 16, 28, 16, 28, 16), {#198}
			( 40, 40, 40, 44, 40, 40), {#199}
			( 40, 40, 44, 32, 60,  0), {#200}
			(  0,  0, 60, 32, 44, 40), {#201}
			( 40, 40,236,  0,252,  0), {#202}
			(  0,  0,252,  0,236, 40), {#203}
			( 40, 40, 44, 32, 44, 40), {#204}
			(  0,  0,252,  0,252,  0), {#205}
			( 40, 40,236,  0,236, 40), {#206}
			( 16, 16,252,  0,252,  0), {#207}
			( 40, 40, 40,252,  0,  0), {#208}
			(  0,  0,252,  0,252, 16), {#209}
			(  0,  0,  0,252, 40, 40), {#210}
			( 40, 40, 40, 60,  0,  0), {#211}
			( 16, 16, 28, 16, 28,  0), {#212}
			(  0,  0, 28, 16, 28, 16), {#213}
			(  0,  0,  0, 60, 40, 40), {#214}
			( 40, 40, 40,252, 40, 40), {#215}
			( 16, 16,252, 16,252, 16), {#216}
			( 16, 16, 16,240,  0,  0), {#217}
			(  0,  0, 28, 16, 16, 16), {#218}
			(252,252,252,252,252,252), {#219}
			(  0,  0,  0,252,252,252), {#220}
			(192,192,192,192,192,192), {#221}
			( 12, 12, 12, 12, 12, 12), {#222}
			(252,252,252,  0,  0,  0), {#223}
			(  0,  0,104,144,144,104), {#224}
			(  0,112,152,176,136,176), {#225}
			(  0,248,136,128,128,128), {#226}
			(  0,  0,248, 80, 80, 80), {#227}
			(248, 72, 32, 64,136,248), {#228}
			(  0,  0,120,144,144, 96), {#229}
			(  0, 72, 72,120, 64,192), {#230}
			(  0,  0,104,176, 32, 32), {#231}
			(  0,248, 32, 80, 32,248), {#232}
			(  0,112,136,248,136,112), {#233}
			(  0,112,136,136, 80,216), {#234}
			( 56, 64, 32,112,136,112), {#235}
			(  0,  0, 80,168, 80,  0), {#236}
			(  0,  8, 80,168, 80,128), {#237}
			(  0,120,128,248,128,120), {#238}
			(  0,  0,112,136,136,136), {#239}
			(  0,248,  0,248,  0,248), {#240}
			(  0, 32,112, 32,  0,248), {#241}
			( 64, 32, 16, 32, 64,248), {#242}
			( 16, 32, 64, 32, 16,248), {#243}
			( 16, 40, 32, 32, 32, 32), {#244}
			( 32, 32, 32, 32,160, 64), {#245}
			(  0, 32,  0,248,  0, 32), {#246}
			(104,144,  0,104,144,  0), {#247}
			( 96,144, 96,  0,  0,  0), {#248}
			(  0,  0,  0, 48,  0,  0), {#249}
			(  0,  0,  0, 16,  0,  0), {#250}
			( 60, 32, 32,160, 96, 32), {#251}
			(176, 72, 72,  0,  0,  0), {#252}
			(224, 16, 96,128,240,  0), {#253}
			(  0,  0,112,112,  0,  0), {#254}
			(  0,  0,  0,  0,  0,  0));{#255}

var
	modo,ModoAnterior:byte;
	DirPant:word;

procedure init(m:byte);

procedure XYmax;				{PRIVADA}
begin
	case getmode of
		4,5:
				begin
					XmaX:=320;
					YmaX:=200;
					CmaX:=4;
					DirPant:=SegB800;
				end;
		$d:
				begin
					XmaX:=320;
					YmaX:=200;
					CmaX:=16;
					DirPant:=SegA000;
				end;
			$13:
				begin
					XmaX:=320;
					YmaX:=200;
					CmaX:=255;
					DirPant:=SegA000;
				end;
			$11:
				begin
					XmaX:=640;
					YmaX:=480;
					CmaX:=2;
					DirPant:=SegA000;
				end;
			$12:
				begin
					XmaX:=640;
					YmaX:=480;
					CmaX:=16;
					DirPant:=SegA000;
				end;
			$53:
				begin
					XmaX:=640;
					YmaX:=480;
					CmaX:=255;
					DirPant:=SegA000;
				end;
			$52:
				begin
					XmaX:=800;
					YmaX:=600;
					CmaX:=16;
					DirPant:=SegA000;
				end;
			$54:
				begin
					XmaX:=800;
					YmaX:=600;
					CmaX:=255;
					DirPant:=SegA000;
				end;
			$55:
				begin
					XmaX:=1024;
					YmaX:=768;
					CmaX:=4;
					DirPant:=SegA000;
				end;
			$56:
				begin
					XmaX:=1024;
					YmaX:=768;
					CmaX:=16;
					DirPant:=SegA000;
				end;
			$59:
				begin
					XmaX:=1024;
					YmaX:=768;
					CmaX:=255;
					DirPant:=SegA000;
				end;
			$58:
				begin
					XmaX:=1280;
					YmaX:=1024;
					CmaX:=16;
					DirPant:=SegA000;
				end;
			6:
				begin
					XmaX:=640;
					YmaX:=200;
					CmaX:=2;
					DirPant:=SegB800;
				end;
			$e:
				begin
					XmaX:=640;
					YmaX:=200;
					CmaX:=16;
					DirPant:=SegA000;
				end;
			$f:
				begin
					XmaX:=640;
					YmaX:=350;
					CmaX:=2;
					DirPant:=SegA000;
				end;
			$10:
				begin
					XmaX:=640;
					YmaX:=350;
					CmaX:=16;
					DirPant:=SegA000;
				end;
		 end;
end;

begin
	ModoAnterior:=GetMode;
	ASM
		XOR		AH,AH
		MOV		AL,m
		INT		$10
	END;
	modo:=m;
	XYmax;
end;

procedure done;ASSEMBLER;
ASM
	MOV		AH,0
	MOV		AL,ModoAnterior
	INT		$10
END;

procedure OutTextXY(x,y:integer;color,fondo:byte;s:string);
var
	z,b,bit,i:byte;
	data:FontChar;

begin
 for i:=1 to length(s) do
	begin
		data:=FontData[ord(s[i])];
		for z:=0 to FONT_HEIGHT-1 do
			begin
				b:=data[z];
				for bit:=0 to FONT_WIDTH-1 do
					if b and FontMask[bit]<>0 then
						plot(x+bit,y+z,color)
					else
						if (color<>fondo) then plot(x+bit,y+z,fondo);
			end;

		if GraphTextOrientation=HORIZONTAL then
			inc(x,FONT_WIDTH)
		else
			inc(y,FONT_WIDTH);
	end;
end;

procedure circle(cx,cy:integer;radio:real;color:byte);
var
	radqu,x,y,u1,u2,u3,u4,v1,v2,v3,v4,counter:word;

begin
	counter:=0;
	radqu:=trunc(sqr(radio));
	for x:=0 to trunc(radio/1.41421356240) do
		begin
			y:=trunc(sqrt(radqu-sqr(x)));
			u1:=cx-x;v1:=cy-y;
			u2:=cx+x;v2:=cy+y;
			u3:=cx-y;v3:=cy-x;
			u4:=cx+y;v4:=cy+x;

			plot(u1,v1,color);
			plot(u1,v2,color);
			plot(u2,v1,color);
			plot(u2,v2,color);
			plot(u3,v3,color);
			plot(u3,v4,color);
			plot(u4,v3,color);
			plot(u4,v4,color);
		end;
end;

function plot(x,y:integer;color:byte):word;ASSEMBLER;
ASM
	MOV		AX,XOrigin
	ADD		x,AX
	MOV		AX,YOrigin
	ADD		y,AX

	MOV		CX,x
	MOV		xx,CX

	MOV		DX,y
	MOV		yy,DX

	MOV		AH,$C
	MOV		AL,color
	INT		$10
END;

procedure plotr(x,y:integer;color:byte);
begin
	inc(x,XOrigin);
	inc(y,YOrigin);
	inc(xx,x);
	inc(yy,y);
	plot(xx,yy,color);
end;

procedure draw(x,y,x1,y1:integer;color:byte);

function sgn(valor:integer):integer;
begin
	if valor<0 then
		sgn:=-1
	else
		if valor=0 then
			sgn:=0
		else
			sgn:=1;
end;

var
	t,distancia,Xerr,Yerr,DeltaX,DeltaY,IncX,IncY:integer;

begin
	Xerr:=0;Yerr:=0;
	DeltaX:=x1-x;
	DeltaY:=y1-y;
	IncX:=sgn(DeltaX);
	IncY:=sgn(DeltaY);
	DeltaX:=abs(DeltaX);
	DeltaY:=abs(DeltaY);
	if DeltaX>DeltaY then
		distancia:=DeltaX
	else
		distancia:=DeltaY;

	for t:=1 to distancia+1 do
		begin
			plot(x,y,color);
			inc(Xerr,DeltaX);
			inc(Yerr,DeltaY);
			if Xerr>distancia then
				begin
					dec(Xerr,distancia);
					inc(x,IncX);
				end;
			if Yerr>distancia then
				begin
					dec(Yerr,distancia);
					inc(y,IncY);
				end;
		end;
end;

function test(x,y:integer):byte;ASSEMBLER;
ASM
	MOV		AX,XOrigin
	ADD		x,AX

	MOV		AX,YOrigin
	ADD		y,AX

	MOV		CX,x
	MOV		DX,y

	MOV		XTest,CX
	MOV		YTest,DX

	MOV		AH,$d
	INT		$10
END;

function testr(x,y:integer):byte;
begin
	inc(XTest,XOrigin);inc(YTest,YOrigin);
	inc(XTest,x);inc(YTest,y);
	testr:=test(XTest,YTest);
end;

procedure MoveXY(x,y:integer);
begin
	inc(x,XOrigin);inc(y,YOrigin);
	xx:=x;yy:=y;
end;

procedure origin(x,y:integer);
begin
	XOrigin:=x;YOrigin:=y;
end;

function vga:boolean;ASSEMBLER;
ASM
	MOV		AX,$1A00
	INT		$10

	CMP		AL,$1A
	JNZ		@NO
	MOV		AL,TRUE
	JMP		@FIN

@NO:
	MOV		AL,FALSE

@FIN:
END;

procedure ScreenON;
var
	info:byte absolute $0040:$0010;{}

begin
	if vga then
		ASM
			MOV			AX,$1200
			MOV			BL,$36
			INT			$10
		END
	else
		if info and 48=48 then
			port[952]:=255
		else
			port[984]:=41;
end;

procedure ScreenOFF;
var
	info:byte absolute $0040:$0010;{}

begin
	if vga then
		ASM
			MOV		AX,$1201
			MOV		BL,$36
			INT		$10
		END
	else
		if info and 48=48 then
			port[952]:=1
		else
			port[984]:=1;

	if vga then
		ASM
			MOV		AX,$1001
			MOV		BH,0
			INT		$10
		END
	else
		port[$3d9]:=15 and 0;
end;

function GetMode:byte;ASSEMBLER;
ASM
	MOV		AH,$F
	INT		$10
END;

procedure box(x,y,x1,y1:integer;color:byte);
begin
	draw(x,y,x1,y,color);
	draw(x,y,x,y1,color);
	draw(x,y1,x1,y1,color);
	draw(x1,y,x1,y1,color);
end;

begin
	modo:=GetMode;
	DirPant:=SegA000;
end.