#include "SM_DemoScriptPCH.h"
#include "SM_DemoTune.h"
#include "MVFS.h"


SM_DemoTune* SM_DemoTune::TuneInstances=0;

SM_DemoTune::SM_DemoTune(char const* pcName)
{
  m_pcInstanceName  =pcName;
  m_pcBuffer        =0;
  m_pNextTune       =TuneInstances;
  TuneInstances     =this;
  m_Flags           =0;
}

SM_DemoTune::~SM_DemoTune()
{
  if (m_pcInstanceName)
  {
    delete[] m_pcBuffer;
    m_pcBuffer=0;
  }
}

int SM_DemoTune::Load(char* pcFilename)
{
  MVFSFILE* f;

  f=MVFS::fopen(pcFilename, "rb");
  if (!f)
  {
    SM_Main::OutputError("Error file not found %s", pcFilename);
    return (-1);
  }

  MVFS::fseek(f, 0, SEEK_END);
  int iLength=MVFS::ftell(f);
  if (iLength==-1)
  {
    return (-1);
  }

  MVFS::fseek(f, 0, SEEK_SET);

  char* pcMP3=new char[iLength];
  if (!pcMP3)
  {
    return (-1);
  }
  
  if (MVFS::fread(pcMP3, iLength, 1, f)!=1)
  {
    SM_Main::OutputError("Error reading %s", pcFilename);
    MVFS::fclose(f);
    delete[] pcMP3;
    return (-1);
  }

  m_pcBuffer=pcMP3;
  m_iLength=iLength;

  MVFS::fclose(f); 

  return (0);
}

int SM_DemoTune::Free()
{
  delete[] m_pcBuffer;
  m_pcBuffer=0;

  return 0;
}

SM_DemoTune Track01("TRACK01");
SM_DemoTune Track02("TRACK02");
SM_DemoTune Track03("TRACK03");
SM_DemoTune Track04("TRACK04");
SM_DemoTune MP301  ("MP301");
SM_DemoTune MP302  ("MP302");
SM_DemoTune MP303  ("MP303");
SM_DemoTune MP304  ("MP304");

