#ifndef ___MESH

#define ___MESH

#include <vector>
class MVFSFILE;

struct VertexPosition
{
  float x,y,z;
};

struct VertexNormal
{
  float x,y,z;
};

struct VertexTexCoord
{
  float u,v;
};

struct VertexColor
{
  float r,g,b;
};

struct Face
{
  int m_piPositions    [3];
  int m_piTexCoords    [3];
  int m_piColors       [3];
  int m_piNormals      [3];
  int m_iSmoothingGroup   ;
  int m_iMaterial         ;
  int m_iNormal           ;
};

// Generic vertex
struct RenderVertex
{
  void      Init();
  
  float     x , y, z;
  float     nx,ny,nz;
  unsigned  diffuse;
  unsigned  specular;
  float     u,v;
  float     s,t;
};

// Simple mesh element (single material+vertices+indices)
#define MAXMATERIALNAME 128
 
struct RenderMeshElement
{
      RenderMeshElement   ();
      ~RenderMeshElement  ();
  int Init                ();  
  int Shutdown            ();

  int Load          (MVFSFILE* f);
  int Save          (MVFSFILE* f);
  int LoadCompressed(MVFSFILE* f);
  int SaveCompressed(MVFSFILE* f);
  
  
  unsigned         m_uVertices;  
  unsigned         m_uIndices;
  RenderVertex*    m_pRenderVertices;
  unsigned short*  m_pusIndices;
  int              m_iMaterial;
  char             m_pcMaterial[MAXMATERIALNAME];
};

// Set of mesh elements
struct RenderMesh
{
      RenderMesh    ();
      ~RenderMesh   ();
  int Init          ();
  int Shutdown      ();

  int Load          (MVFSFILE* f);
  int Save          (MVFSFILE* f);
  
  unsigned            m_uElements;
  RenderMeshElement*  m_pElements;
  char*               m_pcName;
};


struct MetaFileNode;

class Mesh
{
public:
  enum  eMeshFlags
  {
    E_TEXCORDS        =1,
    E_VERTEXCOLORS    =2,
    E_SMOOTHINGGROUPS =4,    
    E_NORMALS         =8,
  };

  int Init                ();
  int Shutdown            ();

  int Import              (MetaFileNode* pMetaFileNode);
  int GenerateRenderMesh  (RenderMesh* pRenderMesh);

  int GenerateNormals     ();


  std::vector<VertexPosition> m_Positions;
  std::vector<VertexNormal>   m_Normals;
  std::vector<VertexTexCoord> m_TexCoords;
  std::vector<VertexColor>    m_VertexColors;
  std::vector<VertexNormal>   m_VertexNormals;
  std::vector<Face>           m_Faces;
  int                         m_iFlags;
};

#endif