#ifndef __DEMOINTERFACE

#define __DEMOINTERFACE

#include <windows.h>
#include "SM_DemoScript.h"
#include "MBStaticList.h"



struct MSurface;

class DemoControl
{
public:
                                  DemoControl               ();
                                  ~DemoControl              ();
                                  
  int                             Init                      (HWND hwnd, int iResX, int iResY, 
                                                            unsigned uBPP, bool bStencil, bool bFullscreen, bool bAntialias, 
                                                            bool bRetrace, bool bUpdateWindow, bool bLockable);
  int                             Shutdown                  ();
                                  
                                  
  int                             Load                      (const char* pcPath);
  int                             PreloadFX                 ();

  int                             LoadCallback              (unsigned uNumber, unsigned uEffects);
                                                                    
  int                             Run                       (float fTime, MSurface* pSurface = 0);
  int                             RunToTime                 (float fTime, MSurface* pSurface = 0);
  int                             Reset                     ();
                                  

  int                             InitDemoInfrastructure    ();
  int                             ShutdownDemoInfrastructure();


  static bool							        g_bDrawFPS;

protected:
  int                             LoadScript                (const char* pcScriptFile);
  int                             SaveScript                (const char* pcScriptFile);  

};

#endif
