#ifndef __SM_D3DGEOMETRY

#define __SM_D3DGEOMETRY

struct RenderMesh;
struct MeshElement;
struct Quaternion;
struct Vector3D;
struct AABox;

#define USESTATICBUFFERS

class D3DGeometry
{
public:
                             D3DGeometry          ();
                             ~D3DGeometry         ();
                            
  int                        Init                 (RenderMesh* pRenderMesh);
  int                        Shutdown             ();
  void                       PreTransform         (Vector3D* pv3d, Quaternion* pq);
  void                       AABB                 (AABox* pAABB);
  void                       ClearCache           ();
  void                       PreCache             ();
  int                        GenerateShadowVolume ();
  int                        GenerateShadowVolume (MeshElement* pMeshElement);
  

  char*                      m_pcName;
  MeshElement*               m_pMeshElements;
  unsigned                   m_uMeshElements;
  int                        m_iVertexBuffer;
  int                        m_iIndexBuffer;
  float                      m_fRadius;
  FVF_PosNormalDiffuseTex1*  m_pVertices; 
  unsigned short*            m_pIndices;  
};

#endif
