#version 330

uniform vec4 colour;
uniform float brightness;

uniform sampler2D logo_tex;
uniform vec2 logo_coord;
uniform float logo_bias;

in GeometryOut
{
    noperspective vec2 coord;
    noperspective float tc;

} g_out;

out vec4 output;

void main()
{
    float a = 1.0 - smoothstep(0.1, 0.2, length(g_out.coord));
    
    if(a < 0.1)
        discard;
    
    output = a * colour * vec4(0.7, 0.8, 1.0, 1.0) * (0.7 + 0.7 * pow(abs(g_out.tc), 32.0))*0.8*brightness*mix(1.0, texture2D(logo_tex, logo_coord).r, logo_bias);
}
