#version 330

#define emit(p, c, t) \
        g_out.coord = c; \
        g_out.tc = t; \
        gl_Position.xy = p; \
        gl_Position.zw = vec2(0.0, 1.0); \
        EmitVertex();
        
layout(lines, invocations = 1) in;
layout(triangle_strip, max_vertices = 8) out;

uniform vec2 radii;

out GeometryOut
{
    noperspective vec2 coord;
    noperspective float tc;
    
} g_out;


void emitLine(in vec2 pos0, in vec2 pos1)
{
    float rad_ratio = radii.y / radii.x;
    
    vec2 pll = normalize(pos1 - pos0) * radii.x, // parallel
         prp = pll.yx * vec2(-1, +1); // perpendicular

    emit(pos0 + prp * (+1.0) + pll * (-1.0), vec2(+1.0, -1.0), -1.0);
    emit(pos0 + prp * (-1.0) + pll * (-1.0), vec2(-1.0, -1.0), -1.0);

    emit(pos0 + prp * (+1.0), vec2(+1.0, 0.0), -1.0);
    emit(pos0 + prp * (-1.0), vec2(-1.0, 0.0), -1.0);

    emit(pos1 + prp * (+1.0) * rad_ratio, vec2(+1.0, 0.0), +1.0);
    emit(pos1 + prp * (-1.0) * rad_ratio, vec2(-1.0, 0.0), +1.0);
 
    emit(pos1 + prp * (+1.0) * rad_ratio + pll * (+1.0) * rad_ratio, vec2(+1.0, +1.0), +1.0);
    emit(pos1 + prp * (-1.0) * rad_ratio + pll * (+1.0) * rad_ratio, vec2(-1.0, +1.0), +1.0);

    EndPrimitive();
}

void main()
{
    emitLine(gl_in[0].gl_Position.xy / gl_in[0].gl_Position.w, gl_in[1].gl_Position.xy / gl_in[1].gl_Position.w);
}
