// thingDoc.cpp : implementation of the CThingDoc class
//

#include "stdafx.h"
#include "thing.h"

#include "thingDoc.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CThingDoc

IMPLEMENT_DYNCREATE(CThingDoc, CDocument)

BEGIN_MESSAGE_MAP(CThingDoc, CDocument)
	//{{AFX_MSG_MAP(CThingDoc)
	ON_UPDATE_COMMAND_UI(ID_DOGO, OnUpdateDogo)
	ON_COMMAND(ID_DOGO, OnDogo)
	ON_COMMAND(ID_DONTGO, OnDontgo)
	ON_COMMAND(ID_MAKEFILM, OnMakeFilm)
	ON_UPDATE_COMMAND_UI(ID_DONTGO, OnUpdateDontgo)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CThingDoc construction/destruction

CThingDoc::CThingDoc()
{
	// TODO: add one-time construction code here
	running=1;
	channels.clear();
	maxtime=0x500;
	zoom=1;
	scrollpos=0;
	scrollx=0;
	curchan=0;
	curpos=0;
	selchan1=1;
	selchan2=3;
	selpos1=16;
	nonotes=0;
	selpos2=32;
	
	playing=0;
	playpos=0;
	playpossub=0;

	pulsetrigger=0;
	talkielevel=0;
	pulseprob=0;

	animframe[0]=animframe[1]=0;
	


}

CThingDoc::~CThingDoc()
{
}

BOOL CThingDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	// TODO: add reinitialization code here
	// (SDI documents will reuse this document)

	running=1;
	channels.clear();
	maxtime=0x500;
	zoom=1;
	scrollpos=0;
	scrollx=0;
	curchan=0;
	curpos=0;
	selchan1=1;
	selchan2=3;
	selpos1=16;
	selpos2=32;
	
	playing=0;
	playpos=0;
	playpossub=0;

	/*
	channels.push_back(Channel("note 0",DT_NOTE,7));
	channels.push_back(Channel("v",DT_INT,3));
	channels.push_back(Channel("note 1",DT_NOTE,7));
	channels.push_back(Channel("v",DT_INT,3));
	channels.push_back(Channel("note 2",DT_NOTE,7));
	channels.push_back(Channel("v",DT_INT,3));
	channels.push_back(Channel("note 3",DT_NOTE,7));
	channels.push_back(Channel("v",DT_INT,3));
	channels.push_back(Channel("note 4",DT_NOTE,7));
	channels.push_back(Channel("v",DT_INT,3));
	channels.push_back(Channel("note 5",DT_NOTE,7));
	channels.push_back(Channel("v",DT_INT,3));
	channels.push_back(Channel("note 6",DT_NOTE,7));
	channels.push_back(Channel("v",DT_INT,3));
	channels.push_back(Channel("note 7",DT_NOTE,7));
	channels.push_back(Channel("v",DT_INT,3));
	*/

	channels.push_back(Channel("cam0",				DT_FLOAT,		7	));
	channels.push_back(Channel("cam1",				DT_FLOAT,		7	));
	channels.push_back(Channel("xfade",				DT_FLOAT,		7	));
	channels.push_back(Channel("vine",				DT_FLOAT,		7	));
	channels.push_back(Channel("tree",				DT_FLOAT,		7	));
	channels.push_back(Channel("man",				DT_INT,			7	));
	channels.push_back(Channel("titF",				DT_FLOAT,		7	));
	channels.push_back(Channel("titP",				DT_FLOAT,		7	));
	channels.push_back(Channel("titNz",				DT_FLOAT,		7	));
	channels.push_back(Channel("titWipe",			DT_FLOAT,		7	));
	channels.push_back(Channel("facVol",			DT_FLOAT,		7	));
	channels.push_back(Channel("facBal",			DT_FLOAT,		7	));
	channels.push_back(Channel("facAlf",			DT_FLOAT,		7	));
	channels.push_back(Channel("facPls",			DT_FLOAT,		7	));
	channels.push_back(Channel("fac<>",				DT_FLOAT,		7	));
	channels.push_back(Channel("sunl",				DT_FLOAT,		7	));
	channels.push_back(Channel("t_wet",				DT_FLOAT,		7	));
	channels.push_back(Channel("t_delay",			DT_FLOAT,		7	));
	channels.push_back(Channel("t_fb",				DT_FLOAT,		7	));
	channels.push_back(Channel("t_time",			DT_FLOAT,		7	));
	channels.push_back(Channel("t_pch",				DT_FLOAT,		7	));

	channels.push_back(Channel("nojump",			DT_FLOAT,		7	));
	channels.push_back(Channel("centro",			DT_FLOAT,		7	));
	channels.push_back(Channel("rain",				DT_FLOAT,		7	));
	channels.push_back(Channel("starfd",				DT_FLOAT,		7	));
	channels.push_back(Channel("starwp",				DT_FLOAT,		7	));
	channels.push_back(Channel("credits",				DT_FLOAT,		7	));
	channels.push_back(Channel("trigger",				DT_FLOAT,		7	));
	channels.push_back(Channel("mvol",				DT_FLOAT,		7	));
	channels.push_back(Channel("?8",				DT_FLOAT,		7	));
	channels.push_back(Channel("?9",				DT_FLOAT,		7	));
	channels.push_back(Channel("?10",				DT_FLOAT,		7	));
	channels.push_back(Channel("?11",				DT_FLOAT,		7	));
	channels.push_back(Channel("?12",				DT_FLOAT,		7	));
	channels.push_back(Channel("?13",				DT_FLOAT,		7	));
	channels.push_back(Channel("?14",				DT_FLOAT,		7	));
	channels.push_back(Channel("?15",				DT_FLOAT,		7	));

	

	pulsetrigger=0;
	talkielevel=0;
	pulseprob=0;
	mvol=1;

	animframe[0]=animframe[1]=0;
	

	CalcChanX();
	return TRUE;
}



/////////////////////////////////////////////////////////////////////////////
// CThingDoc serialization

void CThingDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: add storing code here
		/*
		ChannelList channels;
		int maxtime;
		int scrollpos;
		int curchan;
		int curpos;
		int zoom;
		int selpos1,selpos2;
		int selchan1,selchan2;
		int numrows,lastrow;
		*/
		ar<<maxtime;
		ar<<scrollpos;
		ar<<scrollx;
		ar<<curchan;
		ar<<curpos;
		ar<<zoom;
		ar<<selpos1<<selpos2;
		ar<<selchan1<<selchan2;
		ar<<numrows<<lastrow;
		int i=channels.size();
		ar<<i;
		for (int c=0;c<i;c++)
		{
			ar<<channels[c].type;
			ar<<channels[c].width;
			ar<<channels[c].x;
			ar.Write(channels[c].name,32);
			int sz=channels[c].data.size();
			ar<<sz;
			DataIt it = channels[c].data.begin();
			for (int r=0;r<sz;r++) 
			{
				ar<<(it->time);
				ar<<(it->i);
				ar<<(it->more);
				++it;
			}
		}
	}
	else
	{
		OnNewDocument();
		ar>>maxtime;
		ar>>scrollpos;
		ar>>scrollx;
		ar>>curchan;
		ar>>curpos;
		ar>>zoom;
		ar>>selpos1>>selpos2;
		ar>>selchan1>>selchan2;
		ar>>numrows>>lastrow;

		ChannelList xchannels;		
		int i;
		ar>>i;
		xchannels.resize(i);
		for (int c=0;c<i;c++)
		{
			Channel &chan = (c<channels.size()) ? channels[c] : xchannels[c];
			Channel xchan;
			ar>>xchan.type;
			ar>>xchan.width;
			ar>>xchan.x;
			ar.Read(xchan.name,32);
			int sz;//=chan.data.size();
			ar>>sz;
			chan.data.clear();			
			for (int r=0;r<sz;r++) 
			{
				Data d;
				ar>>(d.time);
				ar>>(d.i);
				ar>>(d.more);
				chan.data.insert(d);
			}
		}
	}
}

/////////////////////////////////////////////////////////////////////////////
// CThingDoc diagnostics

#ifdef _DEBUG
void CThingDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CThingDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CThingDoc commands

BOOL CThingDoc::CanCloseFrame(CFrameWnd* pFrame) 
{
	// TODO: Add your specialized code here and/or call the base class
	return FALSE;
	
	return CDocument::CanCloseFrame(pFrame);
}

void CThingDoc::OnUpdateDogo(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable();
	pCmdUI->SetCheck(running);
}

void CThingDoc::OnDogo() 
{
	running=1;
	
}

void CThingDoc::OnDontgo() 
{
	running=0;
	
}

void CThingDoc::OnUpdateDontgo(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable();
	pCmdUI->SetCheck(!running);
	
}
extern int curframeidx;

void CThingDoc::OnMakeFilm()
{
	if (!realtime)
	{
		realtime=1;
		return;
	}
	StopPlaying();
	realtime=0;
	soundout->Close();
	delete soundout;
	soundout=NULL;

	playpos=STARTPOS;
	playpossub=0;
	curpos=STARTPOS;
	curframeidx = STARTPOS*4;
	RenderFrame();
	StartPlaying(STARTPOS);	
	curframeidx = STARTPOS*4;
	InitFilmOut();
	AfxGetMainWnd()->SetTimer(23,20,NULL);
}