// thingView.cpp : implementation of the CThingView class
//

#include "stdafx.h"
#include "thing.h"

#include "thingDoc.h"
#include "thingView.h"

#include "film.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


CThingView *CThingView::view=NULL;

/////////////////////////////////////////////////////////////////////////////
// CThingView

IMPLEMENT_DYNCREATE(CThingView, CView)

BEGIN_MESSAGE_MAP(CThingView, CView)
	//{{AFX_MSG_MAP(CThingView)
	ON_WM_ERASEBKGND()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_MBUTTONDOWN()
	ON_WM_MBUTTONUP()
	ON_WM_MOUSEWHEEL()
	ON_WM_MOUSEMOVE()
	ON_WM_RBUTTONDOWN()
	ON_WM_RBUTTONUP()
	ON_WM_HSCROLL()
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CThingView construction/destruction

CThingView::CThingView()
{
	mx=my=mw=0;
	mb=0;
	view=this;	

}

CThingView::~CThingView()
{
	
}

BOOL CThingView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CThingView drawing

void CThingView::OnDraw(CDC* pDC)
{
	CThingDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	// TODO: add draw code for native data here
}

/////////////////////////////////////////////////////////////////////////////
// CThingView printing

BOOL CThingView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CThingView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CThingView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

/////////////////////////////////////////////////////////////////////////////
// CThingView diagnostics

#ifdef _DEBUG
void CThingView::AssertValid() const
{
	CView::AssertValid();
}

void CThingView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CThingDoc* CThingView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CThingDoc)));
	return (CThingDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CThingView message handlers

void CThingView::OnInitialUpdate() 
{
	CView::OnInitialUpdate();
	
	if (!inited)
	{
#ifdef FINAL		
		Init(NULL,XRES,YRES);
#else
		Init(GetSafeHwnd(),XRES,YRES);
#endif
		InitFilm(GetDocument(),1);;
	}
	
	
}



BOOL CThingView::OnEraseBkgnd(CDC* pDC) 
{
	return -1;	
}

void CThingView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	//RenderFrame();
	SetCapture();
	mb|=1;
	mx=point.x;my=point.y;
	cx=mx;cy=my;

	
	CView::OnLButtonDown(nFlags, point);
}

void CThingView::OnLButtonUp(UINT nFlags, CPoint point) 
{
	mx=point.x;my=point.y;
	

	mb&=~1;
	ReleaseCapture();
	
	CView::OnLButtonUp(nFlags, point);
}

BOOL CThingView::OnMouseWheel(UINT nFlags, short zDelta, CPoint pt) 
{
	// TODO: Add your message handler code here and/or call default
	mw+=zDelta;
	
	return CView::OnMouseWheel(nFlags, zDelta, pt);
}

void CThingView::OnMouseMove(UINT nFlags, CPoint point) 
{
	mx=point.x;my=point.y;
	
	
	CView::OnMouseMove(nFlags, point);
}

void CThingView::OnRButtonDown(UINT nFlags, CPoint point) 
{
	mx=point.x;my=point.y;
	cx=mx;cy=my;
	mb|=2;
	SetCapture();
	CView::OnRButtonDown(nFlags, point);
}

void CThingView::OnRButtonUp(UINT nFlags, CPoint point) 
{
	mx=point.x;my=point.y;
	mb&=~2;
	ReleaseCapture();
	
	CView::OnRButtonUp(nFlags, point);
}

void CThingView::OnMButtonDown(UINT nFlags, CPoint point) 
{
	mx=point.x;my=point.y;
	cx=mx;cy=my;
	mb|=4;
	SetCapture();
	CView::OnMButtonDown(nFlags, point);
}

void CThingView::OnMButtonUp(UINT nFlags, CPoint point) 
{
	mx=point.x;my=point.y;
	mb&=~4;
	ReleaseCapture();
	
	CView::OnMButtonUp(nFlags, point);
}

void CThingView::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	// TODO: Add your message handler code here and/or call default
	
	CView::OnHScroll(nSBCode, nPos, pScrollBar);
}
