#include "GUILabel.h"

GUILabel::GUILabel(int x, int y, int w, int h, const char *callback, const char *label) : GUIElement(x, y, w, h, callback)
{
	this->widgetType = GUILABEL;
	this->label = label;
}

void GUILabel::setHolderPointer(GUIHolder *holder)
{
	this->holder = holder;
	int ww = holder->font->calculateWidth(label.c_str())+15;
	int hh = holder->font->calculateHeight(label.c_str())+8;

	if(w < ww) w = ww;
	if(h < hh) h = hh;
}

void GUILabel::render(float dt)
{
	this->GUIElement::render(dt);

	glBegin(GL_QUADS);
		glVertex2i(x,	y);
		glVertex2i(x+w,	y);
		glVertex2i(x+w,	y+h);
		glVertex2i(x,	y+h);
	glEnd();

	if(holder!=0)
	{
		holder->font->setColor(1,1,1);
		holder->font->printCenteredXY(label.c_str(), x+w/2, y+h/2);
	}
}

std::string GUILabel::checkKeyboardEvents(GUIKeyboardEvent &me)
{
	return "";
}

void GUILabel::writeToXml(TiXmlElement *parent)
{
	TiXmlElement *c = new TiXmlElement("Label");
	parent->LinkEndChild(c);
	c->SetAttribute("Label", this->label);
	c->SetAttribute("Callback", getCallback());

	c->SetDoubleAttribute("r", r);
	c->SetDoubleAttribute("g", g);
	c->SetDoubleAttribute("b", b);
}


void GUILabel::loadElement(TiXmlElement * element)
{
	double f;
	this->label = element->Attribute("Label");
	element->QueryDoubleAttribute("r", &f);
	r = f;
	element->QueryDoubleAttribute("g", &f);
	g = f;
	element->QueryDoubleAttribute("b", &f);
	b = f;
}
