#ifndef _GUITOGGLEBUTTON_H_
#define _GUITOGGLEBUTTON_H_

#include "GUIInclude.h"
#include "GUIEvent.h"
#include "GUIButton.h"
#include "GUIHolder.h"

class GUIHolder;
class GUIElement;
class GUIToggleButton : public GUIButton
{
public:
	
	GUIToggleButton() {};
	GUIToggleButton(int x, int y, int w, int h, const char *callback, const char *label, bool pressed);
	
	virtual void render(float dt);
	virtual std::string checkMousePressedEvents(GUIMousePressedEvent &me);
	virtual std::string checkKeyboardEvents(GUIKeyboardEvent &me);	

	virtual void setCanBeRaised(bool b);

	bool pressed;

	virtual bool getValue() { return pressed; };
	virtual void setValue(bool param) { pressed = param; };

	virtual void writeToXml(TiXmlElement *parent);
	virtual void loadElement(TiXmlElement * element);


protected:
	bool raisable; // can this be raised up by clicking
};


#endif