#ifndef _T3DVBO_HPP_
#define _T3DVBO_HPP_

// Use our own vector/matrix routines

#include "externs.hpp"
#include "mathematics.hpp"
#include "DemoTractor/t3d.hpp"


//--------------------------------------------------------------------------------------------
//  Helper types
//--------------------------------------------------------------------------------------------
struct T3DVBOLine
{
	int a,b;
};

class T3DVBOVert
{
public:
	float x;
	float y;
	float z;
};

class T3DVBOTexCoord							
{
public:
	float u;
	float v;
};

//--------------------------------------------------------------------------------------------
//  T3D - Traction 3D edge class
//--------------------------------------------------------------------------------------------

class T3DEdge
{
public:
	int face1, face2;
	int a, b;
};

// Tangent & bitang
class T3DTBN
{
public:
	Vector3 tangent;
	Vector3 bitangent;
};

//--------------------------------------------------------------------------------------------
//  T3D - Traction 3D object class
//--------------------------------------------------------------------------------------------

class T3DVBO
{	
	public:

		T3DVBO(T3D *t);
		~T3DVBO();
		
		T3D *model;	

		T3DEdge *getEdgeArray();
		int getEdgeCount();

		T3DTBN *getTBNArray();
		int getTBNCount();

		void render();

		void renderVBO();
		void freeVBO();
		void createVBO();

		void constructEdges();
		void freeEdges();
		void computeSilhouette(Vector3 lightPos);
		void drawSilhouette();
		void drawShadow(bool frontbackcap=false);

		void initializeTBN();
		bool isTBNinitialized();

		bool *getFacingLightArray();

	private:
		
		int edges;
		T3DEdge *edge;

		T3DTBN *tbns;
	
		// is face facing light or not
		bool *facingLight;
		Vector3 lightDir;

		// VBO
		bool VBOinit;
		GLuint vertBufferID;
		GLuint texBufferID;
		GLuint normalBufferID;
};


#endif