#include "boundedmovement.h"

BoundedMovement::BoundedMovement()
{
    this->init();
}

BoundedMovement::~BoundedMovement()
{
}

void BoundedMovement::selectNewDirection(float scale)
{
    //ollaan poissa sallitulta alueelta
    if (outOfBounds(this->position))
    {
        float a2 = 0;
        float b2 = 0;

        Vector3 temp = this->position;
        int iterations = 0;
        do
        {
            //kntyminen sujuu huonosti
            if (iterations > 5)
            {
                //joten arvotaan uusi suunta
                do
                {
                    a2 = Math::randBetween(0, 2*3.141592f);
                    b2 = Math::randBetween(0, 2*3.141592f);

                    Vector3 d = Vector3(sinf(a2)*sinf(b2), sinf(a2)*cosf(b2), cosf(a2)) * this->speed;
                    temp = this->position + d;

                } while (outOfBounds(temp));
                goto vittuun;
            }

            //kokeillaan knty
            a2 = this->a + Math::randBetween(-1, 1) * scale;
            b2 = this->b + Math::randBetween(-0.5f, 0.5f) * scale;
           
            Vector3 d = Vector3(sinf(a2)*sinf(b2), sinf(a2)*cosf(b2), cosf(a2)) * this->speed;
            temp = this->position + d;
            
            iterations++;

        } while (outOfBounds(temp) && iterations < 6);
        vittuun:

        this->a = a2;
        this->b = b2;

    }
    else
    {
        this->a += Math::randBetween(-1, 1) * scale;
        this->b += Math::randBetween(-0.5f, 0.5f) * scale;
    }


}

void BoundedMovement::init()
{
    this->position = Vector(0, 0, 0);
    this->speed = 0.0f;
    this->useBounds = false;

    this->setDirection(0, 0);
    this->setTurning(0, 0);
    this->setBoundLimits(0, 0, 0, 0, 0, 0);
}



void BoundedMovement::update()
{
    Vector3 d = Vector3(sinf(this->a)*sinf(this->b),   
                        sinf(this->a)*cosf(this->b), 
                        cosf(this->a)) * this->speed;

    this->previousposition = this->position;
    this->position += d;

    this->a += this->delta_a;
    this->b += this->delta_b;

    if (this->useBounds)
    {
        if (outOfBounds(this->position))
        {
            selectNewDirection();
            
        }
    }
}



void BoundedMovement::setBoundLimits(float x1, float x2, float y1, float y2, float z1, float z2)
{
    this->min_x = min(x1, x2);
    this->max_x = max(x1, x2);
    this->min_y = min(y1, y2);
    this->max_y = max(y1, y2);
    this->min_z = min(z1, z2);
    this->max_z = max(z1, z2);
}

bool BoundedMovement::outOfBounds(Vector3 &pos)
{
    return (pos.x < min_x || pos.x > max_x || 
            pos.y < min_y || pos.y > max_y || 
            pos.z < min_z || pos.z > max_z);
}

void BoundedMovement::turn(float da, float db)
{
    this->a += da;
    this->b += db;
}

void BoundedMovement::setUseBounds(bool bounds)
{
    this->useBounds = bounds;
}
Vector3 BoundedMovement::getPosition()
{
    return this->position;
}
Vector3 BoundedMovement::getPreviousPosition()
{
    return this->previousposition;
}

void BoundedMovement::setPosition(Vector3 &pos)
{
    this->position = pos;
    this->previousposition = pos;
}

void BoundedMovement::setDirection(float dir_a, float dir_b)
{
    this->a = dir_a;
    this->b = dir_b;
}

Vector3 BoundedMovement::getDirection()
{
    return Vector(this->speed, this->a, this->b);
}

void BoundedMovement::setTurning(float delta_a, float delta_b)
{
    this->delta_a = delta_a;
    this->delta_b = delta_b;
}

void BoundedMovement::setSpeed(float newspeed)
{
    this->speed = newspeed;
}

void BoundedMovement::turnTowards(Vector3 &target, float turnrate)
{
/*
   Vector3 d = Vector3(sinf(this->a)*sinf(this->b),   
                        sinf(this->a)*cosf(this->b), 
                        cosf(this->a)) * this->speed;

    this->position += d;
*/
/*
    Vector3 v1 = this->position;
    Vector3 v2 = target.position;

    Vector3 dir = v2 - v1;
    Vector3 coord = Math::cartesianToSphere(dir.x, dir.y, dir.z);

    float da = coord.y - this->a;
    float db = coord.z - this->b;

    this->a += da * turnrate;
    this->b += db * turnrate;

*/
        Vector3 direction = target - this->position;
        Vector3 temp = Math::cartesianToSphere(direction.x, direction.y, direction.z);
        float dest_direction_a = temp.y;
        float dest_direction_b = temp.z;

        float direction_delta_a = (dest_direction_a - this->a)*0.01f;
        float direction_delta_b = (dest_direction_b - this->b)*0.01f;
        
        const float epsilon = 0.01f;
        //turn
        if (fabsf(this->a - dest_direction_a) > epsilon)
        {
            this->a += direction_delta_a;
        }
        if (fabsf(this->b - dest_direction_b) > epsilon)
        {
            this->b += direction_delta_b;
        }
}