#ifndef _BOUNDEDMOVEMENT_H_
#define _BOUNDEDMOVEMENT_H_

#include "externs.hpp"

class BoundedMovement
{
    friend class BoundedMovement;
public:
    BoundedMovement();
    ~BoundedMovement();

    //update-sykli
    void update();
    void turn(float da, float db);
    bool outOfBounds(Vector3 &pos);
    void selectNewDirection(float scale = 0.2f);
    void turnTowards(Vector3 &target, float turnrate);

    //aksessorit
    void init();
    void setUseBounds(bool bounds);
    void setPosition(Vector3 &pos);
    Vector3 getPosition();
    Vector3 getPreviousPosition();
    Vector3 getDirection();
    void setDirection(float dir_a, float dir_b);
    void setTurning(float delta_a, float delta_b);
    void setSpeed(float newspeed);
    void setBoundLimits(float x1, float x2, float y1, float y2, float z1, float z2);
    
private:

    bool useBounds;

    //paikkatiedot ja suunnan pallokoordinaatit
    Vector3 position;
    Vector3 previousposition;
    float speed;
    float a;
    float b;
    float delta_a;
    float delta_b;

    float min_x;
    float max_x;
    float min_y;
    float max_y;
    float min_z;
    float max_z;

};

#endif