#include "bpm.hpp"

//  value = beats per min | offset - time between ticks
BPM::BPM(float value, int offset)
{
	this->framecount = 0;
	this->value = (float)value;
	this->offset = offset;
	this->previousbeatdist = 0;

	changed = false;

}

BPM::~BPM()
{
	this->framecount = 0;
	this->value = 0;
	this->offset = 0;
	this->previousbeatdist = 0;

}

float BPM::getValue()
{
	const int bpmmicroseconds = (int)(60000000/value);
	int aika = dmsGetModulePosition();//(int)(dmsGetTimeMs());    
	aika *= 1000;

	changed = false;

	//lasketaan etisyys biittiin
	int beatdist = (aika + offset) % bpmmicroseconds;

	if (beatdist < previousbeatdist)
	{
		changed = true;
		framecount++;
	}

	float beat = (bpmmicroseconds-beatdist)/(float)bpmmicroseconds;

	previousbeatdist = beatdist;
	return beat;
}

int BPM::getBeatcount()
{
	return this->framecount;
}

bool BPM::getChanged()
{
	return this->changed;
}