#ifdef _DEBUG
	#include <stdlib.h>
	//#include "../mmgr.h"
#endif

#include <math.h>

#include "3DTest.h"
#include "../mathematics.hpp"
#include "../primitives.hpp"

void T3DTest::draw()
{
	const float pos = (time - startTime) / (endTime - startTime);
	float alpha = 1.0f;

	const float fadeinstart = 0.0f;
	const float fadeinstop = 0.01f;
	const float fadeoutstart = 0.90f;
	const float fadeoutstop = 1.0f;

	if (pos >= fadeinstart && pos <= fadeinstop)
		alpha *= (pos-fadeinstart) / (fadeinstop-fadeinstart);
	if (pos >= fadeoutstart && pos <= fadeoutstop)
		alpha *= 1-(pos-fadeoutstart) / (fadeoutstop-fadeoutstart);

	filter.init();
	render3ds(pos, alpha);
	filter.glow(4, 0.008f, 0.008f, 0.92f /* + tool->getValue("slider1")*/ , -1.0f, 0.950f); 
	//filter.coloradjust(0.9f, 1.0f, 2.5f);
	//filter.motionBlur();//.glow(5, 0.0312f, 0.0312f);
	//filter.dof();

}

void T3DTest::renderScene(float pos, float alpha)
{

}

T3DTest::T3DTest()
{	

}

T3DTest::~T3DTest()
{
	if(model != 0)
	{
		model->freeVBO();
		delete model;
	}
}


bool T3DTest::init(unsigned long s, unsigned long e)
{
	model = 0;
	model = new T3DVBO(dmsGetObject("3djytky3.t3d"));
	model->createVBO();
	model->initializeTBN();

	startTime = s;
	endTime = e;
	return true;
}



void T3DTest::render3ds(float pos, float alpha)
{

	glDisable(GL_BLEND);
	glEnable(GL_DEPTH_TEST);
	glDisable(GL_TEXTURE_2D);
	

	glLoadIdentity();

	gluLookAt(0, 0, -250,
			0, 0, 0,
			0, 1, 0);
	glColor3f(1,1,1);


/**/
	
	glActiveTextureARB(GL_TEXTURE0_ARB);
    glEnable(GL_TEXTURE_2D);
    glBindTexture(GL_TEXTURE_2D, dmsGetTexture("deeptxt2.jpg")->getID());

    glActiveTextureARB(GL_TEXTURE1_ARB);
    glEnable(GL_TEXTURE_2D);
    glBindTexture(GL_TEXTURE_2D, dmsGetTexture("normal_map_deep2.jpg")->getID());

    //Vector3 g_lightPos = Vector3(4, 4, 4);
	float g_lightPos[4] = {-1,1,-4,0};

    glPushAttrib(GL_LIGHTING_BIT);

        glLightfv(GL_LIGHT0, GL_POSITION, g_lightPos);

		Shader *nmap = shaders->getShader("normal_mapping");
		nmap->bind();
		nmap->setUniform1i("colorMap", 0);
		nmap->setUniform1i("normalMap", 1);
  

		glPushMatrix();
			
			glScalef(0.4f,0.4f,0.4f);

			glRotatef(pos*919.0f+175, -0.64f+sin((1-pos*pos*pos*pos)*3.0f), -0.34f*sinf(pos*4.2f*pos), 0.7f*pos*pos);

				

				int objectvertexcount		= model->model->getVertexCount();
				int objectfacecount			= model->model->getFaceCount();
				T3DFace *objectfaces		= model->model->getFaceArray();
				T3DVertex *objectvertices	= model->model->getVertexArray();
				T3DTBN *tbns				= model->getTBNArray();


				glBegin(GL_TRIANGLES);
					for (int i=0;i<objectfacecount;i++)
					{
						glNormal3fv((float *)&objectfaces[i].normal);
						glMultiTexCoord2fARB(GL_TEXTURE0_ARB, objectvertices[objectfaces[i].a].u, objectvertices[objectfaces[i].a].v);
						glMultiTexCoord4fARB(GL_TEXTURE1_ARB, tbns[i].tangent.x, tbns[i].tangent.y, tbns[i].tangent.z, 0);
						glVertex3fv((float *)&objectvertices[objectfaces[i].a].position);

						glNormal3fv((float *)&objectfaces[i].normal);
						glMultiTexCoord2fARB(GL_TEXTURE0_ARB, objectvertices[objectfaces[i].b].u, objectvertices[objectfaces[i].b].v);
						glMultiTexCoord4fARB(GL_TEXTURE1_ARB, tbns[i].tangent.x, tbns[i].tangent.y, tbns[i].tangent.z, 0);
						glVertex3fv((float *)&objectvertices[objectfaces[i].b].position);

						glNormal3fv((float *)&objectfaces[i].normal);
						glMultiTexCoord2fARB(GL_TEXTURE0_ARB, objectvertices[objectfaces[i].c].u, objectvertices[objectfaces[i].c].v);
						glMultiTexCoord4fARB(GL_TEXTURE1_ARB, tbns[i].tangent.x, tbns[i].tangent.y, tbns[i].tangent.z, 0);
						glVertex3fv((float *)&objectvertices[objectfaces[i].c].position);
					}
				glEnd();

		glPopMatrix();

		nmap->unbind();

    glPopAttrib();

    glActiveTextureARB(GL_TEXTURE1_ARB);
    glDisable(GL_TEXTURE_2D);

	glActiveTextureARB(GL_TEXTURE0_ARB);
    glDisable(GL_TEXTURE_2D);


}