#ifdef _DEBUG
	#include <stdlib.h>
	//#include "../mmgr.h"
#endif

#include <math.h>

#include "3DTest2.h"
#include "../mathematics.hpp"
#include "../primitives.hpp"

// lookup table for noise
int perm[256]= {151,160,137,91,90,15,
  131,13,201,95,96,53,194,233,7,225,140,36,103,30,69,142,8,99,37,240,21,10,23,
  190, 6,148,247,120,234,75,0,26,197,62,94,252,219,203,117,35,11,32,57,177,33,
  88,237,149,56,87,174,20,125,136,171,168, 68,175,74,165,71,134,139,48,27,166,
  77,146,158,231,83,111,229,122,60,211,133,230,220,105,92,41,55,46,245,40,244,
  102,143,54, 65,25,63,161, 1,216,80,73,209,76,132,187,208, 89,18,169,200,196,
  135,130,116,188,159,86,164,100,109,198,173,186, 3,64,52,217,226,250,124,123,
  5,202,38,147,118,126,255,82,85,212,207,206,59,227,47,16,58,17,182,189,28,42,
  223,183,170,213,119,248,152, 2,44,154,163, 70,221,153,101,155,167, 43,172,9,
  129,22,39,253, 19,98,108,110,79,113,224,232,178,185, 112,104,218,246,97,228,
  251,34,242,193,238,210,144,12,191,179,162,241, 81,51,145,235,249,14,239,107,
  49,192,214, 31,181,199,106,157,184, 84,204,176,115,121,50,45,127, 4,150,254,
  138,236,205,93,222,114,67,29,24,72,243,141,128,195,78,66,215,61,156,180};
int grad3[16][3] = {{0,1,1},{0,1,-1},{0,-1,1},{0,-1,-1},
                   {1,0,1},{1,0,-1},{-1,0,1},{-1,0,-1},
                   {1,1,0},{1,-1,0},{-1,1,0},{-1,-1,0},
                   {1,0,-1},{-1,0,-1},{0,-1,1},{0,1,1}};

void T3DTest2::draw()
{
	const float pos = (time - startTime) / (endTime - startTime);
	float alpha = 1.0f;

	const float fadeinstart = 0.0f;
	const float fadeinstop = 0.01f;
	const float fadeoutstart = 0.90f;
	const float fadeoutstop = 1.0f;

	if (pos >= fadeinstart && pos <= fadeinstop)
		alpha *= (pos-fadeinstart) / (fadeinstop-fadeinstart);
	if (pos >= fadeoutstart && pos <= fadeoutstop)
		alpha *= 1-(pos-fadeoutstart) / (fadeoutstop-fadeoutstart);

	render3ds(pos, alpha);
}

void T3DTest2::renderScene(float pos, float alpha)
{

}

T3DTest2::T3DTest2()
{	

}

T3DTest2::~T3DTest2()
{
	if(model != 0)
	{
		model->freeVBO();
		delete model;
	}
}


bool T3DTest2::init(unsigned long s, unsigned long e)
{
	model = 0;
	model = new T3DVBO(dmsGetObject("3djytky3.t3d"));
	model->createVBO();
	model->initializeTBN();

	char *pixels;
	int i,j;
  
	glGenTextures(1, &permTextureID); // Generate a unique texture ID
	glBindTexture(GL_TEXTURE_2D, permTextureID); // Bind the texture to texture unit 2

	int offset, value;
	const int size = 256*256*4;
	pixels = (char*)malloc( size );
	for(i = 0; i<256; i++)
	{
		for(j = 0; j<256; j++) 
		{
		  offset = (i*256+j)*4;
		  value = perm[(j+perm[i]) & 0xFF];
		  pixels[offset] = grad3[value & 0x0F][0] * 64 + 64;
		  pixels[offset+1] = grad3[value & 0x0F][1] * 64 + 64;
		  pixels[offset+2] = grad3[value & 0x0F][2] * 64 + 64;
		  pixels[offset+3] = value;
		}
	}
	glTexImage2D( GL_TEXTURE_2D, 0, GL_RGBA, 256, 256, 0, GL_RGBA, GL_UNSIGNED_BYTE, pixels );
	glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST ); // NEAREST filtering, because 
	glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST ); // this is a lookup table!

	startTime = s;
	endTime = e;
	return true;
}



void T3DTest2::render3ds(float pos, float alpha)
{

	glDisable(GL_BLEND);
	glEnable(GL_DEPTH_TEST);
	glDisable(GL_TEXTURE_2D);

	//glEnable(GL_BLEND);
	//glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	

	glLoadIdentity();

	gluLookAt(0, 0, -200,
			0, 0, 0,
			0, 1, 0);
	glColor3f(1,1,1);


/**/
/*	
	glActiveTextureARB(GL_TEXTURE0_ARB);
    glEnable(GL_TEXTURE_2D);
    glBindTexture(GL_TEXTURE_2D, dmsGetTexture("deeptxt2.jpg")->getID());

    glActiveTextureARB(GL_TEXTURE1_ARB);
    glEnable(GL_TEXTURE_2D);
    glBindTexture(GL_TEXTURE_2D, dmsGetTexture("normal_map_deep2.jpg")->getID());
*/
    //Vector3 g_lightPos = Vector3(4, 4, 4);
				
	glActiveTextureARB(GL_TEXTURE0_ARB);
	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, permTextureID);
	
Vector3 c = Vectr3();//tool->getColor("color1");
glColor4f(c.x,c.y,c.z,0);// tool->getValue("slider1"));


	float g_lightPos[4] = {-1,1,-4,0};

    glPushAttrib(GL_LIGHTING_BIT);

        glLightfv(GL_LIGHT0, GL_POSITION, g_lightPos);

		Shader *shad = shaders->getShader("noise");
		shad->bind();
		shad->setUniform1f("bound", tool->getValue("slider3"));
		shad->setUniform1i("pTexture", 0);
		shad->setUniform1f("time", dmsGetModulePosition());

		glPushMatrix();
			
			glScalef(0.4f,0.4f,0.4f);

			glRotatef(pos*919.0f+175, -0.64f+sin((1-pos*pos*pos*pos)*3.0f), -0.34f*sinf(pos*4.2f*pos), 0.7f*pos*pos);


				int objectvertexcount		= model->model->getVertexCount();
				int objectfacecount			= model->model->getFaceCount();
				T3DFace *objectfaces		= model->model->getFaceArray();
				T3DVertex *objectvertices	= model->model->getVertexArray();
				T3DTBN *tbns				= model->getTBNArray();


				glBegin(GL_TRIANGLES);
					for (int i=0;i<objectfacecount;i++)
					{
						glNormal3fv((float *)&objectfaces[i].normal);
						glMultiTexCoord2fARB(GL_TEXTURE0_ARB, objectvertices[objectfaces[i].a].u, objectvertices[objectfaces[i].a].v);
						glMultiTexCoord4fARB(GL_TEXTURE1_ARB, tbns[i].tangent.x, tbns[i].tangent.y, tbns[i].tangent.z, 0);
						glVertex3fv((float *)&objectvertices[objectfaces[i].a].position);

						glNormal3fv((float *)&objectfaces[i].normal);
						glMultiTexCoord2fARB(GL_TEXTURE0_ARB, objectvertices[objectfaces[i].b].u, objectvertices[objectfaces[i].b].v);
						glMultiTexCoord4fARB(GL_TEXTURE1_ARB, tbns[i].tangent.x, tbns[i].tangent.y, tbns[i].tangent.z, 0);
						glVertex3fv((float *)&objectvertices[objectfaces[i].b].position);

						glNormal3fv((float *)&objectfaces[i].normal);
						glMultiTexCoord2fARB(GL_TEXTURE0_ARB, objectvertices[objectfaces[i].c].u, objectvertices[objectfaces[i].c].v);
						glMultiTexCoord4fARB(GL_TEXTURE1_ARB, tbns[i].tangent.x, tbns[i].tangent.y, tbns[i].tangent.z, 0);
						glVertex3fv((float *)&objectvertices[objectfaces[i].c].position);
					}
				glEnd();

		glPopMatrix();

		shad->unbind();

    glPopAttrib();

	glActiveTextureARB(GL_TEXTURE0_ARB);
    glDisable(GL_TEXTURE_2D);

}