#ifdef _DEBUG
	#include <stdlib.h>
//	#include "../mmgr.h"
#endif

#include <math.h>


#include "caustic.h"
#include "../mathematics.hpp"
#include "../primitives.hpp"
#include "../matrix4.hpp"

void Caustic::draw()
{
	const float pos = (time - startTime) / (endTime - startTime);
	float alpha = 1.0f;

	const float fadeinstart = 0.0f;
	const float fadeinstop = 0.1f;
	const float fadeoutstart = 0.90f;
	const float fadeoutstop = 1.0f;

	if (pos >= fadeinstart && pos <= fadeinstop)
		alpha *= (pos-fadeinstart) / (fadeinstop-fadeinstart);
	if (pos >= fadeoutstart && pos <= fadeoutstop)
		alpha *= 1-(pos-fadeoutstart) / (fadeoutstop-fadeoutstart);


	renderScene(pos, alpha);
}

void Caustic::renderScene(float pos, float alpha)
{

/*
    Vector3 cam = Vector3(0, 6, -20);
    Vector3 tgt = Vector3(0, 0, 0);
    Vector3 upw = Vector3(0, 1, 0);

    glLoadIdentity();
    gluLookAt(cam.x, cam.y, cam.z, tgt.x, tgt.y, tgt.z, upw.x, upw.y, upw.z);
*/
	int i;

	//cam->useCamera(4);

	glColor3f(1,1,1);
	glEnable(GL_TEXTURE_2D);


	// -----------------
	// Common stuff
	// -----------------

	//Vector lightDirection = Mathematics::sphereToCartesian(5.50f+pos*0.1f, 24+pos*0.20f, 2.50f+pos*0.6f).normalize();
	//Vector lightDirection = Math::sphereToCartesian(5.50f+pos*0.1f, 24+pos*0.20f, 5.50f+pos*0.6f).normalize();
	Vector lightDirection = Math::sphereToCartesian(5.50f+pos*0.1f, 24+pos*0.20f, -4.50f+pos*0.6f).normalize();

   
	// ------------------
	// Caustic
	// ------------------

	// Caustic numero
	int n = int(pos*32*20)%32 + 1;
	
	// Haetaan vastaava tekstuuri
	char buf[75];
	sprintf(buf, "cau_0%02d.jpg", n);
	Texture *t = dmsGetTexture(buf);


	const float mod = 25.0f;
	Vector3 ca = Vector3() + Vector3(lightDirection.x*mod, lightDirection.y*mod, lightDirection.z*mod);
	Vector3 tgt = Vector3(0, 0, 0);
	Vector3 upw = Vector3(0, 1, 0);

	glLoadIdentity();
	gluLookAt(ca.x, ca.y, ca.z, tgt.x, tgt.y, tgt.z, upw.x, upw.y, upw.z);

	Matrix4 light_mat_proj;
	glGetFloatv(GL_PROJECTION_MATRIX, light_mat_proj);

	Matrix4 light_mat_modelview;
	glGetFloatv(GL_MODELVIEW_MATRIX, light_mat_modelview);


	// ------------------
	// light rays
	// ------------------

	glColor3f(1,1,1);

	//glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);

	glLoadIdentity();
	
	
//
	Vector cam = Vector(0, 0, 30);
	Vector tar = Vector(0, 0, 0);
	Vector upwards = Vector(0, 1, 0);

	gluLookAt(cam.x, cam.y, cam.z, 
			  tar.x, tar.y, tar.z, 
			  upwards.x, upwards.y, upwards.z);
	
	//cameras->useCamera(0, 8.0f);

	// -----------------
	// Fix texture settings 
	// -----------------

	glMatrixMode(GL_TEXTURE);
	glLoadIdentity();  // clear things up
	glTranslatef(0.5, 0.5, 0.5); // we have to clamp values in the [0.0, 1.0] range, not [-1.0, 1.0]
	glScalef(0.5, 0.5, 0.5);
	glMultMatrixf(light_mat_proj); // now multiply by the matrices we have retrieved before
	glMultMatrixf(light_mat_modelview);

	// finally, multiply by the *inverse* of the *current* modelview matrix
	Matrix4 s_mat_m2;
	glGetFloatv(GL_MODELVIEW_MATRIX, s_mat_m2);

	// Invert [hacky shit]
	s_mat_m2 = s_mat_m2.makeInverseTranspose();
	s_mat_m2 = s_mat_m2.makeTranspose();

	glMultMatrixf(s_mat_m2);
	glMatrixMode(GL_MODELVIEW);

	glEnable(GL_BLEND);
	glBlendFunc(GL_ONE, GL_ONE);

	Vector3 x,y,z;
	Math::antiRotate(&x,&y,&z);

	glColor4f(1,1,1,1);
	Shader *lightray = shaders->getShader("lightray");
	lightray->bind();
	
	glActiveTextureARB(GL_TEXTURE0_ARB);
	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, t->getID());
	lightray->setUniform1i("caustic", 0);

		glActiveTextureARB(GL_TEXTURE1_ARB);
		 glEnable(GL_TEXTURE_2D);
		 glBindTexture(GL_TEXTURE_2D, glExt.depthTex);
		 lightray->setUniform1i("shadowMap", 1);  
 

	Vector kohta = Vector(0,0,-10);

	const int amount = 15;
	
	glBegin(GL_QUADS);

	// Miten vitussa ts saa rendattuu ruudunkokosii
	const float scale = 35.0f;

		for(i=0; i<amount; i++)
		{
			
			kohta.z += 0.5f;

			// Optimize me beautiful	
			
				Vector v1 = kohta - x*scale - y*scale;
				Vector v2 = kohta + x*scale - y*scale;
				Vector v3 = kohta + x*scale + y*scale;
				Vector v4 = kohta - x*scale + y*scale;

				glTexCoord2f(0, 0);
				glVertex3fv((float *)&v1);
				glTexCoord2f(1, 0);
				glVertex3fv((float *)&v2);
				glTexCoord2f(1, 1);
				glVertex3fv((float *)&v3);
				glTexCoord2f(0, 1);
				glVertex3fv((float *)&v4);

		}

	glEnd();

		glActiveTextureARB(GL_TEXTURE1);
		glBindTexture(GL_TEXTURE_2D, 0);
		glDisable(GL_TEXTURE_2D);
		

	glActiveTextureARB(GL_TEXTURE0);
	glBindTexture(GL_TEXTURE_2D, 0);
	glDisable(GL_TEXTURE_2D);
	
					
	lightray->unbind();

	glMatrixMode(GL_TEXTURE);
	glLoadIdentity();
    glEnable(GL_TEXTURE_2D);
    glMatrixMode(GL_MODELVIEW);

}




Caustic::Caustic()
{	
}

Caustic::~Caustic()
{
}


bool Caustic::init(unsigned long s, unsigned long e)
{

	startTime = s;
	endTime = e;
	return true;
}
