//#define PASKA_NVIDIA 
//#define DISABLE_CULLING


#ifdef _DEBUG
	#include <stdlib.h>
	//#include "../mmgr.h"
#endif

#include <math.h>

#include "fisut.h"
#include "../config.hpp" // Config::
#include "../mathematics.hpp"
#include "../primitives.hpp"
#include "../matrix4.hpp"

Matrix4 light_mat_modelview, light_mat_proj;

Vector cameraPosition;
Vector lightPosition;
Vector cameraTarget;

float liikemodi1;
float liikemodi2;
float liikemodi3;

extern void setClearColor(Vector3 color);
void Fisut::draw()
{
	setClearColor(Vector3(0,0,0));
	const float pos = (time - startTime) / (endTime - startTime);
	float alpha = 1.0f;

	const float fadeinstart = 0.0f;
	const float fadeinstop = 0.1f;
	const float fadeoutstart = 0.90f;
	const float fadeoutstop = 1.0f;

	if (pos >= fadeinstart && pos <= fadeinstop)
		alpha *= (pos-fadeinstart) / (fadeinstop-fadeinstart);
	if (pos >= fadeoutstart && pos <= fadeoutstop)
		alpha *= 1-(pos-fadeoutstart) / (fadeoutstop-fadeoutstart);

	
	//if(dmsGetKey(VK_F3)) filter.initDOF();
	//else filter.init(true);
	liikemodi1 = 4.0f * 0.3f;//tool->getValue("slider2");
	liikemodi2 = 4.0f * 0.1f;//tool->getValue("slider3");
	liikemodi3 = 4.0f * 0.05f;//tool->getValue("slider4");

	render3ds(pos, alpha);
	glColor3f(1,1,1);
	//if(dmsGetKey(VK_F3)) filter.dof();
	//else filter.glow(6, 0.008f, 0.008f, 0.85f , -1.0f, 1.0f); 
}

void Fisut::renderScene(float pos, float alpha)
{

}

Fisut::Fisut()
{	

}

Fisut::~Fisut()
{
	if(model != 0)
	{
		model->freeVBO();
		delete model;
	}
}

bool Fisut::init(unsigned long s, unsigned long e)
{
	model = 0;
	model = new T3DVBO(dmsGetObject("fisu.t3d"));
	model->createVBO();
	model->initializeTBN();
	
	animatedvertices = new T3DVertex[model->model->getVertexCount()];

	const float yMin = -0.01f;

	const float size2 = 0.60f;
    const int groundX = 50;
    const int groundY = 50;
    this->merenpohja = new GroundPlane(groundX, groundY, size2, 5.5f, yMin);
    this->merenpohja->makeCircularFade(1.0f, 0.35f);

	const float scale = 1.150f;
	const float scalex = 2.050f;
	pcount = 750;
	srand(23343);
	particlet = new Vector3[pcount];
	for(int i=0; i<pcount; i++)
	{
		particlet[i] = Math::randVector()*scale;
		particlet[i].y = Math::randBetween(yMin+0.025f, scale*0.08f);
		particlet[i].x = Math::randBetween(-scalex, scale);
	}

	startTime = s;
	endTime = e;
	return true;
}

static float timeMod; 

void Fisut::framePreCalc(float pos)
{
	timeMod = dmsGetModulePosition()*0.006f*0.75f;
	timeMod += powf(sinf(dmsGetModulePosition()*0.125f), 4) * 0.057f;//tool->getValue("slider6") * 0.1f;

	int objectvertexcount		= model->model->getVertexCount();
	int objectfacecount			= model->model->getFaceCount();
	T3DFace *objectfaces		= model->model->getFaceArray();
	T3DVertex *objectvertices	= model->model->getVertexArray();

	const int idx = 1;
	for (int i=0; i<objectfacecount; i++)
	{
		animatedvertices[objectfaces[i].a].position = animoiKalaa(objectvertices[objectfaces[i].a].position, pos, idx);
		animatedvertices[objectfaces[i].b].position = animoiKalaa(objectvertices[objectfaces[i].b].position, pos, idx);
		animatedvertices[objectfaces[i].c].position = animoiKalaa(objectvertices[objectfaces[i].c].position, pos, idx);
	}
}



Vector3 Fisut::animoiKalaa(Vector3 z, float pos, int idx)
{
// step function

	//const float boundpaa = 15.0f;
	const float boundmaha = -5.0f;
	//const float boundmaha = -20.0f;
	
	/**/

	/*

	if(z.x < boundpaa)
	{
		Vector3 x = Vector3(z.x, z.y, z.z);
		float sinx = boundpaa - z.x;
		float mod = sin(3.14f+timeMod+idx)*0.250f * (sinx *sinx / (boundpaa*boundpaa));
		x.z += mod*1.5;
		x.y += mod*0.939f;
		return x;
	}
	else
	{

		// y modi
		const float dd = 0 - 150;
		const float ddinv= 1.0f/dd;
		float d = boundpaa - z.x;
		float dmod = sinf(3.14f*d*ddinv);
		z += Vector3(0,sinf(timeMod*0.25f)*3.50f*dmod,0);;//*0.0;


		Vector3 x = Vector3(z.x, z.y, z.z);
		float sinx = z.x - boundpaa;
		float mod = sin(sinx)*0.07f + sin(timeMod+(sinx)*0.005f+idx)*0.0750f * (sinx * sinx * 0.01f);
		x.z += mod;
		x.y += mod*0.19f;
		return x;
	}
	/**/
/**/

// SCALE

	Vector3 x = Vector3(z.x, z.y, z.z);
	float sinx = (z.x - boundmaha)*0.56f*3.0f * liikemodi1;
	if(z.x < boundmaha)
	{
		sinx *= 0.44f * 4.0f;
	}
	float mod = sin(timeMod+(sinx)*0.0095f+idx)*0.0750f * (sinx * sinx * 0.0065f);//* sinx * sinx * 0.000045f);
	//float mod = sin(timeMod+(sinx)*0.0095f+idx)*0.0750f * (sinx * 1.050025f);//* sinx * sinx * 0.000045f);
	float dmod = 0.480f;//tool->getValue("slider5")*2.;
	if(z.x < boundmaha)
	{
		//float dx = z.x;
		//dmod = 0.45f;//1.1f * dx / boundpaa;
		dmod = 0.005f;
	}
	x.z += mod*dmod * liikemodi2;
	x.y += mod*0.19f * liikemodi3;
	return x;
/**/
}


void Fisut::drawModels(float pos, float alpha, bool postproc)
{
	const float M = 1.0f;
	const Vector3 p[3] = 
	{
		//Vector3(0,0,0),
		Vector3(0,0.03f,0),//-1.0f+pos*0.35f,	-0.59f,  -0.40f )*M,
		Vector3( 1.0f+pos*1.5f,	-0.02f,		 0.2f  )*M,
		Vector3( 0.0f+pos*3.5f,	 0.03f,		 1.0f  )*M,

	};
	
    Vector3 *vertices = this->merenpohja->getVertices();
    TTexCoord *uv = this->merenpohja->getUVs();
	int xres = this->merenpohja->getXres();
	int yres = this->merenpohja->getYres();
	float *fade = this->merenpohja->getFade();

	int x,y;
    //glDepthMask(0);
	glEnable(GL_DEPTH_TEST);

	Shader *ss;
if(postproc)
{
	glMatrixMode(GL_TEXTURE);
	glLoadIdentity();  
	glTranslatef(0.5, 0.5, 0.5); 	// [0.0, 1.0], not [-1.0, 1.0]
	glScalef(0.5, 0.5, 0.5);
	glMultMatrixf(light_mat_proj); 	// multiply texture matrix
	glMultMatrixf(light_mat_modelview);
	// finally, multiply by the *inverse* of the *current* modelview matrix
	Matrix4 s_mat_m;
	glGetFloatv(GL_MODELVIEW_MATRIX, s_mat_m);

	// Invert matrix
	s_mat_m = s_mat_m.makeInverseTranspose();
	s_mat_m = s_mat_m.makeTranspose();

	glMultMatrixf(s_mat_m);
	glMatrixMode(GL_MODELVIEW);
		
	// Bind your shadowmapping shader
	
	 ss = shaders->getShader("fisu_shadowmaptex");
	 ss->bind(); 

	 // Bind shadow texture & pass it to shader
	 glActiveTextureARB(GL_TEXTURE0_ARB);
	 glEnable(GL_TEXTURE_2D);
	 glBindTexture(GL_TEXTURE_2D, glExt.depthTex);
	 // set compare mode on..
if(Config::nv7)
{
	 glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_COMPARE_MODE, GL_COMPARE_R_TO_TEXTURE_ARB);
	 glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_COMPARE_FUNC, GL_LEQUAL);
}
	 ss->setUniform1i("shadowMap", 0);  
	 ss->setUniform1i("texture0", 1);  
	 ss->setUniform1i("normal0", 2);  
	 ss->setUniform1i("caus0", 3);  
	 ss->setUniform1i("caus1", 4);

	 //ss->setUniform1i("occlusion0", 3);  
	glActiveTextureARB(GL_TEXTURE1_ARB);
	 glEnable(GL_TEXTURE_2D);
	 glBindTexture(GL_TEXTURE_2D, dmsGetTexture("deeptxt3.jpg")->getID());

	glActiveTextureARB(GL_TEXTURE2_ARB);
	 glEnable(GL_TEXTURE_2D);
	 glBindTexture(GL_TEXTURE_2D, dmsGetTexture("normal_map_deep3.jpg")->getID());

	 const int texturesPerRun = 32*4;
	 const float timeperTexture = 1.0f/float(texturesPerRun);
	 float timeyli = fmodf(pos, timeperTexture);

	 int n = int(pos*texturesPerRun)%32 + 1;
	 int next = int(pos*texturesPerRun+1)%32 + 1;	
	 char buf[75];
	 sprintf(buf, "cau_0%02d.jpg", n);
	 Texture *t1 = dmsGetTexture(buf);
	 char buf2[75];
	 sprintf(buf2, "cau_0%02d.jpg", next);
	 Texture *t2 = dmsGetTexture(buf2);

	 ss->setUniform1f("causinterp", timeyli/float(timeperTexture));

	 glActiveTextureARB(GL_TEXTURE3_ARB);
	 glEnable(GL_TEXTURE_2D);
	 glBindTexture(GL_TEXTURE_2D, t1->getID());
		//glBindTexture(GL_TEXTURE_2D, t->getID());

	 glActiveTextureARB(GL_TEXTURE4_ARB);
	 glEnable(GL_TEXTURE_2D);
	 glBindTexture(GL_TEXTURE_2D, t2->getID());
	 /*
	glActiveTextureARB(GL_TEXTURE3_ARB);
	 glEnable(GL_TEXTURE_2D);
	 glBindTexture(GL_TEXTURE_2D, dmsGetTexture("occlusion_map_deep3.jpg")->getID());
	*/

}
else
{
     glEnable(GL_TEXTURE_2D);
     glDisable(GL_BLEND);
     glBindTexture(GL_TEXTURE_2D, dmsGetTexture("deeptxt3.jpg")->getID());
}
	
	const float ROTATE_ANGLE = 35;

	const float TEXMOVEU = -pos * 7.2f * cos(ROTATE_ANGLE*0.0174532925f);
	const float TEXMOVEV = -pos * 7.2f * sin(ROTATE_ANGLE*0.0174532925f);
	float COLMOD = 0.325f;//tool->getValue("slider1");//0.294575;

	

	float g_li[4] = {lightPosition.x, lightPosition.y, lightPosition.z,0};
	glPushMatrix();

	glRotatef(ROTATE_ANGLE, 0,1,0);

	glPushAttrib(GL_LIGHTING_BIT);
        glLightfv(GL_LIGHT0, GL_POSITION, g_li); 
		
        for (y = 0; y < yres - 1; y++)
        {
            int offs = y * xres;

            glBegin(GL_QUAD_STRIP);
            for (x = 0; x < xres; x++)
            {
                float a1 = COLMOD * fade[offs];
                float a2 = COLMOD * fade[offs + xres];
                glColor3f(a1, a1, a1);
				glTexCoord2f(uv[offs].u+TEXMOVEU, uv[offs].v+TEXMOVEV);
                glVertex3fv((float *)&vertices[offs]);
                glColor3f(a2, a2, a2);
				glTexCoord2f(uv[offs+xres].u+TEXMOVEU, uv[offs+xres].v+TEXMOVEV);
                glVertex3fv((float *)&vertices[offs + xres]);
                offs++;
            }
            glEnd();
        }

	glPopAttrib();

	glPopMatrix();

if(postproc)
{

	ss->unbind();	

	glDisable(GL_TEXTURE_2D);
	glActiveTextureARB(GL_TEXTURE4_ARB);
	glDisable(GL_TEXTURE_2D);

	glDisable(GL_TEXTURE_2D);
	glActiveTextureARB(GL_TEXTURE3_ARB);
	glDisable(GL_TEXTURE_2D);

	glDisable(GL_TEXTURE_2D);
	glActiveTextureARB(GL_TEXTURE2_ARB);
	glDisable(GL_TEXTURE_2D);

	glDisable(GL_TEXTURE_2D);
	glActiveTextureARB(GL_TEXTURE1_ARB);
	glDisable(GL_TEXTURE_2D);

	glDisable(GL_TEXTURE_2D);
	glActiveTextureARB(GL_TEXTURE0_ARB);
	glDisable(GL_TEXTURE_2D);

if(Config::nv7)
{
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_COMPARE_MODE, GL_NONE);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_COMPARE_FUNC, GL_LEQUAL);
}
	// Restore normal texture matrix and stuff
	glMatrixMode(GL_TEXTURE);
	glLoadIdentity();
    glEnable(GL_TEXTURE_2D);
    glMatrixMode(GL_MODELVIEW);

}

    //glDepthMask(1);
	glEnable(GL_DEPTH_TEST);

	glDisable(GL_BLEND);
	glColor3f(1,1,1);

		Shader *fisushader = shaders->getShader("fishbone");
if(postproc)
{

    //Vector3 g_lightPos = Vector3(4, 4, 4);
	float g_lightPos[4] = {lightPosition.x, lightPosition.y, lightPosition.z,0};

    glPushAttrib(GL_LIGHTING_BIT);

        glLightfv(GL_LIGHT0, GL_POSITION, g_lightPos);

		float Al[4] = {0.0f, 0.0f, 0.0f, 1.0f };
		glLightfv( GL_LIGHT0, GL_AMBIENT, Al );	
		float Dl[4] = {1.0f, 1.0f, 1.0f, 1.0f };
		glLightfv( GL_LIGHT0, GL_DIFFUSE, Dl );	
		float Sl[4] = {1.0f, 1.0f, 1.0f, 1.0f };
		glLightfv( GL_LIGHT0, GL_SPECULAR, Sl );	

		float Am[4] = {0.13f, 0.13f, 0.2f, 1.0f };
		glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT, Am );
		float Dm[4] = {0.35f, 0.35f, 0.45f, 1.0f };
		glMaterialfv(GL_FRONT_AND_BACK, GL_DIFFUSE, Dm );
		float Sm[4] = {0.6f, 0.6f, 0.75f, 1.0f };
		glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, Sm );
		float f = 100.0f;
		glMaterialf(GL_FRONT_AND_BACK, GL_SHININESS, f );

		
	fisushader->bind(); 

	 glActiveTextureARB(GL_TEXTURE0_ARB);
	 glEnable(GL_TEXTURE_2D);
	 glBindTexture(GL_TEXTURE_2D, glExt.depthTex);
if(Config::nv7)
{
	 glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_COMPARE_MODE, GL_COMPARE_R_TO_TEXTURE_ARB);
	 glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_COMPARE_FUNC, GL_LEQUAL);
}
	glMatrixMode(GL_TEXTURE);
	glLoadIdentity();  
	glTranslatef(0.5, 0.5, 0.5); 	// [0.0, 1.0], not [-1.0, 1.0]
	glScalef(0.5, 0.5, 0.5);
	glMultMatrixf(light_mat_proj); 	// multiply texture matrix
	glMultMatrixf(light_mat_modelview);
	// finally, multiply by the *inverse* of the *current* modelview matrix
	Matrix4 s_mat_m;
	glGetFloatv(GL_MODELVIEW_MATRIX, s_mat_m);

	// Invert matrix
	s_mat_m = s_mat_m.makeInverseTranspose();
	s_mat_m = s_mat_m.makeTranspose();

	glMultMatrixf(s_mat_m);
	glMatrixMode(GL_MODELVIEW);

	fisushader->setUniform1i("shadowMap", 0);  
}

	 const int texturesPerRun = 32*4;
	 const float timeperTexture = 1.0f/float(texturesPerRun);
	 float timeyli = fmodf(pos, timeperTexture);

	 int n = int(pos*texturesPerRun)%32 + 1;
	 int next = int(pos*texturesPerRun+1)%32 + 1;	
	 char buf[75];
	 sprintf(buf, "cau_0%02d.jpg", n);
	 Texture *t1 = dmsGetTexture(buf);
	 char buf2[75];
	 sprintf(buf2, "cau_0%02d.jpg", next);
	 Texture *t2 = dmsGetTexture(buf2);

	 fisushader->setUniform1f("causinterp", timeyli/float(timeperTexture));
	 fisushader->setUniform1i("caus0", 3);  
	 fisushader->setUniform1i("caus1", 4);

	 glActiveTextureARB(GL_TEXTURE1_ARB);
	 glEnable(GL_TEXTURE_2D);
	 glBindTexture(GL_TEXTURE_2D, t1->getID());

	 glActiveTextureARB(GL_TEXTURE2_ARB);
	 glEnable(GL_TEXTURE_2D);
	 glBindTexture(GL_TEXTURE_2D, t2->getID());
	 
	int objectvertexcount		= model->model->getVertexCount();
	int objectfacecount			= model->model->getFaceCount();
	T3DFace *objectfaces		= model->model->getFaceArray();
	T3DVertex *objectvertices	= model->model->getVertexArray();

#ifndef DISABLE_CULLING
	glEnable(GL_CULL_FACE);
	glCullFace(GL_BACK);
#endif
			//for(int idx=0; idx<1; idx++)
			int idx = 0;
			{
				glPushMatrix();				
				//glLoadIdentity();
				
				glRotatef(2.5f * sin(timeMod), 0,1,0);
				glTranslatef(p[idx].x, p[idx].y, p[idx].z);
				//Vector scale = tool->getColor("color2");
				
				//Vector scale = Vector3(0.00046f, 0.00047f, 0.00049f);
				//Vector scale = Vector3(0.00056f, 0.00057f, 0.00059f);
				
				//Vector scale = Vector3(0.00059f, 0.00059f, 0.00059f);
				Vector scale = Vector3(0.00059f, 0.00059f, 0.00059f)*1.250f;
				glScalef(scale.x, scale.y, scale.z);

					glBegin(GL_TRIANGLES);
					for (int i=0;i<objectfacecount;i++)
					{

						glNormal3fv((float *)&objectfaces[i].normal);
						glMultiTexCoord2fARB(GL_TEXTURE0_ARB, objectvertices[objectfaces[i].a].u, objectvertices[objectfaces[i].a].v);
						glVertex3fv((float *)&animatedvertices[objectfaces[i].a].position);

						glNormal3fv((float *)&objectfaces[i].normal);
						glMultiTexCoord2fARB(GL_TEXTURE0_ARB, objectvertices[objectfaces[i].b].u, objectvertices[objectfaces[i].b].v);
						glVertex3fv((float *)&animatedvertices[objectfaces[i].b].position);

						glNormal3fv((float *)&objectfaces[i].normal);
						glMultiTexCoord2fARB(GL_TEXTURE0_ARB, objectvertices[objectfaces[i].c].u, objectvertices[objectfaces[i].c].v);
						glVertex3fv((float *)&animatedvertices[objectfaces[i].c].position);
					}
					glEnd();
				glPopMatrix();
			}	


#ifndef DISABLE_CULLING
	glDisable(GL_CULL_FACE);
#endif

if(postproc)
{
	fisushader->unbind();
}

	glActiveTextureARB(GL_TEXTURE2_ARB);
	glDisable(GL_TEXTURE_2D);

	glActiveTextureARB(GL_TEXTURE1_ARB);
	glDisable(GL_TEXTURE_2D);

	glActiveTextureARB(GL_TEXTURE0_ARB);
	glDisable(GL_TEXTURE_2D);


if(Config::nv7)
{
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_COMPARE_MODE, GL_NONE);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_COMPARE_FUNC, GL_LEQUAL);
}

    glPopAttrib();

	// --
Shader *s = shaders->getShader("depth_col_adjust");
//if(!postproc)
{

	glEnable(GL_TEXTURE_2D);
	glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

s->bind();
s->setUniform1i("tex", 0);
const float zMod = 1.0f;
//s->setUniform1f("zNearMod", 1.0f * tool->getValue("slider3"));
//s->setUniform1f("zMod", zMod);
//s->setUniform3f("camPos", cameraPosition.x, cameraPosition.y, cameraPosition.z);
}
	float G_L[4] = {0,0,0,0};
    glPushAttrib(GL_LIGHTING_BIT);
        glLightfv(GL_LIGHT0, GL_POSITION, G_L);

	// Move 
	const float spd = 0.25f + pos * 1.50f;
	Vector3 move = Vector3(-spd, 0, 0);


    Vector3 xr, yr, zr;
    Math::antiRotate(&xr, &yr, &zr);

	Vector3 color = Vector3(0.6f, 0.3f, 0.3f);
	float size = 0.0020f;
	Vector3 sizexr = xr * size;
	Vector3 sizeyr = yr * size;
    glBindTexture(GL_TEXTURE_2D, dmsGetTexture("circle.jpg")->getID());
	//glBindTexture(GL_TEXTURE_2D, dmsGetTexture("bubble1.png")->getID());
    glBegin(GL_QUADS);
	Vector3 ppos, v1,v2,v3,v4;
	int bound = pcount>>1;

	//color *= 0.5f;
	Vector3 color2 = Vector3(0.3f, 0.6f, 0.627f) ;//* 0.57f;


	float palpha = alpha * 0.35f;
	for(int i=0; i<pcount; i++)
	{
		if((i&1) == 0) glColor4f(color2.x,  color2.y, color2.z, palpha);
		else  glColor4f(color.x,  color.y, color.z, palpha);


		ppos = particlet[i] - move;// * ( i > (pcount>>1) ? 1.0f : 0.95f);
		while(ppos.x > 1.0f) ppos.x -= 2.0f;
		//glVertex3fv((float*)&p);
		v1 = ppos - sizexr - sizeyr;//xr * -size + yr * -size;
		v2 = ppos + sizexr - sizeyr;//+ xr *  size + yr * -size;
		v3 = ppos + sizexr + sizeyr;//xr *  size + yr *  size;
		v4 = ppos - sizexr + sizeyr;//xr * -size + yr *  size;
		
		glTexCoord2f(0, 0);
		glVertex3fv((float *)&v1);
		glTexCoord2f(1, 0);
		glVertex3fv((float *)&v2);
		glTexCoord2f(1, 1);
		glVertex3fv((float *)&v3);
		glTexCoord2f(0, 1);
		glVertex3fv((float *)&v4);
   
	}
    glEnd();

glPopAttrib();

//if(!postproc)
{
	s->unbind();
}


	glMatrixMode(GL_TEXTURE);
	glLoadIdentity();
	glMatrixMode(GL_MODELVIEW);

}

void Fisut::lookFromCamera()
{
	gluLookAt(
			// from
			cameraPosition.x,
			cameraPosition.y,
			cameraPosition.z,

			// to			
			//tool->getValue("slider2")*50.0f + fad.x*1.5f
			cameraTarget.x,
			cameraTarget.y,
			cameraTarget.z,

			0, 1, 0);
}

void Fisut::lookFromLight()
{
	gluLookAt(
			// from
			lightPosition.x,
			lightPosition.y,
			lightPosition.z,

			// to			
			//tool->getValue("slider2")*50.0f + fad.x*1.5f,
			cameraTarget.x,
			cameraTarget.y,
			cameraTarget.z,

			0, 1, 0);
}

void Fisut::render3ds(float pos, float alpha)
{

	const float M = 0.01f;


	glDisable(GL_BLEND);
	glEnable(GL_DEPTH_TEST);

	glLoadIdentity();

	float sinimod = 0.25f + 1 - ((powf(1-sinf(pos*1.57f), 2)));
	Vector3 mod = Vector3(0.09f-sinimod*0.045f, 0.19f, 0.13f)*0.9f;

	float fm = powf(1.0f-alpha, 3);
	float dist = 0.2500f;
	if(pos > 0.5f) dist = -dist;
	Vector3 fad  = Vector3(0.16f, 0.0f, 0.99f)*fm*dist;

	Vector3 move = Math::sphereToCartesian(0.05f, sin(pos*4.3f)+sin(powf(pos,2)), cosf(pos*4.2f));

	cameraPosition = Vector3(0.015*(1-pos)	+ mod.x + fad.x + move.x, 
						 	 0	+ mod.y + fad.y + move.y, 
							 0	+ mod.z + fad.z + move.z);

	Vector3 targetmove = Math::sphereToCartesian(0.075f, sin(pos*1.3f), cosf(pos*0.9f))*pos;

	lightPosition = Vector3(-0.057f, 0.42f, 0.095f);

	cameraTarget = targetmove + Vector3(     0.005 + fad.x * 2.0f,
											 0.055f + fad.y * 2.0f,
											 0 + fad.z * 2.0f);

	framePreCalc(pos);
	
glExt.bindDepthFBO();	

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);		
	// Add offsets to remove z-fight
	glColorMask( 0, 0, 0, 0 );
	glPolygonOffset(2.0f, 2.0f);
	glEnable(GL_POLYGON_OFFSET_FILL);

	glLoadIdentity();
	//glScalef(5,5,5);
	lookFromLight();
	// Store needed matrices for step 2
	glGetFloatv(GL_PROJECTION_MATRIX, light_mat_proj);
	glGetFloatv(GL_MODELVIEW_MATRIX, light_mat_modelview);

	
	// Draw your scene here
	drawModels(pos, alpha, false);	
	glDisable(GL_POLYGON_OFFSET_FILL);

	// -- End rendering to buffer
glExt.unbindFBO();

//filter.blur();

	glColorMask( 1, 1, 1, 1 );

	glColor3f(1, 1, 1);

	//filter.blurShadowMap();

	//glBindTexture(GL_TEXTURE_2D, glExt.depthColTex);
	//glBindTexture(GL_TEXTURE_2D, glExt.depthTex);
	//Primitives::textureTausta(0,0);

// ----------------------
//	glEnable(GL_TEXTURE_2D);
//	glBindTexture(GL_TEXTURE_2D, glExt.depthTex);
//	Primitives::textureTausta(0,0);
// --------------------

//gluLookAt( LOOK FROM CAMERA POSITION );
/**/
glLoadIdentity();
lookFromCamera();


filter.init(true);
		// Draw your scene here with lighting and stuff
		drawModels(pos, alpha, true);
filter.glow(6, 0.008f, 0.008f, 0.86f , -1.0f, 1.0f); 
/**/

}
