#ifdef _DEBUG
	#include <stdlib.h>
//	#include "../mmgr.h"
#endif

#include <math.h>

#include "Greets.h"
#include "../mathematics.hpp"
#include "../primitives.hpp"
const int TABLE_X = 256;
const int TABLE_Y = 64;


float bezierx;
float beziery;
void getBezierPoint(float x1, float y1, float x2, float y2, float x3, float y3, float t)
{
	float t2 = t * t;
	bezierx = ((1 - t) * (1 - t) * x1) + (2 * t * (1 - t) * x2) + (t2 * x3);
	beziery = ((1 - t) * (1 - t) * y1) + (2 * t * (1 - t) * y2) + (t2 * y3);
}

void Greets::draw()
{
	const float pos = (time - startTime) / (endTime - startTime);
	float alpha = 1.0f;

	const float fadeinstart = 0.0f;
	const float fadeinstop = 0.25f;
	const float fadeoutstart = 0.85f;
	const float fadeoutstop = 1.0f;

	if (pos >= fadeinstart && pos <= fadeinstop)
		alpha *= (pos-fadeinstart) / (fadeinstop-fadeinstart);
	if (pos >= fadeoutstart && pos <= fadeoutstop)
		alpha *= 1-(pos-fadeoutstart) / (fadeoutstop-fadeoutstart);

    filter.init(true);
	renderScene(pos, alpha);
    filter.glow(4, 0.005f, 0.005f, 0.92f*0.94f, -1.0f, 1.0f);
}

void Greets::renderScene(float pos, float alpha)
{
 
	bool imageUpdated=false;
    this->frametimer->update();
    while (this->frametimer->stepsLeft())
    {
		for(int n=0; n<3; n++)
		{
			int x = rand()%watereffu->size;
			int y = rand()%watereffu->size;
			watereffu->buffer2[(x)*watereffu->size+y] = 255;
		}
	
		watereffu->updateBuffers();
		imageUpdated = true;
        this->frametimer->endStep();
    }

	if(imageUpdated) 
	{
		watereffu->uploadNormalMap(1.0f);
		watereffu->uploadDxDy();
	}


    Vector3 cam = Vector3(0, 0, -7);
    Vector3 tgt = Vector3(0, 0, 0);
    Vector3 upw = Vector3(0, 1, 0);

    glLoadIdentity();
    gluLookAt(cam.x, cam.y, cam.z, tgt.x, tgt.y, tgt.z, upw.x, upw.y, upw.z);

	float moduletime = dmsGetModulePosition();
	float trig1val = trigu1->get(moduletime);
	float trig2val = trigu2->get(moduletime);
	float trig3val = trigu3->get(moduletime);
	

	float trigvals[] = { trig1val, trig2val, trig3val };

	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	

	const char *IMAGES[] = 
	{
		"greet1.png",
		"greet2.png",
		"greet3.png",
	};

	const float POSITIONS[] = 
	{
		0.3f, 0.65f,
		0.7f, 0.5f,
		0.25f, 0.35f,
	};

	glDisable(GL_DEPTH_TEST);
	glEnable(GL_TEXTURE_2D);

	Shader *ss;
if(!Config::nv7)
{
	ss = shaders->getShader("greetwater");
	ss->bind(); 

	ss->setUniform1i("water", 0);  
	ss->setUniform1i("tex", 1);
}

	dmsPerspective2D(1,1);
	glLoadIdentity();

if(!Config::nv7)
{
	 glActiveTextureARB(GL_TEXTURE0_ARB);
	 glEnable(GL_TEXTURE_2D);
	 glBindTexture(GL_TEXTURE_2D, watereffu->normalMapTexture);

	 glActiveTextureARB(GL_TEXTURE1_ARB);
	 glEnable(GL_TEXTURE_2D);
}
else
{
	 glActiveTextureARB(GL_TEXTURE0_ARB);
	 glEnable(GL_TEXTURE_2D);	
}

	int first = (trig1val>0 ? 0 : (trig2val>0 ? 1 : (trig3val>0 ? 2 : 3)));
	int maxim = (trig3val>0 ? 3 : (trig2val>0 ? 2 : (trig1val>0 ? 1 : 0)));
	for(int i=first; i<maxim; i++)
	{
	
	if(!Config::nv7)
	{	
			ss->setUniform1f("distortmodi", (1.15-Math::clampVal(trigvals[i], 0.30, 1.0)));
			ss->setUniform4f("vari", 1,1,1, trigvals[i] * (1-Math::calcPosFloat(trigvals[i], 0.95f, 1.0f)));
	}
	else
	{
		glColor4f(1,1,1, trigvals[i] * (1-Math::calcPosFloat(trigvals[i], 0.95f, 1.0f)));
	}
	
		//glColor4f(1,1,1, trigvals[i]);
		glBindTexture(GL_TEXTURE_2D, dmsGetTexture(IMAGES[i])->getID());

		float x0 = 0;
		float x1 = 1;
		float y0 = 1;
		float y1 = 0;

		float size = 0.20 - trigvals[i] * 0.01f;

		float centerx = POSITIONS[i*2];
		float centery = POSITIONS[i*2+1];

		glBegin(GL_QUADS);

			glTexCoord2f(x0, y0);
			glVertex2f(centerx-size, centery-size);
			glTexCoord2f(x1, y0);
			glVertex2f(centerx+size, centery-size);
			glTexCoord2f(x1, y1);
			glVertex2f(centerx+size, centery+size);
			glTexCoord2f(x0, y1);
			glVertex2f(centerx-size, centery+size);

		glEnd();
	}
if(!Config::nv7)
{	
	glDisable(GL_TEXTURE_2D);
	glActiveTextureARB(GL_TEXTURE1_ARB);
	glDisable(GL_TEXTURE_2D);
}
	glDisable(GL_TEXTURE_2D);
	glActiveTextureARB(GL_TEXTURE0_ARB);
	glDisable(GL_TEXTURE_2D);
if(!Config::nv7)
{	
	ss->unbind();
}
	/*
	CatmullRom *cr = new CatmullRom();
	cr->startCreation();
	for(i=0; i<46; i++)
	{
		cr->addPoint(Vector3(0.2f+P[i*3], P[i*3+1]-0.2f, 0));
		//glVertex2f(P[i*2]*0.5f, P[i*2+1]*0.5f);
	}
	cr->endCreation();
	*/

	/*for(float f=0; f<1.0f; f+=0.001f)
		glVertex3fv((float*)&(cr->getValue(f)));
	glVertex3fv((float*)&(cr->getValue(0)));
	*/

	/*
	//Vector3 disp = Vector3(pos, pos*pos, 0);
	Vector3 disp = Vector3(0, 0, 0);

	int place = 0;
	int old = -1;
	glBegin(GL_LINES);
	for(i=0; i<1046; i++)
	{
		place = i*3;
		if(old == P[place+2])
		{
			Vector3 a = Vector3(P[place-3]+0.2f, P[place-3+1]-0.2f, 0) + disp;
			Vector3 b = Vector3(P[place]+0.2f, P[place+1]-0.2f, 0) + disp;
			Vector3 m = (a+b) * 0.5f + disp * tool->getValue("slider1");

			for(float z=0.01f; z<1.0f; z+=0.01f)
			{
				getBezierPoint(a.x, a.y, m.x, m.y, b.x, b.y, z-0.01f);
				glVertex2f(bezierx, beziery);
				getBezierPoint(a.x, a.y, m.x, m.y, b.x, b.y, z);
				glVertex2f(bezierx, beziery);
			}

		}
		old = P[place+2];
	}
	glEnd();
	*/


	/*
	glHint(GL_POINT_SMOOTH_HINT, GL_NICEST);
    glEnable(GL_POINT_SMOOTH);
	glDisable(GL_TEXTURE_2D);
	glColor3f(1,1,1);
	dmsPerspective2D(1,1);
	std::vector<GreetsLine>::iterator it;

	glPointSize(2);
	glBegin(GL_POINTS);
    for (it = greetlinet.begin(); it < greetlinet.end(); it++)
    {
        GreetsLine *l = it;
		glVertex3fv((float*)&(l->a));
    }
	glEnd();
	glDisable(GL_POINT_SMOOTH);
	*/

/*
	glEnable(GL_TEXTURE_2D);
	glEnable(GL_BLEND);
	glBlendFunc(GL_ONE, GL_ONE);
	glDisable(GL_DEPTH_TEST);
	glBindTexture(GL_TEXTURE_2D, dmsGetTexture("flare_white.jpg")->getID());

	dmsPerspective2D(1,1);
	std::vector<GreetsLine>::iterator it;

	Vector3 x, y, z;
	Math::antiRotate(&x, &y, &z);
	float size = 0.00405f * tool->getValue("slider6")*2.0f;
	Vector xsize = x*size;
	Vector ysize = y*size;

	int first = (trig1val>0 ? 0 : (trig2val>0 ? 1 : (trig3val>0 ? 2 : 3)));
	int maxim = (trig3val>0 ? 3 : (trig2val>0 ? 2 : (trig1val>0 ? 1 : 0)));
	if(moduletime > 305646) maxim = 3;
	glBegin(GL_QUADS);
    for (it = greetlinet.begin(); it < greetlinet.end(); it++)
    {
			GreetsLine *l = it;
			float color = 1.0f;

			if(l->batch >= maxim) continue;

			if(l->batch < first)
			{
				if(l->time < 0) continue;
				l->time -= dmsGetDeltaTime()*1000.0f;
				color = (l->time > 1000 ? 1.0f : (min(l->time, 1000) * 0.001f));
				l->a += l->spd*dmsGetDeltaTime();
			}

			glColor3f(color, color, color);

			Vector point =l->a;

			Vector v1 = point - xsize - ysize;
			Vector v2 = point + xsize - ysize;
			Vector v3 = point + xsize + ysize;
			Vector v4 = point - xsize + ysize;

			glTexCoord2f(0, 0);
			glVertex3fv((float *)&v1);
			glTexCoord2f(1, 0);
			glVertex3fv((float *)&v2);
			glTexCoord2f(1, 1);
			glVertex3fv((float *)&v3);
			glTexCoord2f(0, 1);
			glVertex3fv((float *)&v4);
    }
	glEnd();
	glDisable(GL_POINT_SMOOTH);
*/
	dmsPerspective3D();
	glLoadIdentity();

}




Greets::Greets()
{	
    this->frametimer = new FrameTimer(1000 / 20, 5);
}

Greets::~Greets()
{
}


bool Greets::init(unsigned long s, unsigned long e)
{
	startTime = s;
	endTime = e;

	watereffu = new WaterEffect();
	watereffu->init(256);

	//trigut->add(298642, 299792);
	//trigut->add(300651, 301801);
	//trigut->add(302796, 303946);
	trigu1 = new TriggerSystem();
	trigu1->add(298442, 302692);
	
	trigu2 = new TriggerSystem();
	trigu2->add(300451, 304001);
	
	trigu3 = new TriggerSystem();
	trigu3->add(302596, 306146);

	/*
	int old = -1;
	int i, place;
	for(i=0; i<12189; i++)
	{
		place = i*3;
		if(old == POSITIOT[place+2])
		{
			Vector3 a = Vector3(POSITIOT[place-3],	POSITIOT[place-3+1], 0) * 0.75f;
			Vector3 b = Vector3(POSITIOT[place],	POSITIOT[place+1], 0) * 0.75f;
			Vector3 m = (a+b) * 0.5f;
			
			GreetsLine line;
			line.a = a;
			line.b = b;
			line.c = m;
			greetlinet.push_back(line);

		}
		old = POSITIOT[place+2];
	}
	*/

	/*
	const float modx = 1.0f / ((float)TABLE_X*3) * 1.5f * tool->getValue("slider7")*2.0f;
	const float mody = 1.0f / ((float)TABLE_Y*9) * 1.5f * tool->getValue("slider8")*2.0f;

	Vector3 set1pos = Vector3(0.05,	0.2f,	0);
	Vector3 set2pos = Vector3(0.2f,	0.7f,	0);
	Vector3 set3pos = Vector3(0.6f,	0.3f,	0);

	int x, y;

	greetlinet.clear();
	for(y=0; y<TABLE_Y; y++)
	{
		for(x=0; x<TABLE_X; x++)
		{
			if(GREET1[y*TABLE_X+x])
			{
				GreetsLine line;
				line.a = Vector3(x*modx, y*mody, 0) + set1pos;
				line.batch = 0;
				line.time = 1000 + rand()%1400;
				line.spd = Vector3(Math::randBetween(-0.0101, 0.0101f), Math::randBetween(-0.028, -0.015f), 0);
				greetlinet.push_back(line);
			}
		}
	}

	
	for(y=0; y<TABLE_Y; y++)
	{
		for(int x=0; x<TABLE_X; x++)
		{
			if(GREET2[y*TABLE_X+x])
			{
				GreetsLine line;
				line.a = Vector3(x*modx, y*mody, 0) + set2pos;
				line.batch = 1;
				line.time = 1000 + rand()%700;
				line.spd = Vector3(Math::randBetween(-0.0081, 0.0081f), Math::randBetween(-0.048, -0.015f), 0);
				greetlinet.push_back(line);
			}
		}
	}

	
	for(y=0; y<TABLE_Y; y++)
	{
		for(x=0; x<TABLE_X; x++)
		{
			if(GREET3[y*TABLE_X+x])
			{
				GreetsLine line;
				line.a = Vector3(x*modx, y*mody, 0) + set3pos;
				line.batch = 2;
				line.time = 500+rand()%500;
				line.spd = Vector3(Math::randBetween(-0.0081, 0.0081f), Math::randBetween(-0.048, -0.015f), 0);
				greetlinet.push_back(line);
			}
		}
	}
	*/


	

	return true;
}

