#ifdef _DEBUG
	#include <stdlib.h>
//	#include "../mmgr.h"
#endif

#include <math.h>

#include "Metsae.h"
#include "../mathematics.hpp"
#include "../primitives.hpp"

extern void setClearColor(Vector3 color);
void Metsae::draw()
{
	
//	setClearColor(Vector3(-1,-1,-1)); // reset clear color!
	setClearColor(Vector3(0.002f, 0.002f, 0.004f)); // reset clear color!
	//setClearColor(Vector3(0.005f, 0.005f, 0.015f));

	const float pos = (time - startTime) / (endTime - startTime);
	float alpha = 1.0f;

	const float fadeinstart = 0.0f;
	const float fadeinstop = 0.1f;
	const float fadeoutstart = 0.99f;
	const float fadeoutstop = 1.0f;

	if (pos >= fadeinstart && pos <= fadeinstop)
		alpha *= (pos-fadeinstart) / (fadeinstop-fadeinstart);
	if (pos >= fadeoutstart && pos <= fadeoutstop)
		alpha *= 1-(pos-fadeoutstart) / (fadeoutstop-fadeoutstart);

//    filter.init(true);
	renderScene(pos, alpha);
//    filter.glow(8, 0.005f, 0.005f, 0.92f, -1.0f, 1.0f);
}


/////////////////////////////////////////////////////////////////////////////////////////
//                                     SIVUTTAINOTUS
/////////////////////////////////////////////////////////////////////////////////////////


MetsaOtus::MetsaOtus(CatmullRom *masterspline, bool special, int which)
{
    int i;

    this->special = special;
    this->tilpecount = 300 + rand()%500;;
    tilpet = new MetsaTilpe*[tilpecount];

    this->st = Math::randBetween(0.1f, 0.8f);
    this->et = this->st + Math::randBetween(0.2f, 0.4f);

    for (i = 0; i < tilpecount; i++)
    {
        int tilpevert = 10;
        tilpet[i] = new MetsaTilpe();
        tilpet[i]->curve = new CatmullRom();
		tilpet[i]->curve->startCreation();

        float master_t = Math::randBetween(0.01f, 1.00f);
        float master_t_delta = -0.002f;

        tilpet[i]->delta = Math::randVectSphere()*0.7f;
        tilpet[i]->st = master_t;
        tilpet[i]->et = tilpet[i]->st + Math::randBetween(0.05f, 0.10f) * (this->special ? 1.5f : 1);

        Vector c1, c2;
        switch(rand()%2)
        {
            case 0:
            {
                //turkoosi
                c1 = Vector(0.15f, 0.7f, 0.9f);
                c2 = Vector(0.14f, 0.9f, 1.0f);
            } break;
            case 1:
            {
                //keltainen
                c1 = Vector(0.9f, 0.7f, 0.3f);
                c2 = Vector(1.0f, 0.8f, 0.3f);

            } break;
        }

        float coloralpha = 0.5f;
        float colort = Math::randFloat();
        tilpet[i]->color = (c1 * (1-colort) + c2*colort)*coloralpha;

        if (rand()%80 == 0)
        {
            tilpet[i]->color = Vector(1,1,1);
        }

        const int steps_along_the_spline = 3;
        Vector startpos = masterspline->getValue(master_t);

        for (int j = 0; j < steps_along_the_spline; j++)
        {
            tilpet[i]->curve->addPoint(masterspline->getValue(master_t));
            master_t += master_t_delta;
        }
        Vector3 curpos = masterspline->getValue(master_t);
        Vector3 direction = (curpos - startpos).normalize();

        float rotaatio = Math::randBetween(2.4f, 3.6f)*4;
        Vector rotationdelta = Math::randVectSphere()*10;
        float speed = 0.05f + (0.2f*powf(Math::randFloat(), 1.7f));
        Vector r = Math::randVectSphere()*rotaatio*(1+speed);

        r.x *= master_t;
        r.y *= master_t;

        for (j = steps_along_the_spline; j < tilpevert; j++)
        {
            Matrix rotation;
            rotation.makeRotation(r.x, r.y, r.z);
            tilpet[i]->curve->addPoint(curpos);
            curpos += direction*speed;
            direction *= rotation;
            r += rotationdelta*1.3f; 
        }
		tilpet[i]->curve->endCreation();
    }
}

MetsaOtus::~MetsaOtus()
{
}

void MetsaOtus::draw(float pos, float sync, float alpha)
{
    const float fadein = Math::calcPosFloat(pos, this->st, this->et);
    if (fadein > 0.00001f || !this->special)
    {
        alpha *= fadein;
        int i = 0;
        glEnable(GL_BLEND);
        glBlendFunc(GL_SRC_ALPHA, GL_ONE);
        glDisable(GL_TEXTURE_2D);
        glDisable(GL_DEPTH_TEST);
        glEnable(GL_LINE_SMOOTH);
        glHint(GL_LINE_SMOOTH_HINT, GL_NICEST);
        glLineWidth(3.0f);  

        int realtime = dmsGetModulePosition();
        const float colorpos = 1-Math::calcPosFloat(realtime*1.0f, 271000.0f, 271500.0f);

        if (this->special)
        {
            for (i = 0; i < tilpecount; i++)
            {
                tilpet[i]->drawSpecial(pos, alpha, sync, colorpos);
            }
        }
        else
        {
            for (i = 0; i < tilpecount; i++)
            {
                tilpet[i]->draw(pos, alpha, sync);
            }
        }
    }
}

void MetsaTilpe::draw(float pos, float alpha, float analval)
{
    float t = Math::calcSaturate(pos, this->st, this->et, 1.15f);
    if (t > 0.0001f)
    {
        Vector3 d = this->delta * powf(t, 2.0f);
        glEnable(GL_BLEND);
        glBlendFunc(GL_SRC_ALPHA, GL_ONE);
        glDisable(GL_TEXTURE_2D);
        glDisable(GL_DEPTH_TEST);

        glBegin(GL_LINE_STRIP);
        for (float u = 0.0f; u < t; u += 0.025f)
        {
            float a = alpha*0.21f*(Math::calcPosFloat(analval, 0, u));//(0.5f+0.5f*(1-u));
            glColor4f(this->color.x, this->color.y, this->color.z, a);
            glVertex3fv((float *)&(this->curve->getValue(u) + d));
        }
        glEnd();
    }
}
void MetsaTilpe::drawSpecial(float pos, float alpha, float analval, float colorpos)
{
    float t = Math::calcSaturate(pos, this->st, this->et, 1.15f);
    if (t > 0.0001f)
    {
        Vector3 col = this->color * (1-colorpos) + this->color2 * colorpos;
        Vector3 d = this->delta * powf(t, 2.0f);
        glEnable(GL_BLEND);
        glBlendFunc(GL_SRC_ALPHA, GL_ONE);
        glDisable(GL_TEXTURE_2D);
        glDisable(GL_DEPTH_TEST);

        glBegin(GL_LINE_STRIP);
        const float start = t - 0.1f;
        if (start > 0.0f)
        {
            for (float u = t - 0.1f; u < t; u += 0.025f)
            {
                float a = alpha*0.5f*(Math::calcPosFloat(analval, 0, u));//(0.5f+0.5f*(1-u));
                glColor4f(col.x, col.y, col.z, a);
                glVertex3fv((float *)&(this->curve->getValue(u) + d));
            }
        }
        glEnd();
    }
}



///////////////////////////////////////////////////////////////////////////////////////////
//                                      METSAE
///////////////////////////////////////////////////////////////////////////////////////////

void MetsaPuu::init()
{
    int i = 0;
    const float r = 7.0f * powf(Math::randFloat(), 0.5f);
    const float a = Math::randFloat() * 2 * 3.141592f;
    const float y = 0;//Math::randBetween(0.3f, 3.0f);

    this->position = Vector3(cosf(a) * r, y, sinf(a) * r);
    this->st = Math::randBetween(0.0f, 0.1f);
    this->et = this->st + Math::randBetween(0.01f, 0.02f);

    this->st2 = Math::randBetween(0.0f, 0.1f);
    this->et2 = this->st2 + Math::randBetween(0.02f, 0.04f);

    this->fade = Math::randBetween(0.2f, 0.3f);

    this->matala = Math::randFloat() > 0.25f;
    const int splinepoints = 5 + (matala?0:3);
    this->basic = Math::randFloat() < 0.7f;

    this->path = new CatmullRom();
    this->path->startCreation();
    this->path2 = new CatmullRom();
    this->path2->startCreation();

    Vector3 p = this->position;

//    dmsMsg("MetsaPuu() - position = (%2.2f %2.2f %2.2f)\n", this->position.x, this->position.y, this->position.z);
    
    for (i = 0; i < splinepoints; i++)
    {
        this->path->addPoint(p);
        this->path2->addPoint(p);

        Vector3 d = Math::randVectSphere() * (this->matala ? 0.1f : 0.2f);
        d.y = fabsf(d.y) * (this->matala ? 2 : 5);

        p += d;
//        dmsMsg("          - position = (%2.2f %2.2f %2.2f)\n", p.x, p.y, p.z);
    }

    this->path->endCreation();
    this->path2->endCreation();
//    this->path->arcLengthParametrize();

    switch(rand()%3)
    {
        case 0:
            this->color = Vector3(0.3f, 0.6f, 0.7f);
            break;
        case 1:
            this->color = Vector3(0.3f, 0.6f, 0.7f);
            break;
        case 2:
            this->color = Vector3(0.8f, 0.3f, 0.8f);
            break;
    }

    this->phase = 0.0f;
    this->speed = Math::randBetween(0.002f, 0.01f);
    this->timer = 0.0f;
}

inline Vector3 puuTurbulence(Vector3 &pos, float time)
{
    const float speed = 12.0f;
    const float thickness = 2.3f;
    float x = 0.3f*sinf(pos.x * 5 * thickness + pos.y * 8 * thickness + time * 4 * speed);
    float y = -0.2f * (0.5f + 0.5f*sinf(pos.y * 4 * thickness + pos.z * 6 * thickness + time * 5.4f * speed));
    float z = 1.0f*sinf(pos.z * 7 * thickness + pos.x * 2 * thickness + time * 5 * speed);

    return Vector3(x, y, z);

}

void MetsaPuu::update(float pos)
{
    this->t = powf(sinf(Math::calcPosFloat(pos, this->st, this->et)*0.5f*3.141592f), 0.5f);
    this->t2 = powf(sinf(Math::calcPosFloat(pos, this->st2, this->et2)*0.5f*3.141592f), 0.5f);
    if (this->t > 0.0001f)
    {
        this->phase += this->speed;
    }
    this->timer += 0.01f;

    int pointcount = this->path->getPointCount();
    Vector3 *source = this->path2->getPoints();
    Vector3 *dest = this->path->getPoints();

//    dmsMsg("puu alkaa\n");
    for (int i = 0; i < pointcount; i++)
    {
        float power = 0.0f;
        const int cutoff = pointcount / 2;
        if (i > cutoff)
        {
            power = (i - cutoff)*0.2f;
        }
        Vector3 d = puuTurbulence(source[i], pos);
        dest[i] = source[i] + d * power * (this->matala ? 0.3f : 0.6f);
/*
        if (i == 0 || i == 1 || i == 2 && dest[i].y > 0.00f)
        {
            dmsMsg("i = %d source y = %f, dest y = %f\n", i, source[i].y, dest[i].y);
        }
*/
    }

}

void MetsaPuu::draw(float pos, float alpha)
{
    if (this->t > 0.0001f)
    {
        const int strips = this->basic ? 15 : 50;
        glBegin(GL_LINE_STRIP);

        for (float u = 0; u < this->t; u += 1.0f / strips)
        {
            glColor4f(this->color.x, this->color.y, this->color.z, alpha *  u * this->fade);
            Vector3 v = this->path->getValue(u);
            glVertex3fv((float *)&v);
            this->valoPosition = v;
        }
        glEnd();

    }
}

void MetsaPuu::draw2(Vector3 &xr, Vector3 &yr, Vector3 &zr, float pos, float alpha, float sync, float sync2)
{
    if (this->basic)
    {
/*
        Vector3 position = this->path->getValue(1.0f);
        drawValo(position, xr, yr, zr, 
            (this->matala ? 0.02f : 0.05f) * this->t2 * (0.6f+0.4f*sinf(this->phase * 2 + u*4)), 
                 alpha*0.8f * (1-u*0.5f) * this->t2 * (0.7f + 0.3f*sinf(this->phase + u*6)));
*/
    }
    else
    {
        if (this->t > 0.0001f)
        {
            drawValo(this->valoPosition, xr, yr, zr, 0.02f * this->t * (0.5f+0.5f*sinf(this->phase * 2)), alpha*0.8f * this->t * (0.7f + 0.3f*sinf(this->phase)));
        }
        if (this->t2 > 0.0001f)
        {
            const int flarecount = (this->matala ? 5 : 30);
            for (int i = 0; i < flarecount; i++)
            {

                
				float u = i / (float)flarecount;
				// imo nytti paskalt.
				/*
				if (u > sync)
                {
                    return;
                }
				*/

                Vector3 position = this->path->getValue(u);
                drawValo(position, xr, yr, zr, 
                    (this->matala ? 0.02f : 0.05f) * this->t2 * (0.6f+0.4f*sinf(this->phase * 2 + u*4)), 
                         alpha*0.8f * (1-u*0.5f) * this->t2 * (0.7f + 0.3f*sinf(this->phase + u*6)));
            }
        }
    }
}

void MetsaPuu::draw3(Vector3 &xr, Vector3 &yr, Vector3 &zr, float pos, float alpha, float sync, float sync2)
{
    if (this->basic)
    {
        if (sync2 > 0.0f)
        {
            Vector3 position = this->path->getValue(1.0f);
            drawValo(position, xr, yr, zr, 
                (this->matala ? 0.02f : 0.05f) * this->t2 * (0.6f+0.4f*sinf(this->phase * 2 )), 
                     alpha*0.5f * sync2* this->t2 * (0.7f + 0.3f*sinf(this->phase)));
        }
    }
}


void MetsaPuu::drawValo(Vector3 &pos, Vector3 &xr, Vector3 &yr, Vector3 &zr, float size, float alpha)
{
    Vector3 v1 = pos + xr * -size + yr * -size;
    Vector3 v2 = pos + xr *  size + yr * -size;
    Vector3 v3 = pos + xr *  size + yr *  size;
    Vector3 v4 = pos + xr * -size + yr *  size;

    glColor4f(1,1,1, alpha);
    glTexCoord2f(0, 0);
    glVertex3fv((float *)&v1);
    glTexCoord2f(1, 0);
    glVertex3fv((float *)&v2);
    glTexCoord2f(1, 1);
    glVertex3fv((float *)&v3);
    glTexCoord2f(0, 1);
    glVertex3fv((float *)&v4);
}

/////////////////////////////////////////////////////////////////////////////
///                             efekti
/////////////////////////////////////////////////////////////////////////////

void Metsae::renderScene(float pos, float alpha)
{


    const float lightfadein = Math::calcPosFloat(dmsGetModulePosition()*1.0f, 75300.0f, 75900.0f);
    const float lightfadein2 = Math::calcPosFloat(dmsGetModulePosition()*1.0f, 83500.0f, 84600.0f);

    int i = 0;
    std::vector<Alkuotus>::iterator it;
    //std::vector<MetsaOtus *>::iterator it2;

    this->frametimer->update();
    while (this->frametimer->stepsLeft())
    {
        for (i = 0; i < this->puucount; i++)
        {
            this->puut[i].update(pos);
        }
        for (it = otukset.begin(); it < otukset.end(); it++)
        {
            (*it).update();
        }
        this->frametimer->endStep();
    }
 
//    glLoadIdentity();
//    cameras->useCamera(0);

    glLoadIdentity();
    Vector3 cam = Vector3(-3, 3, 10) + Vector3(pos*5, 0, 0);
    Vector3 tar = cam + Vector3(0, 0, -5);
    Vector3 up = Vector3(0, 1, 0);
    
    gluLookAt(cam.x, cam.y, cam.z,
              tar.x, tar.y, tar.z,
              up.x, up.y, up.z);


    //this->merenpohja->render(dmsGetTexture("deeptxt2.jpg"), alpha*0.2f);
	this->merenpohja->renderWithNormalMaps(dmsGetTexture("deeptxt2.jpg"), dmsGetTexture("normal_map_deep2.jpg"), Vector3(1,1,1), alpha*0.3f);

    //taustarihmat
    glDisable(GL_TEXTURE_2D);
    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    glEnable(GL_LINE_SMOOTH);
    glDisable(GL_DEPTH_TEST);

    filter.init(true);
    for (i = 0; i < this->puucount; i++)
    {
        //this->puut[i].draw(pos, alpha*(1 + 0.3f*(1-lightfadein)));
		this->puut[i].draw(pos, alpha);//*(1 + 0.3f*(1-lightfadein)));
    }
    glEnable(GL_TEXTURE_2D);
    glBindTexture(GL_TEXTURE_2D, dmsGetTexture("flare_blue.jpg")->getID());
    Vector3 xr, yr, zr;
    Math::antiRotate(&xr, &yr, &zr);
    glDisable(GL_DEPTH_TEST);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE);
    glDepthMask(0);
    glBegin(GL_QUADS);
    for (i = 0; i < this->puucount; i++)
    {
        this->puut[i].draw2(xr, yr, zr, pos, alpha, lightfadein, lightfadein2);
    }
    glEnd();
    glBindTexture(GL_TEXTURE_2D, dmsGetTexture("flare_pink.jpg")->getID());
    glBegin(GL_QUADS);
    for (i = 0; i < this->puucount; i++)
    {
        this->puut[i].draw3(xr, yr, zr, pos, alpha, lightfadein, lightfadein2);
    }
    glEnd();
   
    
    glDepthMask(1);
    glEnable(GL_DEPTH_TEST );

/*    
    for (it2 = this->metsaotukset.begin(); it2 < this->metsaotukset.end(); it2++)
    {
        (*it2)->draw(pos, 0.6f, alpha);
    }
*/
	float TRIG_VAL= trigut->get(dmsGetModulePosition());
    glDisable(GL_LINE_SMOOTH);
    glDisable(GL_BLEND);

    glPointSize(3.0f);
    glHint(GL_POINT_SMOOTH_HINT, GL_NICEST);
    glEnable(GL_POINT_SMOOTH);
    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE);

    glDisable(GL_TEXTURE_2D);
    glBegin(GL_POINTS);
	int n=0;
    for (it = otukset.begin(); it < otukset.end(); it++)
    {
        (*it).drawLine(alpha * (n<250 ? 1.0 : lightfadein));
		n++;
    }
    glEnd();
    glDisable(GL_POINT_SMOOTH);

//    filter.radialblur();
	float glowAmount = 0.93f;
	glowAmount += sinf(TRIG_VAL*3.14f)*0.015f;

    filter.glow(6, 0.0075f, 0.0075f, glowAmount, -1.0f, 1.0f);
}




Metsae::Metsae()
{
    int i = 0;
    const int groundX = 50;
    const int groundY = 50;
    const float size2 = 15.0f;
    this->merenpohja = new GroundPlane(groundX, groundY, size2, 4.0f);
    this->merenpohja->makeCircularFade(1.0f, 1.0f);
	
    this->frametimer = new FrameTimer(1000 / 60, 5);

    srand(5110);
    this->puucount = 2000;
    this->puut = new MetsaPuu[this->puucount];
    for (i = 0; i < this->puucount; i++)
    {   
        this->puut[i].init();
    }
    for (i = 0; i < 500; i++)
    {
        Alkuotus otus;
        otus.init();
        if (i % 6 == 0)
        {
            BoundedMovement *movement = otus.getMovement();
            movement->setSpeed(Math::randBetween(0.03f, 0.1f));
        }
        this->otukset.push_back(otus);
    }

/*
    srand(2450);
    const int otuscount = 10;
    for (i = 0; i < otuscount; i++)
    {
        const int splinepoints = 20;
        CatmullRom *spline = new CatmullRom();
        spline->startCreation();
        Vector3 startpoint = Math::randVectSphere() + Vector3(0, 4, 0);
        Vector3 maindir = Math::randVectSphere();
        maindir.y = fabsf(maindir.y);

        for (int j = 0; j < splinepoints; j++)
        {
            float t = j / (float)splinepoints;
            spline->addPoint(startpoint);

            Vector3 dir = maindir + Math::randVectSphere()*0.9f;
            startpoint += dir;
        }
        spline->endCreation();

        MetsaOtus *otus = new MetsaOtus(spline, false, 0);
        this->metsaotukset.push_back(otus);
        delete spline;
    }
*/
}

Metsae::~Metsae()
{
}


bool Metsae::init(unsigned long s, unsigned long e)
{
	trigut = new TriggerSystem();
	trigut->add(66583, 67733);
	trigut->add(69753, 70703);
	trigut->add(71756, 72806);
	trigut->add(73955, 75355);
	trigut->add(75080, 76730);
	trigut->add(78074, 78994);
	trigut->add(82165, 83815);
	trigut->add(84369, 85319);
	trigut->add(86412, 87462);
	trigut->add(88623, 89973);
	trigut->add(90601, 91999);

	startTime = s;
	endTime = e;
	return true;
}

