#ifndef _Metsae_HPP_
#define _Metsae_HPP_

#include <stdio.h>
#include <list>
#include <vector>
#include "../externs.hpp"
#include "alkuotukset.h"
#include "../bpm.hpp"
#include "../groundplane.hpp"
#include "../boundedmovement.h"

//////////////////////////////////////////////////////////////////////////////////////////////////

class MetsaTilpe
{
public:

    float st;
    float et;
    void draw(float pos, float alpha, float analval);
    void drawSpecial(float pos, float alpha, float analval, float colorpos);

    CatmullRom *curve;
    Vector color;
    Vector color2;
    Vector3 delta;
};

class MetsaOtus
{
public:
    MetsaOtus(CatmullRom *masterspline, bool special, int which);
    ~MetsaOtus();

    void draw(float pos, float sync, float alpha);

    float st, et;
    bool special;
    int tilpecount;
    MetsaTilpe **tilpet;
};

//////////////////////////////////////////////////////////////////////////////////////////////////

class MetsaPuu
{
public:
    MetsaPuu() {};
    ~MetsaPuu() {};

    void init();
    void update(float pos);
    void draw(float pos, float alpha);
    void draw2(Vector3 &xr, Vector3 &yr, Vector3 &zr, float pos, float alpha, float sync, float sync2);
    void draw3(Vector3 &xr, Vector3 &yr, Vector3 &zr, float pos, float alpha, float sync, float sync2);


private:
    float t, t2;
    float speed;
    float phase;
    Vector3 valoPosition;
    void drawValo(Vector3 &pos, Vector3 &xr, Vector3 &yr, Vector3 &zr, float size, float alpha);
    float st, et;
    float st2, et2;
    float timer;
    float fade;
    bool matala;
    bool basic;

    CatmullRom *path;
    CatmullRom *path2;
    Vector3 position;
    Vector3 color;
};


class Metsae : public Base
{
	public:

		Metsae();
		~Metsae();

		bool init(unsigned long s, unsigned long e);
		void draw();

	private:

		TriggerSystem *trigut;

        std::vector<Alkuotus> otukset;
        std::vector<MetsaOtus*> metsaotukset;

        int puucount;
        MetsaPuu *puut;

        GroundPlane *merenpohja;
        FrameTimer *frametimer;
		void renderScene(float pos, float alpha);
};

#endif

 