#ifdef _DEBUG
	#include <stdlib.h>
//	#include "../mmgr.h"
#endif

#include <math.h>

#include "Ravintoketju.h"
#include "../mathematics.hpp"
#include "../primitives.hpp"

void Ravintoketju::draw()
{
	const float pos = (time - startTime) / (endTime - startTime);
	float alpha = 1.0f;

	const float fadeinstart = 0.0f;
	const float fadeinstop = 0.1f;
	const float fadeoutstart = 0.90f;
	const float fadeoutstop = 1.0f;

	if (pos >= fadeinstart && pos <= fadeinstop)
		alpha *= (pos-fadeinstart) / (fadeinstop-fadeinstart);
	if (pos >= fadeoutstart && pos <= fadeoutstop)
		alpha *= 1-(pos-fadeoutstart) / (fadeoutstop-fadeoutstart);

//    filter.init(true);
	renderScene(pos, alpha);
//    filter.glow(8, 0.005f, 0.005f, 0.92f, -1.0f, 1.0f);
}


/////////////////////////////////////////////////////////////////////////////////////////////
///                                         Ruoka                     
/////////////////////////////////////////////////////////////////////////////////////////////

const float RAVINTOKETJU_X = 3.0f;
const float RAVINTOKETJU_Y = 6.0f;
const float RAVINTOKETJU_Z = 3.0f;

void Ruoka::init(bool beginning)
{
    Vector3 initialPos = Vector3(Math::randBetween(-RAVINTOKETJU_X, RAVINTOKETJU_X), 
                                 Math::randBetween(0, RAVINTOKETJU_Y),
                                 Math::randBetween(-RAVINTOKETJU_Z, RAVINTOKETJU_Z));

    this->movement.setUseBounds(true);
    this->movement.setPosition(initialPos);
    this->movement.setDirection(Math::randBetween(0, 2*3.141592f), Math::randBetween(0, 2*3.141592f));
    this->movement.setBoundLimits(-RAVINTOKETJU_X, RAVINTOKETJU_X, 0, RAVINTOKETJU_Y, -RAVINTOKETJU_Z, RAVINTOKETJU_Z);
    this->movement.setTurning(0, 0);
    this->movement.setSpeed(Math::randBetween(0.002f, 0.004f));

    this->timer = 0.0f;
    if (beginning)
    {
        this->state = RUOKA_STATE_SWIM;
    }
    else
    {
        this->state = RUOKA_STATE_BIRTH;
    }
    this->timer = 0.0f;

    this->fade = Math::randBetween(0.4f, 0.7f);
}

void Ruoka::update(int petocount, Peto *pedot)
{
    int i = 0;
    const float maxdist2 = 0.3f*0.3f;

    if (this->state == RUOKA_STATE_BIRTH)
    {
        this->timer += (1.0f / 60)*0.3f;
        if (this->timer > 1.0f)
        {
            this->timer = 0.0f;
            this->state = RUOKA_STATE_SWIM;
            return;
        }
    }
    else if (this->state == RUOKA_STATE_SWIM)
    {
        this->movement.update();
        if (Math::randFloat() < 0.03f)
        {
//            this->movement.selectNewDirection();
        }
        this->movement.turnTowards(Vector3(0, 0, 0), 1);

/*
        for (i = 0; i < petocount; i++)
        {
            Vector3 &petopos = pedot[i].movement.getPosition();
            Vector3 &ruokapos = this->movement.getPosition();
            
        
            const float d2 = (petopos.x - ruokapos.x)*(petopos.x - ruokapos.x) + 
                             (petopos.y - ruokapos.y)*(petopos.y - ruokapos.y) +
                             (petopos.z - ruokapos.z)*(petopos.z - ruokapos.z);

            if (d2 < maxdist2)
            {
                this->state = RUOKA_STATE_DYING;
                this->timer = 0.0f;
                return;
            }
        }
*/
    }
    else if (this->state == RUOKA_STATE_DYING)
    {
        this->timer += (1.0f / 60)*2;
        if (this->timer > 1.0f)
        {
            this->timer = 0.0f;
            this->state = RUOKA_STATE_DEAD;
            return;
        }
    }
    else if (this->state == RUOKA_STATE_DEAD)
    {
        this->timer += 1.0f / 60;
        if (this->timer > 1.0f)
        {
            this->timer = 0.0f;
            this->init(false);
            this->state = RUOKA_STATE_BIRTH;
        }
    }
    


}
void Ruoka::draw(float alpha)
{
    Vector3 &p = this->movement.getPosition();

    switch(this->state)
    {
        case RUOKA_STATE_BIRTH:
            glColor4f(1, 0, 0,alpha * this->fade * this->timer);
            glVertex3fv((float *)&p);
            break;

        case RUOKA_STATE_SWIM:
            glColor4f(0.3f, 0.6f, 0.7f,0.6f*alpha);
            glVertex3fv((float *)&p);
            break;

        case RUOKA_STATE_DYING:
            glColor4f(1, 1, 1,alpha);// * this->fade * (1 - this->timer));
            glVertex3fv((float *)&p);
            break;

        case RUOKA_STATE_DEAD:
        default:
            {}

    }

}

Vector3 Ruoka::getPosition()
{
    return this->movement.getPosition();
}

/////////////////////////////////////////////////////////////////////////////////////////////
///                                        Peto                     
/////////////////////////////////////////////////////////////////////////////////////////////

void Peto::init()
{

    Vector3 initialPos = Vector3(Math::randBetween(-RAVINTOKETJU_X, RAVINTOKETJU_X), 
                                 Math::randBetween(0, RAVINTOKETJU_Y),
                                 Math::randBetween(-RAVINTOKETJU_Z, RAVINTOKETJU_Z));

    this->movement.setUseBounds(true);
    this->movement.setPosition(initialPos);
    this->movement.setDirection(Math::randBetween(0, 2*3.141592f), Math::randBetween(0, 2*3.141592f));
    this->movement.setBoundLimits(-RAVINTOKETJU_X, RAVINTOKETJU_X, 0, RAVINTOKETJU_Y, -RAVINTOKETJU_Z, RAVINTOKETJU_Z);
    this->movement.setTurning(0, 0);
    this->movement.setSpeed(Math::randBetween(0.005f, 0.015f));

    this->state = PETO_STATE_WANDER;

}

void Peto::update(int ruokacount, class Ruoka *ruoat)
{
    this->movement.update();

    switch(this->state)
    {
        case PETO_STATE_WANDER:
        {
            if (Math::randFloat() < 0.05f)
            {
                this->movement.selectNewDirection();
            }

            if (Math::randFloat() < 0.01f)
            {
                //new target
                this->state = PETO_STATE_HUNT;
                int index = 0;
                do
                {
                    index = rand() % ruokacount;
                } while (ruoat[index].state != RUOKA_STATE_SWIM);

                this->target = &ruoat[index];
            }
        } break;

        case PETO_STATE_HUNT:   
        {
            //TODO:
//            if (Math::randFloat() < 0.001f)
            {
//                this->state = PETO_STATE_WANDER;
//                 this->target = 0;
            }

/*
            Vector3 &source = this->movement.getPosition();
            Vector3 &target = this->target->getPosition();

            Vector3 currentdirection = this->movement.getDirection();
            Vector3 targetdirection = target - source;
            Vector3 temp = Math::cartesianToSphere(targetdirection.x, targetdirection.y, targetdirection.z);

            const float turnrate = 0.01f;
            this->movement.turn((temp.z - currentdirection.z) * turnrate, 
                                (temp.y - currentdirection.y) * turnrate);
*/
            this->movement.turnTowards(this->target->movement.getPosition(), 0.01f);


        } break;
            
    }

}
void Peto::draw(float alpha)
{
    glPushMatrix();
    Vector3 &p = this->movement.getPosition();

    glTranslatef(p.x, p.y, p.z);
    if (this->state == PETO_STATE_HUNT)
    {
        glColor4f(1,0,0,alpha);
    }
    else
    {
        glColor4f(0,1,0,1);
    }
    Primitives::wireCube(0.05f);

    glPopMatrix();

    if (this->state == PETO_STATE_HUNT)
    {
        glColor4f(1,0,0,alpha);
        glBegin(GL_LINES);
        glVertex3fv((float *)&p);
        glVertex3fv((float *)&this->target->getPosition());
        glColor4f(0,0,1,alpha);
        glVertex3fv((float *)&p);

        Vector3 temp = this->movement.getDirection();
        Vector3 dir = Vector3(sinf(temp.y)*sinf(temp.z), sinf(temp.y)*cosf(temp.z), cosf(temp.y))*0.3f;

        glVertex3fv((float *)&(p + dir));
        glEnd();

    }

}


void Ravintoketju::renderScene(float pos, float alpha)
{
    int i = 0;
 
    this->frametimer->update();
    while (this->frametimer->stepsLeft())
    {
        for (i = 0; i < this->petocount; i++)
        {
            this->pedot[i].update(this->ruokacount, this->ruoat);
        }
        for (i = 0; i < this->ruokacount; i++)
        {
            this->ruoat[i].update(this->petocount, this->pedot);
        }

        this->frametimer->endStep();
    }

/*
    Vector3 testi, testi2, testi3;
    testi = Vector3(0.5f, 0.7f, 0.15f);
    testi2 = Math::cartesianToSphere(testi.x, testi.y, testi.z);
    testi3 = Math::sphereToCartesian(testi2.x, testi2.y, testi2.z);

    dmsMsg("%f %f %f\n", testi3.x, testi3.y, testi3.z);

*/
    glLoadIdentity();
//    cameras->useCamera(0);
    gluLookAt(1, 4, -10, 0, 3, 0, 0, 1, 0);


    glDisable(GL_TEXTURE_2D);
    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

    glPointSize(3.0f);
    glHint(GL_POINT_SMOOTH_HINT, GL_NICEST);
    glEnable(GL_POINT_SMOOTH);
    glBegin(GL_POINTS);
    for (i = 0; i < this->ruokacount; i++)
    {
        this->ruoat[i].draw(alpha);
    }
    glEnd();
    glDisable(GL_POINT_SMOOTH);

    filter.init();

    glLineWidth(2.0f);
    for (i = 0; i < this->petocount; i++)
    {
        this->pedot[i].draw(alpha);
    }
    glEnd();


    glDisable(GL_LINE_SMOOTH);
    filter.glow(6, 0.007f, 0.007f, 0.91f, -1.0f, 1.0f);
    glDisable(GL_BLEND);


}




Ravintoketju::Ravintoketju()
{	
    int i = 0;
    this->frametimer = new FrameTimer(1000 / 60, 5);
    this->ruokacount = 100;
    this->petocount = 5;

    this->ruoat = new Ruoka[this->ruokacount];
    for (i = 0; i < this->ruokacount; i++)
    {
        this->ruoat[i].init(true);
    }

    this->pedot = new Peto[this->petocount];
    for (i = 0; i < this->petocount; i++)
    {
        this->pedot[i].init();
    }


}

Ravintoketju::~Ravintoketju()
{
}


bool Ravintoketju::init(unsigned long s, unsigned long e)
{
	startTime = s;
	endTime = e;
	return true;
}

