#ifndef _Sivuttain_HPP_
#define _Sivuttain_HPP_

#include <stdio.h>
#include "../externs.hpp"
#include "../bpm.hpp"
#include "../analyzer.hpp"
#include "alkuotukset.h"

class SivuttainTilpe
{
public:

    float st;
    float et;
    void draw(float pos, float alpha, float analval, float colorpos);
    void drawSpecial(float pos, float alpha, float analval, float colorpos);

    CatmullRom *curve;
    Vector color;
    Vector color2;
    Vector3 delta;
};

class SivuttainOtus
{
public:
    SivuttainOtus(CatmullRom *masterspline, bool special, int which);
    ~SivuttainOtus();

    void draw(float pos, float sync, float alpha);

    float st, et;
    bool special;
    int tilpecount;
    SivuttainTilpe **tilpet;
};

class SivuttainAlkuotus
{
public:
    SivuttainAlkuotus() {};
    ~SivuttainAlkuotus() {};

    void init();
    void update();
    void draw(float alpha);
    void drawGlow(float alpha, Vector3 &xr, Vector3 &yr, Vector3 &zr);
    void drawLine(float alpha);
    void turn();
    BoundedMovement* getMovement() { return &this->movement; }

private:
    float phase;
    float phasespeed;
    float glow;
    float glowspeed;
    Vector3 color;
    BoundedMovement movement;

};

class Kaartuva
{
public:
	float st;
	float et;

	Vector3 pos;
	float radius;

	float a1;
	float a2;
	float b1;
	float b2;
	float r;




};


class Sivuttain : public Base
{
	public:

		Sivuttain();
		~Sivuttain();

		bool init(unsigned long s, unsigned long e);
		void draw();

	private:
        FrameTimer *frametimer;
        std::vector<SivuttainOtus* > otukset;
        std::vector<CatmullRom *> mastersplinet;
        std::vector<SivuttainAlkuotus> alkuotukset;
        std::vector<Kaartuva> kaartuvat;

        Analyzer *anal;

		CatmullRom *cambase;
		CatmullRom *campos;
		void renderScene(float pos, float alpha);
};

#endif
