#ifdef _DEBUG
	#include <stdlib.h>
//	#include "../mmgr.h"
#endif

#include <math.h>

#include "Vihoviimeinen.h"
#include "../mathematics.hpp"
#include "../primitives.hpp"
extern void setClearColor(Vector3 color);	
void Vihoviimeinen::draw()
{
	setClearColor(Vector3(0.002f, 0.002f, 0.004f)); // reset clear color!
	const float pos = (time - startTime) / (endTime - startTime);
	float alpha = 1.0f;

	const float fadeinstart = 0.0f;
	const float fadeinstop = 0.1f;
	const float fadeoutstart = 0.85f;
	const float fadeoutstop = 1.0f;

	if (pos >= fadeinstart && pos <= fadeinstop)
		alpha *= (pos-fadeinstart) / (fadeinstop-fadeinstart);
	if (pos >= fadeoutstart && pos <= fadeoutstop)
		alpha *= 1-(pos-fadeoutstart) / (fadeoutstop-fadeoutstart);

//    filter.init(true);
	renderScene(pos, alpha);
//    filter.glow(8, 0.005f, 0.005f, 0.92f, -1.0f, 1.0f);
}

void ViimeinenKasvi::init()
{
    int i = 0;
    const float r = 7.0f * powf(Math::randFloat(), 0.5f);
    const float a = Math::randFloat() * 2 * 3.141592f;
    const float y = 0;//Math::randBetween(0.3f, 3.0f);

    this->position = Vector3(cosf(a) * r, y, sinf(a) * r);
    this->st = Math::randBetween(0.1f, 0.3f);
    this->et = this->st + Math::randBetween(0.45f, 0.5f);

    this->fade = Math::randBetween(0.2f, 0.3f);

    this->matala = Math::randFloat() > 0.25f;
    const int splinepoints = 5 + (matala?0:3);

    this->path = new CatmullRom();
    this->path->startCreation();
    this->path2 = new CatmullRom();
    this->path2->startCreation();

    Vector3 p = this->position;

    for (i = 0; i < splinepoints; i++)
    {
        this->path->addPoint(p);
        this->path2->addPoint(p);

        Vector3 d = Math::randVectSphere() * (this->matala ? 0.1f : 0.2f);
        d.y = fabsf(d.y) * (this->matala ? 2 : 5);

        p += d;
    }

    this->path->endCreation();
    this->path2->endCreation();

/*
    switch(rand()%3)
    {
        case 0:
            this->color = Vector3(0.3f, 0.6f, 0.7f);
            break;
        case 1:
            this->color = Vector3(0.3f, 0.6f, 0.7f);
            break;
        case 2:
            this->color = Vector3(0.8f, 0.3f, 0.8f);
            break;
    }
*/
    switch(rand()%3)
    {
        case 0:
            this->color = Vector3(0.6f, 0.7f, 0.3f);
            break;
        case 1:
            this->color = Vector(0.7f, 0.6f, 0.3f);
            break;
        case 2:
            this->color = Vector3(0.8f, 0.8f, 0.3f);
            break;
    }

    this->phase = 0.0f;
    this->speed = Math::randBetween(0.002f, 0.01f);
    this->timer = 0.0f;
}

inline Vector3 kasviTurbulence(Vector3 &pos, float time)
{
    const float speed = 12.0f;
    const float thickness = 2.3f;
    float x = 0.3f*sinf(pos.x * 5 * thickness + pos.y * 8 * thickness + time * 4 * speed);
    float y = -0.2f * (0.5f + 0.5f*sinf(pos.y * 4 * thickness + pos.z * 6 * thickness + time * 5.4f * speed));
    float z = 1.0f*sinf(pos.z * 7 * thickness + pos.x * 2 * thickness + time * 5 * speed);

    return Vector3(x, y, z);

}

void ViimeinenKasvi::update(float pos)
{
    this->t = 1 - powf(sinf(Math::calcPosFloat(pos, this->st, this->et)*0.5f*3.141592f), 0.5f);
    if (this->t > 0.0001f)
    {
        this->phase += this->speed;
    }
    this->timer += 0.01f;

    int pointcount = this->path->getPointCount();
    Vector3 *source = this->path2->getPoints();
    Vector3 *dest = this->path->getPoints();

    float die = 0.0f;
    const float diestart = 0.1f;
    if (this->t > diestart)
    {
        die = sinf((this->t - diestart)/(1.0f - diestart)*3.141592f*0.5f);
    }

    for (int i = 0; i < pointcount; i++)
    {
        float power = 0.0f;
        const int cutoff = pointcount / 2;
        if (i > cutoff)
        {
            power = (i - cutoff)*0.2f;
        }
        const float it = i / (float)pointcount;
        Vector3 d = kasviTurbulence(source[i], pos);
        dest[i] = (source[i] + d * power * (this->matala ? 0.3f : 0.6f));
        dest[i].y -= (1.0f*it*(1-die));
        dest[i].y = max(dest[i].y, 0);
    }
}

void ViimeinenKasvi::draw(float pos, float alpha)
{
    if (this->t > 0.0001f)
    {
        const int strips = 50;
        glBegin(GL_LINE_STRIP);

        for (float u = 0; u < 1.0f; u += 1.0f / strips)
        {
            glColor4f(this->color.x, this->color.y, this->color.z, alpha *  u * this->fade * this->t);
            Vector3 v = this->path->getValue(u);
            glVertex3fv((float *)&v);
            this->valoPosition = v;
        }
        glEnd();

    }
}

void ViimeinenKasvi::draw2(Vector3 &xr, Vector3 &yr, Vector3 &zr, float pos, float alpha, float sync)
{
    if (this->t > 0.0001f)
    {
        drawValo(this->valoPosition, xr, yr, zr, 0.02f * (0.5f+0.5f*sinf(this->phase * 2)), alpha*0.8f * this->t * (0.7f + 0.3f*sinf(this->phase)));
        const int flarecount = (this->matala ? 5 : 30);
        for (int i = 0; i < flarecount; i++)
        {
            float u = i / (float)flarecount;

            Vector3 position = this->path->getValue(u);
            drawValo(position, xr, yr, zr, 
                (this->matala ? 0.02f : 0.05f) * (0.6f+0.4f*sinf(this->phase * 2 + u*4)), 
                     alpha*(0.4f+sync*4.0f) * (1-u*0.5f) * this->t * (0.7f + 0.3f*sinf(this->phase + u*6)));
        }
    }
}


void ViimeinenKasvi::drawValo(Vector3 &pos, Vector3 &xr, Vector3 &yr, Vector3 &zr, float size, float alpha)
{
    Vector3 v1 = pos + xr * -size + yr * -size;
    Vector3 v2 = pos + xr *  size + yr * -size;
    Vector3 v3 = pos + xr *  size + yr *  size;
    Vector3 v4 = pos + xr * -size + yr *  size;

    glColor4f(1,1,1, alpha);
    glTexCoord2f(0, 0);
    glVertex3fv((float *)&v1);
    glTexCoord2f(1, 0);
    glVertex3fv((float *)&v2);
    glTexCoord2f(1, 1);
    glVertex3fv((float *)&v3);
    glTexCoord2f(0, 1);
    glVertex3fv((float *)&v4);
}

/////////////////////////////////////////////////////////////////////////////
///                             efekti
/////////////////////////////////////////////////////////////////////////////

void Vihoviimeinen::renderScene(float pos, float alpha)
{
    int i = 0;
    std::vector<Alkuotus>::iterator it;
    this->frametimer->update();
    while (this->frametimer->stepsLeft())
    {
        for (i = 0; i < this->puucount; i++)
        {
            this->kasvit[i].update(pos);
        }
        for (it = otukset.begin(); it < otukset.end(); it++)
        {
            (*it).update();
        }
        this->frametimer->endStep();
        this->frametimer->endStep();
    }


    static float anal_cum = 0.0f;
    float analval = 0.1f*anal->get();

    anal_cum = anal_cum * 0.8f + analval * 0.2f;
    analval = anal_cum;

    glLoadIdentity();
    Vector3 cam = Vector3(0, 3, 7) + Vector3(0, 0, pos*5);
    Vector3 tar = cam + Vector3(0, 0, -5);
    Vector3 up = Vector3(0, 1, 0);
    
    gluLookAt(cam.x, cam.y, cam.z,
              tar.x, tar.y, tar.z,
              up.x, up.y, up.z);

 	this->merenpohja->renderWithNormalMaps(dmsGetTexture("deeptxt2.jpg"), dmsGetTexture("normal_map_deep2.jpg"), Vector3(1,1,1), alpha*0.3f);

    //taustarihmat
    glDisable(GL_TEXTURE_2D);
    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    glEnable(GL_LINE_SMOOTH);
    glDisable(GL_DEPTH_TEST);

    filter.init(true);
    glLineWidth(1.0f);
    for (i = 0; i < this->puucount/2; i++)
    {
        this->kasvit[i].draw(pos, alpha);
    }
    glLineWidth(2.0f);
    for (i = this->puucount/2; i < this->puucount; i++)
    {
        this->kasvit[i].draw(pos, alpha);
    }
    glEnable(GL_TEXTURE_2D);
    glBindTexture(GL_TEXTURE_2D, dmsGetTexture("flare_red.jpg")->getID());
    Vector3 xr, yr, zr;
    Math::antiRotate(&xr, &yr, &zr);
    glDisable(GL_DEPTH_TEST);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE);
    glDepthMask(0);
    glBegin(GL_QUADS);
    for (i = 0; i < this->puucount; i++)
    {
        this->kasvit[i].draw2(xr, yr, zr, pos, alpha, analval);
    }
    glEnd();
    glDepthMask(1);
    glEnable(GL_DEPTH_TEST );
    glDisable(GL_LINE_SMOOTH);

    filter.glow(6, 0.0075f, 0.0075f, 0.915f, -1.0f, 1.0f);

    glPointSize(3.0f);
    glHint(GL_POINT_SMOOTH_HINT, GL_NICEST);
    glEnable(GL_POINT_SMOOTH);
    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE);

    glDisable(GL_TEXTURE_2D);
    glBegin(GL_POINTS);
    std::vector<float>::iterator fi;
    std::vector<float>::iterator fi2;

    for (it = otukset.begin(), fi = this->otukset_st.begin(), fi2 = this->otukset_et.begin(); it < otukset.end(); it++, fi++, fi2++)
    {
        float a = 1.0f - Math::calcPosFloat(pos, *fi, *fi2);
        if (a > 0.0001f)
        {
            (*it).drawLine(alpha * a);
        }

    }
    glEnd();
    glDisable(GL_POINT_SMOOTH);

//    filter.radialblur();
    filter.drawNoiseOverlay((1-pos) * alpha * 0.1f);
}




Vihoviimeinen::Vihoviimeinen()
{
    int i = 0;
    const int groundX = 50;
    const int groundY = 50;
    const float size2 = 15.0f;
    this->merenpohja = new GroundPlane(groundX, groundY, size2, 4.0f);
    this->merenpohja->makeCircularFade(1.0f, 1.0f);
    this->frametimer = new FrameTimer(1000 / 60, 5);

    srand(5110);
    this->puucount = 1000;
    this->kasvit = new ViimeinenKasvi[this->puucount];
    for (i = 0; i < this->puucount; i++)
    {   
        this->kasvit[i].init();
    }
    for (i = 0; i < 500; i++)
    {
        Alkuotus otus;
        otus.init();
        if (i % 6 == 0)
        {
            BoundedMovement *movement = otus.getMovement();
            movement->setSpeed(Math::randBetween(0.03f, 0.1f));
        }
        this->otukset.push_back(otus);

        float st = Math::randBetween(0.1f, 0.7f);
        float et = st + Math::randBetween(0.02f, 0.04f);
        this->otukset_st.push_back(st);
        this->otukset_et.push_back(et);
    }
    anal = new Analyzer(3);

}

Vihoviimeinen::~Vihoviimeinen()
{
}


bool Vihoviimeinen::init(unsigned long s, unsigned long e)
{
	startTime = s;
	endTime = e;
	return true;
}

