#include "ConfigTool.hpp"

ConfigTool::ConfigTool()
{
	initialized = false; 
	holder = 0;
}

ConfigTool::~ConfigTool()
{
	holder = 0;
}

void ConfigTool::update(MSG msg)
{
	const int w = 1024;
	const int h = 768;
	dmsPerspective2D(w,h);

	glDisable(GL_TEXTURE_2D);
	glDisable(GL_BLEND);
	
	holder->render(0);

	glEnable(GL_BLEND);
	glEnable(GL_TEXTURE_2D);
	dmsPerspective3D();




			// Check for Windows messages in queue
			if(PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
			{

				//If app was closed send a note to the demo to stop the Demo loop
				if(msg.message == WM_LBUTTONDOWN)
				{
				
//				         int x  = LOWORD(lParam);
//						 int y  = HIWORD(lParam);



						// value = ui->
//						 holder->processEvent(GUIMousePressedEvent(x, y, false, true, false));
				/*
					//done = true;
					fadeOutTime = FadeOutMaxTime;
				} else if(msg.message == WM_KEYDOWN) {
					const float jump = 1000.0f;
					if(msg.wParam == VK_ESCAPE)		fadeOutTime = FadeOutMaxTime;
					else if(msg.wParam == VK_LEFT)	rewind_dir = -1;
					else if(msg.wParam == VK_RIGHT) rewind_dir = 1;

					else if(msg.wParam == VK_UP)	conf->arvo = 2.0f;
					else if(msg.wParam == VK_DOWN)  conf->arvo = 1.0f;

				} else if(msg.message == WM_KEYUP) {
					if(msg.wParam == VK_LEFT || msg.wParam == VK_RIGHT) 
						rewind_dir = 0;
					*/
/*

   case WM_LBUTTONDOWN:
      {

         HDC  hDC = GetDC(hWnd);
            SetPixel(hDC, LOWORD(lParam), HIWORD(lParam), RGB(0, 0, 255));
         ReleaseDC(hWnd, hDC);

         point.x  = LOWORD(lParam);
         point.y  = HIWORD(lParam);
         return 0;
      }

   case WM_LBUTTONUP:
      {
         if (point.x != -1)
         {
            HDC   hDC = GetDC(hWnd);
               MoveToEx(hDC, point.x, point.y, NULL);
               LineTo(hDC, LOWORD(lParam), HIWORD(lParam));
            ReleaseDC(hWnd, hDC);
            
            point.x   = -1;
            point.y   = -1;
         }
         return 0;
      }
   }
   
*/
				} else {
					// Other messages are handled by Windows own handlers
					TranslateMessage(&msg);
					DispatchMessage(&msg);
				}
			}



}

void ConfigTool::init()
{

	this->initialized = true;

	holder  = new GUIHolder();
	holder->init();

	GUIToggleButton *p;

	// Bottom buttons
	GUIButton *o = new GUIButton(125,635,14,14,"PREVIEW", "Preview");
	o->w = 80;
	o->h = 14;
	holder->addWidget(o);

	o = new GUIButton(125,665,14,14,"DOEFFECT", "Do effect");
	o->w = 80;
	o->h = 14;
	holder->addWidget(o);

	o = new GUIButton(125,695,14,14,"UNDOLAST", "Undo last");
	o->w = 80;
	o->h = 14;
	holder->addWidget(o);


	p = new GUIToggleButton(10,635,14,14,"BLEND_NORMAL", "Overwrite", true);
	p->w = 90;
	p->h = 14;
	holder->addWidget(p);
	p->setCanBeRaised(false);

	p = new GUIToggleButton(10,665,14,14,"BLEND_ADD", "Additive", false);
	p->w = 90;
	p->h = 14;
	holder->addWidget(p);
	p->setCanBeRaised(false);

	p = new GUIToggleButton(10,695,14,14,"BLEND_SUB", "Subtractive", false);
	p->w = 90;
	p->h = 14;
	holder->addWidget(p);
	p->setCanBeRaised(false);

	p = new GUIToggleButton(10,725,14,14,"BLEND_MULT", "Multiplicative", false);
	p->w = 90;
	p->h = 14;
	holder->addWidget(p);
	p->setCanBeRaised(false);
	
	// rgba
	p = new GUIToggleButton(10,605,10,10,"CHANNEL_R", "R", true);
	p->w = 14;
	p->h = 14;
	p->setColor(0.8f,0.3f,0.3f);
	holder->addWidget(p);
	
	p = new GUIToggleButton(35,605,10,10,"CHANNEL_G", "G", true);
	p->w = 14;
	p->h = 14;
	p->setColor(0.1f,0.6f,0.1f);
	holder->addWidget(p);
	
	p = new GUIToggleButton(60,605,10,10,"CHANNEL_B", "B", true);
	p->w = 14;
	p->h = 14;
	p->setColor(0.3f,0.3f,0.6f);
	holder->addWidget(p);
	
	p = new GUIToggleButton(85,605,10,10,"CHANNEL_A", "A", true);
	p->w = 14;
	p->h = 14;
	p->setColor(0.6f,0.6f,0.6f);
	holder->addWidget(p);
}


void ConfigTool::deinit()
{
	if(initialized==false)
		return;

	this->holder->deinit();
}


// ------------------------------------
// ID Stuff
// ------------------------------------
/*
std::string getNamebyID(int n) 
{
	int i;
	for(i=0; i<UI_CHOICES; i++)
		if(mainchoices[i].ID == n)
			return mainchoices[i].name;

	return "";
}


int getIDbyName(std::string name) 
{
	int i;
	for(i=0; i<UI_CHOICES; i++)
		if(mainchoices[i].name == name)
			return mainchoices[i].ID;
	
	return -1;
}
*/