#ifndef _LIGHTSYSTEM_HPP_
#define _LIGHTSYSTEM_HPP_

#include "externs.hpp"
#include "mathematics.hpp"

class Light 
{
protected:
	Light() { };
	virtual ~Light() { };
public:
	static void startLight(Vector pos, Vector diffuse, Vector specular, Vector ambient, float constant_attenuation=1.0f, float linear_attenuation=1.0f, float quadratic_attenuation=1.0f );
	static void startAmbientLight(Vector pos, Vector diffuse, Vector specular, Vector ambient, float constant_attenuation=1.0f, float linear_attenuation=1.0f, float quadratic_attenuation=1.0f );
	static void endLight();

	static void setMaterial(Vector diffuse, Vector specular, float shininess);
	static void resetMaterial();
};

#endif