#ifndef _CG_HPP_
#define _CG_HPP_

#include <Cg/cg.h>
#include <Cg/cgGL.h>

#include "externs.hpp"
//#include "lista2.hpp"

extern class CG cg;


class VertexShader
{
public:
    VertexShader(char *filename);
    VertexShader(CGcontext &cont, CGprofile &vertprofile, char *filename);
    ~VertexShader();

    void setConstants();
    void bind();

    char *getName();

    CGprogram program;
private:
    char *name;
};

class FragmentShader
{
public:
    FragmentShader(char *filename);
    FragmentShader(CGcontext &cont, CGprofile &vertprofile, char *filename);
    ~FragmentShader();

    void setConstants();
    void bind();

    char *getName();

    CGprogram program;
private:
    char *name;
};

class ShaderHolder;
#include "shader.hpp"

class CG
{
public:
    void init();
    void deinit();

    VertexShader *getVertexShader(char *name);
    FragmentShader *getFragmentShader(char *name);

    Lista2 *getVertexShaderList();
    Lista2 *getFragmentShaderList();

    void setupMatrices();

    void enableVertexShader();
    void enableFragmentShader();
    void disableVertexShader();
    void disableFragmentShader();

	ShaderHolder *shaders;

    CGcontext getContext();
    CGprofile getVertexProfile();
    CGprofile getFragmentProfile();

private:

    void loadAllShaders();

    Lista2 *vertexshaders;
    Lista2 *fragmentshaders;

    CGcontext context;
    CGprofile vertexProfile;
    CGprofile fragmentProfile;
};


#endif