#ifdef _DEBUG
	#include <stdlib.h>
	#include "../mmgr.h"
#endif

#include <math.h>

#include "Alkulattia.hpp"
#include "../mathematics.hpp"
#include "../primitives.hpp"

void Alkulattia::draw()
{
	const float pos = (time - startTime) / (endTime - startTime);
	float alpha = 1.0f;

	const float fadeinstart = 0.0f;
	const float fadeinstop = 0.25f;
	const float fadeoutstart = 0.90f;
	const float fadeoutstop = 1.0f;

	if (pos >= fadeinstart && pos <= fadeinstop)
		alpha *= (pos-fadeinstart) / (fadeinstop-fadeinstart);
	if (pos >= fadeoutstart && pos <= fadeoutstop)
		alpha *= 1-(pos-fadeoutstart) / (fadeoutstop-fadeoutstart);

//    filter.init(true);
	renderScene(pos, alpha);
//    filter.glow(8, 0.005f, 0.005f, 0.92f, -1.0f, 1.0f);
}

void Alkulattia::renderScene(float pos, float alpha)
{
    //dmsMsg("alkulattia::renderScene()\n");
    cam->useCamera(0);
/*
    glEnable(GL_TEXTURE_2D);
    glEnable(GL_DEPTH_TEST);
    glDisable(GL_BLEND);

    glDepthMask(0);
    glPushMatrix();
		
		const float bgc = 0.75f*alpha;
	    glColor4f(bgc, bgc, bgc, bgc);
	    glBindTexture(GL_TEXTURE_2D, dmsGetTexture("cau_001.jpg")->getID());

	    glRotatef(60, 1, 1, 1);

		Primitives::texturedCube(500, 1);
		
    glPopMatrix();
	glDepthMask(1);

*/

	glEnable(GL_BLEND);
	glEnable(GL_DEPTH_TEST);
	glEnable(GL_TEXTURE_2D);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);


	int realtime = dmsGetModulePosition();
	
	if(realtime > 26500)
	{
		Vector k1, k2, k3, k4;
		float kuusize = 15;
		float d = 100.0f;
		k1 = Vector(-kuusize, 16-kuusize, d);
		k2 = Vector( kuusize, 16-kuusize, d);
		k3 = Vector( kuusize, 16+kuusize, d);
		k4 = Vector(-kuusize, 16+kuusize, d);
    
		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE);
		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D, dmsGetTexture("moon.png")->getID());
		glDisable(GL_DEPTH_TEST);
		glColor4f(1,1,1,alpha*1.0f );

		const float mod = 1-Mathematics::calcPosFloat(pos, 0.986f, 1.0f);

    
		shaders.color->bind();

		shaders.color->setUniform1i("tex", 0);
		shaders.color->setUniform1f("saturate", 1*mod);
		shaders.color->setUniform1f("brightness", 0.25f*mod);
		shaders.color->setUniform1f("contrast", 1.2f+mod*0.95f);

			glBegin(GL_QUADS);

			glTexCoord2f(0, 0);
			glVertex3fv((float *)&k1);
			glTexCoord2f(1, 0);
			glVertex3fv((float *)&k2);
			glTexCoord2f(1, 1);
			glVertex3fv((float *)&k3);
			glTexCoord2f(0, 1);
			glVertex3fv((float *)&k4);

			glEnd();

		shaders.unbind();
	}



	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);





	glColor4f(0.79f,0.79f,0.79f,1);

	float multiplier = 68.0f;

	Vector p1 = Vector(-2, 0,-2)*multiplier;
	Vector p2 = Vector( 2, 0,-2)*multiplier;
	Vector p3 = Vector( 2, 0, 2)*multiplier;
	Vector p4 = Vector(-2, 0, 2)*multiplier;

	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, dmsGetTexture("maatesti.jpg")->getID());

	Primitives::renderTexturedPlaneWithFadeOut(p1,p2,p3,p4, 25, 60, Vector(alpha*1,alpha*1,alpha*1), Vector(), 5.0f, 12.0f, 0.7f);

}




Alkulattia::Alkulattia()
{	
}

Alkulattia::~Alkulattia()
{
}


bool Alkulattia::init(unsigned long s, unsigned long e)
{
	startTime = s;
	endTime = e;
	return true;
}

