#ifdef _DEBUG
	#include <stdlib.h>
	#include "../mmgr.h"
#endif

#include <math.h>

#include "Countdown.hpp"
#include "../mathematics.hpp"
#include "../primitives.hpp"

void Countdown::draw()
{
	const float pos = (time - startTime) / (endTime - startTime);
	float alpha = 1.0f;

	const float fadeinstart = 0.0f;
	const float fadeinstop = 0.1f;
	const float fadeoutstart = 0.90f;
	const float fadeoutstop = 1.0f;

	if (pos >= fadeinstart && pos <= fadeinstop)
		alpha *= (pos-fadeinstart) / (fadeinstop-fadeinstart);
	if (pos >= fadeoutstart && pos <= fadeoutstop)
		alpha *= 1-(pos-fadeoutstart) / (fadeoutstop-fadeoutstart);

//	renderScene(pos, alpha);
}

void Countdown::renderScene(float pos, float alpha)
{
/*
	cam->useCamera(0);


	// Kmynen fadeout .. 
	//if(pos>0.5f)
	{
		float a = (1-Mathematics::calcPosCos(pos, 0.9f, 1.0f));
		glColor4f(a,a,a,a);
		glTranslatef(5*a*a - 5, -7*a*a + 7, -5*a + 5);
		glRotatef(a*110.0f, 0.2f, 1.0f, -0.3f);
	}

	
	glDisable(GL_BLEND);
	glEnable(GL_DEPTH_TEST);
	glEnable(GL_TEXTURE_2D);

    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	
	shaders.synkka->bind();

	glActiveTextureARB(GL_TEXTURE0_ARB);
	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, dmsGetTexture("organic01.jpg")->getID());
	shaders.synkka->setUniform1i("tex0", 0);

	glActiveTextureARB(GL_TEXTURE1_ARB);
	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, dmsGetTexture("cau_009.jpg")->getID());
	shaders.synkka->setUniform1i("tex1", 1);

	glActiveTextureARB(GL_TEXTURE2_ARB);
	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, dmsGetTexture("dirt2.jpg")->getID());
	shaders.synkka->setUniform1i("tex2", 2);

	int realtime = dmsGetModulePosition();
    float pysyvyys = powf(sinf(Mathematics::calcPosFloat(realtime*1.0f, 94200+8000, 95800+8000)*3.141592f*0.5f), 1.7f);
    float sync = triggers->get(realtime) + pysyvyys;

	shaders.synkka->setUniform1f("scale", sync);

	//Vector light = Vector(1, 25, 0);
	//light = light.normalize();
	Matrix valorotate;
	valorotate.makeRotation(20.0f*pos, 0, 0);
	Vector light = Vector(1,1,1).normalize()*valorotate;
	shaders.lightfade->setUniform3f("lightDir", light.x, light.y, light.z);

	glColor4f(alpha,alpha,alpha, alpha);

			glPushMatrix();
				
				glScalef(0.009f,0.009f,0.009f);

				glRotatef(pos*19.0f+175, -0.64f, -0.34f, 0.7f);

					// piirt
					// * normaalit
					// * uv:t
					// * facet
					model->renderVBO();

			glPopMatrix();


	shaders.unbind();

	glActiveTextureARB(GL_TEXTURE2_ARB);
	glDisable(GL_TEXTURE_2D);

	glActiveTextureARB(GL_TEXTURE1_ARB);
	glDisable(GL_TEXTURE_2D);
	
	glActiveTextureARB(GL_TEXTURE0_ARB);
*/
}




Countdown::Countdown()
{	
}

Countdown::~Countdown()
{
//	model->freeVBO();
//	delete model;
}


bool Countdown::init(unsigned long s, unsigned long e)
{
//	model = new T3DVBO(dmsGetObject("3djytky2.t3d"));
//	model->createVBO();

    triggers = new TriggerSystem();
    triggers->add(88000+7500, 88500+7500);
    triggers->add(89000+8000, 90000+8000);
    triggers->add(90800+8000, 91800+8000);
    triggers->add(92500+8000, 93500+8000);
    triggers->add(94200+8000, 95200+8000);

	startTime = s;
	endTime = e;
	return true;
}

