#ifndef _Jytky2_HPP_
#define _Jytky2_HPP_

#include <stdio.h>
#include "../externs.hpp"
#include "../analyzer.hpp"
#include "../bpm.hpp"
#include "kliimaksi.hpp"

#include "tuli.hpp"

class JytkyP 
{
public:
	JytkyP();
	JytkyP(Vector pos, Vector dir, float lifetime);
	Vector pos;
	Vector dir;
	float lifetime;
	
	// draw + move
	// returns false if can be deleted
	bool update(Vector x, Vector y, Vector z, float dt, float scalemod);
};


class Jytky2 : public Base
{
	public:

		Jytky2();
		~Jytky2();

		bool init(unsigned long s, unsigned long e);
		void draw();

	private:
		void renderScene(float pos, float alpha);


		// ---------------
		// Iso modeli
		T3DVBO *model;

		// ---------------
		// Kiertomodeli
		T3DVBO *ruuvi;

		// ---------------
		// Particleheitin
		Lista2 *list;
		float lastTime;
		float lastAdd;
        int splinecount;
		CatmullRom **splinet;


		// ---------------
		// Luola
        int vertexcount;
        int facecount;
        int truefacecount;
        int xres, yres;
		T3DVertex *vertices;
        T3DFace *faces;
        float *radial;
		int luolalen;

		// ----------------
		// Kameraspline
		CatmullRom *cameraSpline;

		// ----------------
		// Sync sys
		Analyzer *anal;
		TriggerSystem *platessync; // Nopeuden vaihtavat kohdat

};

#endif
