#ifndef _Keiju_HPP_
#define _Keiju_HPP_

#include <stdio.h>
#include <vector>
#include "../externs.hpp"
#include "../bpm.hpp"


using namespace std;

const int FAIRY_STATE_NONE = 0;
const int FAIRY_STATE_BIRTH = 1;
const int FAIRY_STATE_WANDER = 2;
const int FAIRY_STATE_SEEK = 3;

class Fairy
{
public:
    Fairy();
    ~Fairy();

    int state;
    void update();
    void draw(float alpha);
    void initNewDirection();

    Vector currentPosition;
    float currentSize;

    float direction_a;
    float direction_b;

    bool canMove;
    float direction_delta_a;
    float direction_delta_b;
    float dest_direction_a;
    float dest_direction_b;
    Vector destination;

    Texture *flare;
};

class FairyParticle
{
public:
    float energy;
    float maxenergy;
    Vector pos;
    bool active;
};


class Keiju : public Base
{
	public:

		Keiju();
		~Keiju();

		bool init(unsigned long s, unsigned long e);
		void draw();

	private:
        vector<Fairy*> keijulista;

        int pcount;
        FairyParticle *particles;
       
		void renderScene(float pos, float alpha);
};

#endif
