#ifdef _DEBUG
	#include <stdlib.h>
	#include "../mmgr.h"
#endif

#pragma warning(disable: 4244)

#include <math.h>

#include "Lopputekstit.hpp"
#include "../mathematics.hpp"
#include "../primitives.hpp"

void Lopputekstit::draw()
{
	const float pos = (time - startTime) / (endTime - startTime);
	float alpha = 1.0f;

	const float fadeinstart = 0.0f;
	const float fadeinstop = 0.1f;
	const float fadeoutstart = 0.90f;
	const float fadeoutstop = 1.0f;

//    filter.init(true);
	renderScene(pos, alpha);
//    filter.glow(8, 0.005f, 0.005f, 0.92f, -1.0f, 1.0f);
}

void Lopputekstit::renderScene(float pos, float alpha)
{

    //dmsMsg("Lopputekstit::renderScene()\n");

	// -- 2d

/*
    glDisable(GL_DEPTH_TEST);
    glEnable(GL_TEXTURE_2D);
    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	//glBlendFunc(GL_ONE, GL_ONE);
    glLoadIdentity();
    dmsPerspective2D(800,600);
    glLoadIdentity();


	const int namecount = 7;
	const char* nimet[namecount] = 
	{
		"credits_napsa.png",
		"credits_kofeiini.png",
		"credits_rale.png",
		"credits_critikill.png",
		"credits_bridgeclaw.png",
		"credits_preacher.png",
		"credits_romeoknight.png",

	};

	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glEnable(GL_TEXTURE_2D);
	glColor4f(1,1,1,1);
	
	int drawtoy = 100;
	for(int i=0; i<namecount; i++)
	{
		Texture *t = dmsGetTexture(nimet[i]);
		const int w = t->getWidth()>>1;
		const int h = t->getHeight()>>1;

		int drawtox = 400 - (w>>1);

		glBindTexture(GL_TEXTURE_2D, t->getID());
		glBegin(GL_QUADS);
		 glTexCoord2f(0, 0);
		 glVertex2f(drawtox, drawtoy+h);
		 glTexCoord2f(1, 0);
		 glVertex2f(drawtox+w, drawtoy+h);
		 glTexCoord2f(1, 1);
		 glVertex2f(drawtox+w, drawtoy);
		 glTexCoord2f(0, 1);
		 glVertex2f(drawtox, drawtoy);
		glEnd();

		drawtoy += h;
	}
*/

	const int namecount = 7;
	const char* nimet[namecount] = 
	{
		"credits_bridgeclaw.png",
		"credits_critikill.png",
		"credits_kofeiini.png",
		"credits_napsa.png",
		"credits_preacher.png",
		"credits_rale.png",
		"credits_romeoknight.png",
	};

	const float ajat[namecount] = 
	{
		0.15f, 0.15f,
		0.35f, 0.35f,
		0.55f, 0.55f,
		0.7f
	};

	Vector paikat[namecount] = 
	{
		Vector(-0.4f, -0.7f, -13.2f),
		Vector( 0.3f,  0.7f, -13.2f),
		Vector(-0.2f, -0.7f, -13.2f),
		Vector( 0.5f,  0.7f, -13.2f),
		Vector( 0.27f,  0.7f, -13.2f),
		Vector(-0.21f, -0.7f, -13.2f),
		Vector(-0.15f,  0.7f, -13.2f),
	};

	glLoadIdentity();
	glTranslatef(0, 0, -15);

	glMatrixMode(GL_MODELVIEW_MATRIX);

	// fade out alku
	// 285500

	for (int i = 0; i < namecount; i++)
	{
		glPushMatrix();
		Vector p = paikat[i];

		const float move = Mathematics::calcPosFloat(pos, ajat[i], ajat[i]+0.25f);
		glTranslatef(p.x*5 + (i%2? move : -move), p.y*5, p.z);
		Texture *t = dmsGetTexture(nimet[i]);
		const int w = t->getWidth() * 0.025f;
		const int h = t->getHeight() * 0.025f;

		glTranslatef(-w * 0.5f, 0, 0);

		glEnable(GL_TEXTURE_2D);
		glDisable(GL_DEPTH_TEST);
		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		const float fade = Mathematics::calcPosFloat(pos, ajat[i], ajat[i]+ 0.075f) * 
						   (1-Mathematics::calcPosFloat(pos, ajat[i]+0.12f, ajat[i]+0.14f));
		glColor4f(1,1,1,alpha * fade);
		glBindTexture(GL_TEXTURE_2D, t->getID());

		glBegin(GL_QUADS);
		glTexCoord2f(0, 1);
		glVertex3f(0, 0, 0);
		glTexCoord2f(1, 1);
		glVertex3f(w, 0, 0);
		glTexCoord2f(1, 0);
		glVertex3f(w, h, 0);
		glTexCoord2f(0, 0);
		glVertex3f(0, h, 0);

		glEnd();
		glPopMatrix();
		
	}



	// Kuva names
/*
	shaders.gradientfade->bind();

	glActiveTextureARB(GL_TEXTURE0_ARB);
	glEnable(GL_TEXTURE_2D);
    glBindTexture(GL_TEXTURE_2D, dmsGetTexture("creets.png")->getID());

	glActiveTextureARB(GL_TEXTURE1_ARB);
	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D,dmsGetTexture("fade.jpg")->getID()); 
    
	shaders.gradientfade->setUniform1i("tex", 0);  
	shaders.gradientfade->setUniform1i("gradient", 1);  

	float kuva2in = Mathematics::calcPosFloat(pos, 0.477f, 0.58f);
	float kuva2out = 1-Mathematics::calcPosFloat(pos, 0.65f, 0.85f);
	shaders.gradientfade->setUniform1f("value",  kuva2in*kuva2out); 
	shaders.gradientfade->setUniform1f("value2", (kuva2in+0.1f*kuva2in)*kuva2out);
    
    glBegin(GL_QUADS);
    glTexCoord2f(0, 1);
    glVertex2f(0, 0);
    glTexCoord2f(1, 1);
    glVertex2f(1, 0);
    glTexCoord2f(1, 0);
    glVertex2f(1, 1);
    glTexCoord2f(0, 0);
    glVertex2f(0, 1);
    glEnd();
    

	glActiveTextureARB(GL_TEXTURE1_ARB);
	glDisable(GL_TEXTURE_2D);
	glActiveTextureARB(GL_TEXTURE0_ARB);
	glDisable(GL_TEXTURE_2D);

	shaders.unbind();
*/
    dmsPerspective3D();
    glLoadIdentity();
    glDepthMask(1);

}




Lopputekstit::Lopputekstit()
{	
}

Lopputekstit::~Lopputekstit()
{
}


bool Lopputekstit::init(unsigned long s, unsigned long e)
{

	startTime = s;
	endTime = e;
	return true;
}

