#ifndef _LUOLA_HPP_
#define _LUOLA_HPP_

#include <stdio.h>
#include "../externs.hpp"

class LuolaFragmentShader
{
public:

    LuolaFragmentShader(char *filename);
    ~LuolaFragmentShader();

    void bind();
    void initFrame(float pos);
    void freeFrame();

private:
    FragmentShader *fs;
    CGparameter texture;
    CGparameter texture2;
    CGparameter time;
};

class Luola : public Base
{
	public:

		Luola();
		~Luola();

		bool init(unsigned long s, unsigned long e);
		void draw();

	private:

        LuolaFragmentShader *fs;

		void renderScene(float pos, float alpha);

        int vertexcount;
        int facecount;
        int totalpolycount;

        int xres, zres;
        T3DVertex *vertices;
        T3DFace *faces;
        float *radial;

};

#endif
