#ifdef _DEBUG
	#include <stdlib.h>
	#include "../mmgr.h"
#endif

#include <math.h>

#include "Matka.hpp"
#include "../mathematics.hpp"
#include "../primitives.hpp"

void Matka::draw()
{
	const float pos = (time - startTime) / (endTime - startTime);
	float alpha = 1.0f;

	const float fadeinstart = 0.0f;
	const float fadeinstop = 0.1f;
	const float fadeoutstart = 0.90f;
	const float fadeoutstop = 1.0f;

	if (pos >= fadeinstart && pos <= fadeinstop)
		alpha *= (pos-fadeinstart) / (fadeinstop-fadeinstart);
	if (pos >= fadeoutstart && pos <= fadeoutstop)
		alpha *= 1-(pos-fadeoutstart) / (fadeoutstop-fadeoutstart);

    filter.init(true);
	renderScene(pos, alpha);
    filter.glow(8, 0.005f, 0.005f, 0.89f, -1.0f, 1.0f);
}

void Matka::renderScene(float pos, float alpha)
{
    int i;
/*
    Vector cam = Vector(0, 0, -7);
    Vector tgt = Vector(0, 0, 0);
    Vector upw = Vector(0, 1, 0);
    glLoadIdentity();
    gluLookAt(cam.x, cam.y, cam.z, tgt.x, tgt.y, tgt.z, upw.x, upw.y, upw.z);
//    glRotatef(pos*170, 0.7f, 0.8f, 0.9f);
*/
    cam->useCamera(0);

    const float emitterspeed = 4.5f;
    const float epos = pos * emitterspeed;
    Vector emitter = Vector(cosf(epos*18), (0.7f*cosf(epos*11)*sinf(epos*7))*2, 1.4f*cosf(epos*25)) * 1.5f;

    static float prevpos = 0.0f;
    static float cumultime = 0.0f;
    float dt = pos - prevpos;
    prevpos = pos;

    cumultime += dt;
    const float addlimit = 0.0002f;

    static int particleindex = 0;

    while (cumultime > addlimit)
    {
        //add particles
        for (int i = 0; i < 5; i++)
        {
            if (!parts[particleindex].is)
            {
                parts[particleindex].st = pos;
                parts[particleindex].et = pos + 0.02f + Mathematics::randFloat()*0.07f;
                parts[particleindex].pos = emitter + Mathematics::randVectSphere()*Mathematics::randFloat()*0.15f;
                parts[particleindex].dir = Mathematics::randVectSphere();
                parts[particleindex].size = 0.02f+0.07f*Mathematics::randFloat();
                parts[particleindex].a = 1.0f;//0.3f+0.3f*Mathematics::randFloat();
                parts[particleindex].maxenergy = 0.1f+Mathematics::randFloat()*0.1f;
                parts[particleindex].energy = parts[particleindex].maxenergy;
                parts[particleindex].is = true;
            }
            particleindex++;
            particleindex %= maxp;
        }

        cumultime -= addlimit;
    }
/*
    int activepart = 0;
    for (i=0;i<maxp;i++)
    {
        if (parts[i].is)
            activepart++;
    }
    dmsConsoleMsg(0, 0, "active particles = %d\n", activepart);
*/


    glBindTexture(GL_TEXTURE_2D, dmsGetTexture("flower64x64.png")->getID());
    glEnable(GL_TEXTURE_2D);
    glEnable(GL_BLEND);
    glDisable(GL_DEPTH_TEST);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

	Vector x, y, z;
	Mathematics::antiRotate(&x, &y, &z);

    glBegin(GL_QUADS);
    for (i = 0; i < maxp; i++)
    {
        if (parts[i].is)
        {
            float t = Mathematics::calcPosFloat(pos, parts[i].st,parts[i].et);
            if (t > 0.0001f)
            {
                const float gravity = 3.0f;
                const float dirspeed = 2.5f;
                const float globalalpha = 0.7f;

                parts[i].energy -= dt;
//               parts[i].pos.y -= dt * gravity;
                parts[i].pos += parts[i].dir * dirspeed * dt;
                if (parts[i].energy > 0.0001f)
                {
                    float size = parts[i].size*t;
                    Vector p = parts[i].pos;
    	            Vector v1 = p - x*size - y*size;
	                Vector v2 = p + x*size - y*size;
	                Vector v3 = p + x*size + y*size;
	                Vector v4 = p - x*size + y*size;
                    glColor4f(1,1,1,globalalpha*t*alpha*parts[i].energy / parts[i].maxenergy);

	                glTexCoord2f(0, 0);
	                glVertex3fv((float *)&v1);
	                glTexCoord2f(1, 0);
	                glVertex3fv((float *)&v2);
	                glTexCoord2f(1, 1);
	                glVertex3fv((float *)&v3);
	                glTexCoord2f(0, 1);
	                glVertex3fv((float *)&v4);
                }
                else
                {
                    parts[i].is = false;
                }
            }
        }
    }
    glEnd();



}




Matka::Matka()
{	
    int i;
    maxp = 6000;
    parts = new MatkaPart[maxp];

    for (i=0;i<maxp;i++)
    {
        parts[i].is = false;

    }
}

Matka::~Matka()
{
    delete [] parts;
}


bool Matka::init(unsigned long s, unsigned long e)
{
	startTime = s;
	endTime = e;
	return true;
}

