#ifndef _Revolution_HPP_
#define _Revolution_HPP_

#include <stdio.h>
#include "../externs.hpp"
#include "../bpm.hpp"

class RevolutionObject
{
public:

    RevolutionObject(int count, CatmullRom *spline);
    void draw(float time,float alpha);

    Vector pos;
    float st;
    float et;

    float rotatemulx;
    float rotatemulz;
    float speed1;
    float speed2;
    float speed3;

    float *splinelengths;
    float *splinelengthphases;
    float *splinelengthspeeds;
    Vector *splinecolors;

    Vector color;
    int count;
    CatmullRom **splines;

};

class Revolution : public Base
{
	public:

		Revolution();
		~Revolution();

		bool init(unsigned long s, unsigned long e);
		void draw();

	private:
        int ocount;
        RevolutionObject **objects;
        int tilpecount;
        Vector *tilpet;
        float *tilpephases;
        float *tilpespeeds;
        float *tilpesizes;
        float *tilpestart;
        float *tilpeend;
        

		unsigned int fbo_id;
		unsigned int fbo_tex_rgb;
		unsigned int fbo_tex_depth;

		void renderScene(float pos, float alpha);
};

#endif
