
#ifndef _Stream_HPP_
#define _Stream_HPP_

#include <stdio.h>
#include "../externs.hpp"
#include "../bpm.hpp"

class StreamParticle
{
public:
    float colorphase;
    float colorspeed;
    float movephase1;
    float movespeed1;
    float movephase2;
    float movespeed2;
    float movephase3;
    float movespeed3;
    float moveradius;
    float positionspeed;
    float positionphase;
};

class StreamSpline
{
public:
    StreamSpline(int pcount, Vector &start, Vector &end);
    ~StreamSpline();

    CatmullRom *polku;
    int pcount;
    StreamParticle *particles;

};


class Stream : public Base
{
	public:

		Stream();
		~Stream();

		bool init(unsigned long s, unsigned long e);
		void draw();
		void drawParticles(float pos, float alpha);
		
		void RenderRefractionAndDepth(float pos, float alpha);
		void RenderReflection(float pos, float alpha);
		void RenderWater(float pos, float alpha);

	private:
        int scount;
        StreamSpline **splines;

		int starCount;
		Vector *stars;
		Mesh *kuu;

		int smokeCount;
		Vector *smoke;

		void renderScene(float pos, float alpha);
};

#endif
