#ifdef _DEBUG
	#include <stdlib.h>
	#include "../mmgr.h"
#endif

#include <math.h>

#include "Synkka.hpp"
#include "../mathematics.hpp"
#include "../primitives.hpp"

void Synkka::draw()
{
	const float pos = (time - startTime) / (endTime - startTime);
	float alpha = 1.0f;

	const float fadeinstart = 0.0f;
	const float fadeinstop = 0.01f;
	const float fadeoutstart = 0.90f;
	const float fadeoutstop = 1.0f;

	if (pos >= fadeinstart && pos <= fadeinstop)
		alpha *= (pos-fadeinstart) / (fadeinstop-fadeinstart);
	if (pos >= fadeoutstart && pos <= fadeoutstop)
		alpha *= 1-(pos-fadeoutstart) / (fadeoutstop-fadeoutstart);

//   filter.init(true);
	renderScene(pos, alpha);
//	filter.coloradjust(1.43f, 1.75f, 1.0f);	// huoh
//    filter.glow(4, 0.005f, 0.005f, 0.90f, -1.0f, 1.0f);
}

void Synkka::renderScene(float pos, float alpha)
{
    int i = 0;
    //tausta
    glDepthMask(0);
    //glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	//glBlendFunc(GL_OBE
    glDisable(GL_DEPTH_TEST);
    glEnable(GL_TEXTURE_2D);
    glDisable(GL_BLEND);

    //glBindTexture(GL_TEXTURE_2D, dmsGetTexture("raabeli.jpg")->getID());
	
    glLoadIdentity();

    int realtime = dmsGetModulePosition();
    float flip = powf(sinf(Mathematics::calcPosFloat(realtime*1.0f, 87000, 87600)*3.141592f*0.5f), 1.7f);	
    float tausta_alpha_mod = 0.9f+flip*0.2f-0.2f*(Mathematics::calcPosFloat(pos, 0.5f,0.52f));
    glColor4f(1,1,1,alpha*tausta_alpha_mod);
/*    
    dmsPerspective2D(1,1);

    float x  = 0.1f  + pos*pos*pos*0.25f;
	float y  = 0.15f + pos*0.25f;
	float x2 = x + 0.5f - 0.105f*flip;
	float y2 = y + 0.5f - 0.105f*flip;
	

    glPushMatrix();
	glBegin(GL_QUADS);
		glTexCoord2f(x, y2);
		glVertex2f(0, 0);
		glTexCoord2f(x2, y2);
		glVertex2f(1, 0);
		glTexCoord2f(x2, y);
		glVertex2f(1, 1);
		glTexCoord2f(x, y);
		glVertex2f(0, 1);
    glEnd();
    glPopMatrix();
*/

	// ------------------
	// Caustic
	// ------------------

	// Caustic numero
	int n = int(pos*32*20)%32 + 1;
	
	// Haetaan vastaava tekstuuri
	char buf[75];
	sprintf(buf, "cau_0%02d.jpg", n);
	Texture *t = dmsGetTexture(buf);


	//int realtime = dmsGetModulePosition();
    float pysyvyys = powf(sinf(Mathematics::calcPosFloat(realtime*1.0f, 94200+8000, 95800+8000)*3.141592f*0.5f), 1.7f);
    float sync = triggers->get(realtime) + pysyvyys;

	shaders.synkkatausta->bind();

    glActiveTextureARB(GL_TEXTURE0_ARB);
    glEnable(GL_TEXTURE_2D);
    glBindTexture(GL_TEXTURE_2D, dmsGetTexture("fastmusicpart-mood.jpg")->getID());
	shaders.synkkatausta->setUniform1i("texunit0", 0);

    glActiveTextureARB(GL_TEXTURE1_ARB);
    glEnable(GL_TEXTURE_2D);
    glBindTexture(GL_TEXTURE_2D, t->getID());
	shaders.synkkatausta->setUniform1i("texunit1", 1);

	const float sync_ = sync*0.0107f;
	shaders.synkkatausta->setUniform1f("displace_amountx", cosf(pos*35.0f)*sync_);
	shaders.synkkatausta->setUniform1f("displace_amountx", sinf(pos*35.0f)*sync_);
	shaders.synkkatausta->setUniform1f("alpha", 1);

		glLoadIdentity();
		float move = pos*0.1f;
		glTranslatef(move, 0, -1.0f-pos*0.2f);
		glRotatef(flip*flip*16.0f, 0,0,1);
		float size = 1.0f;
		float aspect = 480 / 640.0f;
		glBegin(GL_QUADS);
		//glTexCoord2f(0, 0);
		glMultiTexCoord2fARB(GL_TEXTURE0_ARB, 0.0f, 0.0f);
		glMultiTexCoord2fARB(GL_TEXTURE1_ARB, 0.0f, 0.0f);
		glVertex3f(-size, -size*aspect, 0);
		//glTexCoord2f(1, 0);
		glMultiTexCoord2fARB(GL_TEXTURE0_ARB, 1.0f, 0.0f);
		glMultiTexCoord2fARB(GL_TEXTURE1_ARB, 1.0f, 0.0f);
		glVertex3f( size, -size*aspect, 0);
		//glTexCoord2f(1, 1);
		glMultiTexCoord2fARB(GL_TEXTURE0_ARB, 1.0f, 1.0f);
		glMultiTexCoord2fARB(GL_TEXTURE1_ARB, 1.0f, 1.0f);
		glVertex3f( size,  size*aspect, 0);
		//glTexCoord2f(0, 1);
		glMultiTexCoord2fARB(GL_TEXTURE0_ARB, 0.0f, 1.0f);
		glMultiTexCoord2fARB(GL_TEXTURE1_ARB, 0.0f, 1.0f);
		glVertex3f(-size,  size*aspect, 0);
		glEnd();

	shaders.unbind();

    glActiveTextureARB(GL_TEXTURE1_ARB);
    glDisable(GL_TEXTURE_2D);
    
	glActiveTextureARB(GL_TEXTURE0_ARB);
    glDisable(GL_TEXTURE_2D);
		
/*
    dmsPerspective3D();
    glLoadIdentity();
*/
    glDepthMask(1);

}




Synkka::Synkka()
{
	triggers = new TriggerSystem();
	triggers->add(76839, 76989+1050, TRIGGER_COS);
	triggers->add(77491, 77641+1050, TRIGGER_COS);
	triggers->add(77900, 78050+1050, TRIGGER_COS);
	triggers->add(79251, 79401+1050, TRIGGER_COS);
	triggers->add(79845, 79995+1050, TRIGGER_COS);
	triggers->add(80800, 80950+1050, TRIGGER_COS);
	triggers->add(81529, 81679+1050, TRIGGER_COS);
	triggers->add(82623, 82773+1050, TRIGGER_COS);
	triggers->add(83484, 83634+1050, TRIGGER_COS);
	triggers->add(84275, 84425+1050, TRIGGER_COS);
	triggers->add(86091, 86241+1050, TRIGGER_COS);
	triggers->add(86905, 87055+1050, TRIGGER_COS);
	triggers->add(87836, 87986+1050, TRIGGER_COS);
	triggers->add(90305, 90455+1050, TRIGGER_COS);
	triggers->add(91588, 91738+1050, TRIGGER_COS);
	triggers->add(92914, 93064+1050, TRIGGER_COS);
	triggers->add(93822, 93972+1050, TRIGGER_COS);
	triggers->add(94637, 94787+1050, TRIGGER_COS);
	triggers->add(96360, 96510+1050, TRIGGER_COS);
	triggers->add(97205, 97355+1050, TRIGGER_COS);
	triggers->add(98079, 98229+1050, TRIGGER_COS);
	triggers->add(99774, 99924+1050, TRIGGER_COS);
	triggers->add(102288, 102438+1050, TRIGGER_COS);


}

Synkka::~Synkka()
{
}


bool Synkka::init(unsigned long s, unsigned long e)
{
	startTime = s;
	endTime = e;
	return true;
}

