#ifndef _Synkkakappale_HPP_
#define _Synkkakappale_HPP_

#include <stdio.h>
#include "../externs.hpp"
#include "../bpm.hpp"

class SynkkaStrip
{
public:

    SynkkaStrip(int yres, float radius, float width);
    ~SynkkaStrip();
    void render(float pos, float alpha, float sync, float musta, float kerroin);

    float st;
    float et;

    int yres;
    Vector *vertices;
    Vector *normals;

    float *u;
    float *v;

    Vector rot1;
    Vector rot2;

};

class Synkkakappale : public Base
{
	public:

		Synkkakappale();
		~Synkkakappale();

		bool init(unsigned long s, unsigned long e);
		void draw();

	private:
        Mesh *sky;
        int count;
        TriggerSystem *triggers;
        SynkkaStrip **strips;
		void renderScene(float pos, float alpha);
		void render3ds(float pos, float alpha);
		
		T3DVBO *model;
};

#endif
