#include "GUIButton.h"

GUIButton::GUIButton(int x, int y, int w, int h, const char *callback, const char *label) : GUIElement(x, y, w, h, callback)
{
	this->widgetType = GUIBUTTON;
	this->label = label;
}

void GUIButton::setHolderPointer(GUIHolder *holder)
{
	this->holder = holder;
	int ww = holder->font->calculateWidth(label.c_str())+15;
	int hh = holder->font->calculateHeight(label.c_str())+8;

	if(w < ww) w = ww;
	if(h < hh) h = hh;
}

void GUIButton::render(float dt)
{
	this->GUIElement::render(dt);

	glBegin(GL_QUADS);
		glVertex2i(x,	y);
		glVertex2i(x+w,	y);
		glVertex2i(x+w,	y+h);
		glVertex2i(x,	y+h);
	glEnd();

	if(holder!=0)
	{
		holder->font->setColor(1,1,1);
		holder->font->printCenteredXY(label.c_str(), x+w/2, y+h/2);
	}
}

std::string GUIButton::checkKeyboardEvents(GUIKeyboardEvent &me)
{
	//me.pressed==false
	if(strcmp(me.key,"return")==0)
	{
		return this->callback;
	}

	return "";
}