#include "GUIelement.h"

GUIElement::GUIElement(int x, int y, int w, int h, const char *callback)
{
	this->x = x;
	this->y = y;
	this->w = w;
	this->h = h;
	this->callback = callback;
	this->focused = false;
	this->hover = false;
	this->widgetType = GUIUNDEFINED;
	this->holder = 0;
	this->r = 0.4f;
	this->g = 0.5f;
	this->b = 0.6f;
}

GUIElement::~GUIElement()  {}

bool GUIElement::operator == (GUIElement const &elem)
{
	if(callback == elem.callback)
		return true;
	else return false;

}

std::string GUIElement::checkKeyboardEvents(GUIKeyboardEvent &me)
{
	return "";
}

std::string GUIElement::checkMouseMovedEvents(GUIMouseMovedEvent &me) 
{
	if(isHit(me.x, me.y))
		this->hover = true;
	else 
		this->hover = false;

	return "";
}

std::string GUIElement::checkMousePressedEvents(GUIMousePressedEvent &me) 
{
	if(isHit(me.x, me.y))
	{
		if(me.left==true)
			return this->callback;
		else 
			return "CHANGE_FOCUS_TO_THIS";
	} 
	return "";
}

bool GUIElement::isHit(int x_, int y_)
{
	const int x = this->x;
	const int y = this->y;
	const int xw = this->x+this->w;
	const int yh = this->y+this->h;

	if(x_ > x  && y_ > y && x_ < xw && y_ < yh)
	   return true;
	else 
	   return false;
}


void GUIElement::setHolderPointer(GUIHolder *hold) 
{

	this->holder = hold;
}

void GUIElement::render(float dt)
{
	// clamp?
	if(this->hover)
	 glColor3f(r-0.1f, g, b+0.1f);
	else if(this->focused)
	 glColor3f(r+0.3f, g+0.2f, b+0.1f);
	else 
	 glColor3f(r,g,b);
}

void GUIElement::setCenter(int x, int y) 
{
	this->x = x-w/2;
	this->y = y-h/2;
}


void GUIElement::setColor(float _r, float _g, float _b)
{
	r = _r;
	g = _g;
	b = _b;
}