#include "GUISlider.h"

GUISlider::GUISlider(int x, int y, int w, int h, const char *callback, float initialvalue, std::string label, int minim, int maxim) : GUIElement(x,y,w,h,callback)
{
	this->label = label;
	
	this->minimum = minim;
	this->maximum = maxim;

	this->smallAdjustment = (maxim-minim)/256;
	this->smallAdjustment = GUISnapValue(smallAdjustment, 1, maximum);

	this->bigAdjustment = (maxim-minim)/32;
	this->bigAdjustment  = GUISnapValue(bigAdjustment, 0, maximum);
	
	this->scale = initialvalue;
	this->scale = GUISnapValue(scale, minimum, maximum);

	this->widgetType = GUISLIDER;
	left[0]=0.4f;
	left[1]=0.5f;
	left[2]=0.6f;
	right[0]=0.84f;
	right[1]=0.85f;
	right[2]=0.86f;

}

void GUISlider::render(float dt)
{

	float mod = 1.0f;

	if(this->hover)
	  mod = 1.0f;
		//glColor3f(0.5f, 0.5f, 0.5f);
	else if(this->focused)
	  mod = 1.2f;
		//glColor3f(0.7f, 0.7f, 0.7f);
	else 
	 //glColor3f(0.4f,0.5f,0.6f);
	  mod = 0.75f;
	

	glBegin(GL_QUADS);
	glColor3f(left[0]*mod, left[1]*mod, left[2]*mod);
		glVertex2i(x,	y+h);
		glVertex2i(x,	y);
		glColor3f(right[0]*mod, right[1]*mod, right[2]*mod);
		glVertex2i(x+w,	y);
		glVertex2i(x+w,	y+h);
	glEnd();

	float endpos;

	if (scale <= minimum) endpos = 0;
	if (scale >= maximum) endpos = 1;
	else endpos = (float)(scale-minimum)/(maximum-minimum);

	endpos *= w;


	//Pystymarkkeri
	glColor3f(1,1,1);
	glBegin(GL_LINES);
		glVertex2f(x+endpos,(float)y);
		glVertex2f(x+endpos,(float)y+h);
	glEnd();

	char buf[100];

	sprintf(buf, "%s: %d", label.c_str(), this->scale);
		
	holder->font->printCenteredXY(buf, x+w/2, y+h/2);
}


std::string GUISlider::checkMousePressedEvents(GUIMousePressedEvent &me) 
{
	if(isHit(me.x, me.y))
	{
		if(me.right==true)
		{
			return "CHANGE_FOCUS_TO_THIS";
		} else 
		if(me.left==true)
		{
			const float l = x;
			const float r = x+w;

			float tmp = 0;
			if (me.x <= l)   tmp = 0;
			if (me.x >= r)   tmp = 1;
			else tmp = (float)(me.x-l)/(r-l);

			scale = GUISnapValue(this->minimum+(this->maximum-this->minimum)*tmp, this->minimum, this->maximum);

			return this->callback;
		}
	}
	return "";
}

std::string GUISlider::checkMouseMovedEvents(GUIMouseMovedEvent &me)
{
	GUIElement::checkMouseMovedEvents(me);

	if(me.eventtype==100)
		{
		const float l = x;
		const float r = x+w;

		float tmp = 0;
		if (me.x <= l)   tmp = 0;
		if (me.x >= r)   tmp = 1;
		else tmp = (float)(me.x-l)/(r-l);

		scale = GUISnapValue(this->minimum+(this->maximum-this->minimum)*tmp, this->minimum, this->maximum);
	}
	return " ";
}

std::string GUISlider::checkKeyboardEvents(GUIKeyboardEvent &me) 
{

	if(me.pressed==false) return "";

	float mod = this->smallAdjustment;

	if(me.shift==true) 
		mod = 10;//this->bigAdjustment;

	else if(strcmp(me.key, "left")==0)
		this->scale-=mod;
	else if(strcmp(me.key, "right")==0)
		this->scale+=mod;

	mod = this->bigAdjustment;
	if(strcmp(me.key, "down")==0)
		this->scale-=mod;
	else if(strcmp(me.key, "up")==0)
		this->scale+=mod;

	scale = GUISnapValue(scale, this->minimum, this->maximum);

	return "";
}	

int GUISlider::getValue() 
{ 
	return scale;
}

void GUISlider::setValue(int i)
{
	scale = GUISnapValue(i, minimum, maximum);
}


void GUISlider::setSmallAdjustment(int i)
{
	this->smallAdjustment = GUISnapValue(i, 0, maximum);
}
void GUISlider::setBigAdjustment(int i)
{
	this->bigAdjustment = GUISnapValue(i, 0, maximum);
}

void GUISlider::setMinimum(int i)
{
	this->minimum = i;
	this->scale = GUISnapValue(scale, minimum, maximum);
}

void GUISlider::setMaximum(int i)
{
	this->maximum = i;
	this->smallAdjustment = GUISnapValue(this->smallAdjustment, 0, maximum);	
	this->bigAdjustment = GUISnapValue(this->bigAdjustment, 0, maximum);
	this->scale = GUISnapValue(scale, minimum, maximum);
}

void GUISlider::setLeft(float r,float g, float b)
{
	left[0] = r;
	left[1] = g;
	left[2] = b;
}
void GUISlider::setRight(float r,float g, float b) 
{
	right[0] = r;
	right[1] = g;
	right[2] = b;
}
