#include "LightSystem.hpp"

// do lighting on objects with texture 0 as basecolor
void Light::startLight(Vector3 pos, Vector3 diffuse, Vector3 specular, Vector3 ambient, float constant_attenuation, float linear_attenuation, float quadratic_attenuation )
{
        GLfloat light0_position[] = { pos.x, pos.y, pos.z, 0 };
        GLfloat light0_diffuse[]  = { diffuse.x, diffuse.y, diffuse.z, 1 };
		GLfloat light0_specular[] = { specular.x, specular.y, specular.z, 1 };
		GLfloat light0_ambient[] =  { ambient.x, ambient.y, ambient.z, 1 };
        glLightfv(GL_LIGHT0, GL_POSITION, light0_position);
		glLightfv(GL_LIGHT0, GL_AMBIENT, light0_ambient);
        glLightfv(GL_LIGHT0, GL_DIFFUSE, light0_diffuse);
        glLightfv(GL_LIGHT0, GL_SPECULAR, light0_specular);
		
		glLightf(GL_LIGHT0, GL_CONSTANT_ATTENUATION, constant_attenuation);
		glLightf(GL_LIGHT0, GL_LINEAR_ATTENUATION, linear_attenuation);
		glLightf(GL_LIGHT0, GL_QUADRATIC_ATTENUATION, quadratic_attenuation);

	shaders.lightpoint->bind();
	shaders.lightpoint->setUniform1i("tex", 0);
}

// do lighting with ambient color - [=no texture]
void Light::startAmbientLight(Vector3 pos, Vector3 diffuse, Vector3 specular,	Vector3 ambient, float constant_attenuation, float linear_attenuation, float quadratic_attenuation )
{
        GLfloat light0_position[] = { pos.x, pos.y, pos.z, 0 };
        GLfloat light0_diffuse[]  = { diffuse.x, diffuse.y, diffuse.z, 1 };
		GLfloat light0_specular[] = { specular.x, specular.y, specular.z, 1 };
		GLfloat light0_ambient[] =  { ambient.x, ambient.y, ambient.z, 1 };
        glLightfv(GL_LIGHT0, GL_POSITION, light0_position);
		glLightfv(GL_LIGHT0, GL_AMBIENT, light0_ambient);
        glLightfv(GL_LIGHT0, GL_DIFFUSE, light0_diffuse);
        glLightfv(GL_LIGHT0, GL_SPECULAR, light0_specular);
		
		glLightf(GL_LIGHT0, GL_CONSTANT_ATTENUATION, constant_attenuation);
		glLightf(GL_LIGHT0, GL_LINEAR_ATTENUATION, linear_attenuation);
		glLightf(GL_LIGHT0, GL_QUADRATIC_ATTENUATION, quadratic_attenuation);

	shaders.lightambientpoint->bind();
}

// disable lighting shader
void Light::endLight() {
	// sama kuin ; [glExt.glUseProgramObjectARB(0);]
	shaders.lightpoint->unbind();
}
	
// set material values [Vector3s are RGB, 3*[0-1] ] & [shininess: 0-128]
void Light::setMaterial(Vector3 diffuse, Vector3 specular, float shininess) {       
		GLfloat material_diffuse[4] = { diffuse.x, diffuse.y, diffuse.z, 1.0f };
        GLfloat material_specular[4] = { specular.x, specular.y, specular.z, 1 };
        GLfloat material_shininess = { shininess };
        glMaterialfv(GL_FRONT, GL_DIFFUSE, material_diffuse);
        glMaterialfv(GL_FRONT, GL_SPECULAR, material_specular);
        glMaterialf(GL_FRONT, GL_SHININESS, material_shininess);
}

// set opengl defaults to material values
void Light::resetMaterial() {
        GLfloat material_diffuse[4] = { 0.8f, 0.8f, 0.8f, 1.0f };
        GLfloat material_specular[4] = { 0, 0, 0, 1 };
        GLfloat material_shininess = { 0 };
        glMaterialfv(GL_FRONT, GL_DIFFUSE, material_diffuse);
        glMaterialfv(GL_FRONT, GL_SPECULAR, material_specular);
        glMaterialf(GL_FRONT, GL_SHININESS, material_shininess);
}