#ifndef _LIGHTSYSTEM_HPP_
#define _LIGHTSYSTEM_HPP_

#include "externs.hpp"
#include "mathematics.hpp"

class Light 
{
protected:
	Light() { };
	virtual ~Light() { };
public:
	static void startLight(Vector3 pos, Vector3 diffuse, Vector3 specular, Vector3 ambient, float constant_attenuation=1.0f, float linear_attenuation=1.0f, float quadratic_attenuation=1.0f );
	static void startAmbientLight(Vector3 pos, Vector3 diffuse, Vector3 specular, Vector3 ambient, float constant_attenuation=1.0f, float linear_attenuation=1.0f, float quadratic_attenuation=1.0f );
	static void endLight();

	static void setMaterial(Vector3 diffuse, Vector3 specular, float shininess);
	static void resetMaterial();
};

#endif