#ifndef _T3DVBO_HPP_
#define _T3DVBO_HPP_

#pragma warning(disable: 4018)

#include "externs.hpp"
#include "mathematics.hpp"
#include "../DemoTractor/t3d.hpp"


//--------------------------------------------------------------------------------------------
//  Helper types
//--------------------------------------------------------------------------------------------
struct T3DVBOLine
{
	int a,b;
};

class T3DVBOVert
{
public:
	float x;
	float y;
	float z;
};

class T3DVBOTexCoord							
{
public:
	float u;
	float v;
};

//--------------------------------------------------------------------------------------------
//  T3D - Traction 3D edge class
//--------------------------------------------------------------------------------------------

class T3DEdge
{
	public:
		
		int face1, face2;
		int a, b;
};


//--------------------------------------------------------------------------------------------
//  T3D - Traction 3D object class
//--------------------------------------------------------------------------------------------

class T3DVBO
{	
	public:

		T3DVBO(T3D *t);
		~T3DVBO();
		
		T3D *model;	

		T3DEdge *getEdgeArray();
		int getEdgeCount();

		void renderVBO();
		void freeVBO();
		void createVBO();

		void constructEdges();
		void freeEdges();
		void computeSilhouette(Vector3 lightPos);
		void drawSilhouette();
		void drawShadow(bool frontbackcap=false);

		bool *getFacingLightArray();

	private:
		
		int edges;
		T3DEdge *edge;
		
		// is face facing light or not
		bool *facingLight;
		Vector3 lightpos;

		// VBO
		bool VBOinit;
		GLuint vertBufferID;
		GLuint texBufferID;
		GLuint normalBufferID;
};


#endif