#ifndef _EXTERNS_HPP_
#define _EXTERNS_HPP_




//--------------------------------------------------------------------------------------------
//  Headers
//--------------------------------------------------------------------------------------------

#include <windows.h>

#include "../DemoTractor/opengl.hpp"
//#include "lib/log.hpp"
//#include "lib/timer.hpp"
//#include "lib/sound.hpp"
//#include "DemoTractor/spline.hpp"
#include "../DemoTractor/font.hpp"
#include "../DemoTractor/texturemanager.hpp"
#include "../DemoTractor/objectmanager.hpp"
#include "../DemoTractor/effectmanager.hpp"
#include "../DemoTractor/beziercurve.hpp"
#include "../DemoTractor/hermitecurve.hpp"
//#include "DemoTractor/path.hpp"
//#include "DemoTractor/lista.hpp"

#include "../DemoTractor/t3d.hpp"

#include "../DemoTractor/spline.hpp"
#include "ext.hpp"

#define DMS_TEXTURE 0x01



//--------------------------------------------------------------------------------------------
//  Link needed libraries
//--------------------------------------------------------------------------------------------

#pragma comment(lib, "comctl32.lib")
#pragma comment(lib, "DemoTractor/demotractor.lib")
#pragma comment(lib, "DemoTractor/opengl32.lib")
#pragma comment(lib, "DemoTractor/glu32.lib")
//#pragma comment(lib, "DemoTractor/winmm.lib")
//#pragma comment(lib, "DemoTractor/fmodvc.lib")
//#pragma comment(lib, "DemoTractor/libpng.lib")
//#pragma comment(lib, "DemoTractor/libz.lib")

//--------------------------------------------------------------------------------------------
//  Use our library namespace: TRACTION_DEMOTRACTOR
//--------------------------------------------------------------------------------------------

using namespace TRACTION_DEMOTRACTOR;

//OMAT THN
#include "t3dvbo.hpp"
#include "lista2.hpp"
#include "ext.hpp"
#include "myvertex.hpp"
#include "myface.hpp"
#include "postproc.hpp"
#include "bpm.hpp"
#include "trigger.hpp"
#include "shader.hpp"
#include "catmullrom.hpp"
#include "bezier.hpp"
#include "camera.hpp"
#include "mesh.hpp"
#include "bpm.hpp"


//--------------------------------------------------------------------------------------------
//  External Traction DEMOTRACTOR API functions
//--------------------------------------------------------------------------------------------

extern "C" __declspec(dllexport) void dmsSetLogging(bool f);
extern "C" __declspec(dllexport) void dmsMsg(const char *text, ...);
extern "C" __declspec(dllexport) void dmsConsoleMsg( int x, int y, const char *text, ...);
extern "C" __declspec(dllexport) void dmsClearConsole();
extern "C" __declspec(dllexport) bool dmsSetupInstances();
extern "C" __declspec(dllexport) bool dmsInit();
extern "C" __declspec(dllexport) bool dmsInitEx(int screenX, int screenY, int bpp, bool fullscreen, bool soundFlag, bool vsync, bool onTop, int fsaa, int aspectratio, char *pakFile);
extern "C" __declspec(dllexport) bool dmsInitDummyEx(int screenX, int screenY, int bpp, bool fullscreen, bool soundFlag, bool vsync, bool onTop, int fsaa);
extern "C" __declspec(dllexport) bool dmsOnFocus();
extern "C" __declspec(dllexport) void dmsSetGamma(int gamma);
extern "C" __declspec(dllexport) void dmsShutDown();
extern "C" __declspec(dllexport) void dmsCheckControls(float jump);
extern "C" __declspec(dllexport) void dmsPerspective2D(int w, int h);
extern "C" __declspec(dllexport) void dmsPerspective3D();
extern "C" __declspec(dllexport) void dmsSetFOV(float f);
extern "C" __declspec(dllexport) void dmsSetPerspective(float fov, float zNear, float zFar);

extern "C" __declspec(dllexport) void dmsInitTimer();
extern "C" __declspec(dllexport) void dmsUpdateTimer();
extern "C" __declspec(dllexport) void dmsAdjustTime(float f);

extern "C" __declspec(dllexport) void dmsInitSound();
extern "C" __declspec(dllexport) void dmsLoadSong(const char *fileName);
extern "C" __declspec(dllexport) void dmsSongVolume(float f);
extern "C" __declspec(dllexport) void dmsPlaySong(bool f);
extern "C" __declspec(dllexport) void dmsPauseSong(bool f);
extern "C" __declspec(dllexport) void dmsSetVolume(float f);
extern "C" __declspec(dllexport) bool dmsCheckSyncPoint();

extern "C" __declspec(dllexport) void dmsAddTexture(const char *fileName, const char *name);
extern "C" __declspec(dllexport) void dmsAddRenderToTexture(int width, int height, const char *name);
extern "C" __declspec(dllexport) void dmsUploadTextures();
extern "C" __declspec(dllexport) void dmsBindTexture(unsigned int mode, const char *name);

extern "C" __declspec(dllexport) void dmsAddFont(int x, int y, const char *name);

extern "C" __declspec(dllexport) void dmsInitObjects();
extern "C" __declspec(dllexport) void dmsAddObject(const char *fileName, const char *name);
extern "C" __declspec(dllexport) void dmsDrawObject(const char *name);

extern "C" __declspec(dllexport) void dmsInitEffects();
extern "C" __declspec(dllexport) void dmsAddEffect(unsigned long st, unsigned long et, unsigned int prio, const char *name, Base *effect);
extern "C" __declspec(dllexport) void dmsSetEffectPriority(unsigned int prio, const char *name);

extern "C" __declspec(dllexport) void dmsRun();

extern "C" __declspec(dllexport) void dmsWrite2D(float x, float y, float a, float scale, char *fontName, char *msg);
extern "C" __declspec(dllexport) void dmsWrite3D(float x, float y, float z, float a, char *fontName, char *msg);
extern "C" __declspec(dllexport) void dmsSetWindowTitle(const char *msg);
extern "C" __declspec(dllexport) void dmsDrawQuad2D();
extern "C" __declspec(dllexport) void dmsDrawQuad2DEx(Vector3 p1, Vector3 p2, Vector3 p3, Vector3 p4);
extern "C" __declspec(dllexport) void dmsDrawTexturedQuad2D();
extern "C" __declspec(dllexport) void dmsDrawTexturedQuad2DEx(Vector3 p1, Vector3 p2, Vector3 p3, Vector3 p4);
extern "C" __declspec(dllexport) void dmsBlending(bool blending, unsigned int src, unsigned int dst);

extern "C" __declspec(dllexport) float dmsGetTime();
extern "C" __declspec(dllexport) float dmsGetDeltaTime();
extern "C" __declspec(dllexport) void dmsGetSpectrum( float *array, int size );
extern "C" __declspec(dllexport) void dmsGetWaveData( float *array, int size );	
extern "C" __declspec(dllexport) T3D *dmsGetObject(const char *name);
extern "C" __declspec(dllexport) Texture *dmsGetTexture(const char *name);

extern "C" __declspec(dllexport) void dmsSetTextureParameter(const char *name, unsigned int pname, float value);
extern "C" __declspec(dllexport) void dmsSetMipMaps(const char *name, bool b);

extern "C" __declspec(dllexport) Font *dmsGetFont(const char *name);
extern "C" __declspec(dllexport) HDC dmsGetHDC();
extern "C" __declspec(dllexport) HWND dmsGetHWND();
extern "C" __declspec(dllexport) int dmsGetModulePosition();
extern "C" __declspec(dllexport) int dmsGetWindowWidth();
extern "C" __declspec(dllexport) int dmsGetWindowHeight();
extern "C" __declspec(dllexport) float dmsGetFPS();
extern "C" __declspec(dllexport) void dmsLoadBar(float value);

extern "C" __declspec(dllexport) void dmsResetViewport();

extern "C" __declspec(dllexport) float dmsCalcPos(float value, float limit1, float limit2);
extern "C" __declspec(dllexport) float dmsCalcSaturate(float value, float limit1, float limit2, float multiply);
extern "C" __declspec(dllexport) float dmsRandFloat();

extern "C" __declspec(dllexport) bool dmsReadSetup(char *name);
extern "C" __declspec(dllexport) bool dmsReadPak(char *name);

//extern "C" __declspec(dllexport) void myEnable(int c);
//extern "C" __declspec(dllexport) void myDisable(int c);
//extern "C" __declspec(dllexport) void myBlendFunc(int src, int dst);
extern "C" __declspec(dllexport) bool dmsMakePAK(const char *src, const char *dst);

extern "C" __declspec(dllexport) void dmsInitFrameBuffer(unsigned int width, unsigned int height);
extern "C" __declspec(dllexport) unsigned int *dmsGetFrameBuffer();

extern "C" __declspec(dllexport) void dmsRenderCube( Vector3 pos, float size, unsigned int flag );
extern "C" __declspec(dllexport) void dmsLogStateGL();


////////////////////////////////
// Global extension functions
////////////////////////////////
// to help tigital with the porting ;)


extern PFNGLGENBUFFERSARBPROC glGenBuffersARB;					// VBO Name Generation Procedure
extern PFNGLBINDBUFFERARBPROC glBindBufferARB;					// VBO Bind Procedure
extern PFNGLBUFFERDATAARBPROC glBufferDataARB;					// VBO Data Loading Procedure
extern PFNGLDELETEBUFFERSARBPROC glDeleteBuffersARB;				// VBO Deletion Procedure


extern PFNGLMULTITEXCOORD2FARBPROC 					glMultiTexCoord2fARB;
//extern PFNGLMULTITEXCOORD2FVARBPROC 					glMultiTexCoord2fvARB;
extern PFNGLACTIVETEXTUREARBPROC 						glActiveTextureARB;
extern PFNGLPOINTPARAMETERFARBPROC 					glPointParameterfARB;
extern PFNGLPOINTPARAMETERFVARBPROC 					glPointParameterfvARB;
extern PFNGLISRENDERBUFFEREXTPROC 						glIsRenderbufferEXT;
extern PFNGLBINDRENDERBUFFEREXTPROC 					glBindRenderbufferEXT;
extern PFNGLDELETERENDERBUFFERSEXTPROC 				glDeleteRenderbuffersEXT;
extern PFNGLGENRENDERBUFFERSEXTPROC 					glGenRenderbuffersEXT;
extern PFNGLRENDERBUFFERSTORAGEEXTPROC 				glRenderbufferStorageEXT;
extern PFNGLGETRENDERBUFFERPARAMETERIVEXTPROC 			glGetRenderbufferParameterivEXT;
extern PFNGLISFRAMEBUFFEREXTPROC 						glIsFramebufferEXT;
extern PFNGLBINDFRAMEBUFFEREXTPROC 					glBindFramebufferEXT;
extern PFNGLDELETEFRAMEBUFFERSEXTPROC 					glDeleteFramebuffersEXT;
extern PFNGLGENFRAMEBUFFERSEXTPROC 					glGenFramebuffersEXT;
extern PFNGLCHECKFRAMEBUFFERSTATUSEXTPROC				glCheckFramebufferStatusEXT;
extern PFNGLFRAMEBUFFERTEXTURE1DEXTPROC				glFramebufferTexture1DEXT;
extern PFNGLFRAMEBUFFERTEXTURE2DEXTPROC				glFramebufferTexture2DEXT;
extern PFNGLFRAMEBUFFERTEXTURE3DEXTPROC				glFramebufferTexture3DEXT;
extern PFNGLFRAMEBUFFERRENDERBUFFEREXTPROC				glFramebufferRenderbufferEXT;
extern PFNGLGETFRAMEBUFFERATTACHMENTPARAMETERIVEXTPROC glGetFramebufferAttachmentParameterivEXT;
extern PFNGLGENERATEMIPMAPEXTPROC						glGenerateMipmapEXT;
extern PFNGLGETUNIFORMFVPROC				glGetUniformfvARB;
extern PFNGLGETUNIFORMIVPROC				glGetUniformivARB;
extern PFNGLCREATEPROGRAMOBJECTARBPROC		glCreateProgramObjectARB;
extern PFNGLDELETEOBJECTARBPROC			glDeleteObjectARB;
extern PFNGLCREATESHADEROBJECTARBPROC		glCreateShaderObjectARB;
extern PFNGLSHADERSOURCEARBPROC			glShaderSourceARB;
extern PFNGLCOMPILESHADERARBPROC			glCompileShaderARB;
extern PFNGLGETOBJECTPARAMETERIVARBPROC	glGetObjectParameterivARB;
extern PFNGLATTACHOBJECTARBPROC			glAttachObjectARB;
extern PFNGLGETINFOLOGARBPROC				glGetInfoLogARB;
extern PFNGLLINKPROGRAMARBPROC				glLinkProgramARB;
extern PFNGLUSEPROGRAMOBJECTARBPROC		glUseProgramObjectARB;
extern PFNGLGETUNIFORMLOCATIONARBPROC		glGetUniformLocationARB;
extern PFNGLDELETEPROGRAMPROC				glDeleteProgram;
extern PFNGLDELETESHADERPROC				glDeleteShader;
extern PFNGLISPROGRAMPROC					glIsProgram;
extern PFNGLISSHADERPROC					glIsShader;
extern PFNGLGETPROGRAMINFOLOGPROC			glGetProgramInfoLog;
extern PFNGLGETSHADERINFOLOGPROC			glGetShaderInfoLog;
extern PFNGLUNIFORM4FARBPROC			glUniform4fARB;
extern PFNGLUNIFORM3FARBPROC			glUniform3fARB;         
extern PFNGLUNIFORM2FPROC				glUniform2fARB;
extern PFNGLUNIFORM1FARBPROC			glUniform1fARB;
extern PFNGLUNIFORM1IARBPROC			glUniform1iARB;
extern PFNGLUNIFORM1IPROC				glUniform1i;
extern PFNGLUNIFORM2IPROC				glUniform2i;
extern PFNGLUNIFORM3IPROC				glUniform3i;
extern PFNGLUNIFORM4IPROC				glUniform4i;
extern PFNGLUNIFORM1FVPROC				glUniform1fv;
extern PFNGLUNIFORM2FVPROC				glUniform2fv;
extern PFNGLUNIFORM3FVPROC				glUniform3fv;
extern PFNGLUNIFORM4FVPROC				glUniform4fv;
extern PFNGLUNIFORM1IVPROC				glUniform1iv;
extern PFNGLUNIFORM2IVPROC				glUniform2iv;
extern PFNGLUNIFORM3IVPROC				glUniform3iv;
extern PFNGLUNIFORM4IVPROC				glUniform4iv;
extern PFNGLUNIFORMMATRIX2FVPROC		glUniformMatrix2fv;
extern PFNGLUNIFORMMATRIX3FVPROC		glUniformMatrix3fv;
extern PFNGLUNIFORMMATRIX4FVPROC		glUniformMatrix4fv;
extern PFNGLVALIDATEPROGRAMPROC		glValidateProgram;
extern PFNGLVERTEXATTRIB1DPROC			glVertexAttrib1d;
extern PFNGLVERTEXATTRIB1DVPROC		glVertexAttrib1dv;
extern PFNGLVERTEXATTRIB1FPROC			glVertexAttrib1f;
extern PFNGLVERTEXATTRIB1FVPROC		glVertexAttrib1fv;
extern PFNGLVERTEXATTRIB1SPROC			glVertexAttrib1s;
extern PFNGLVERTEXATTRIB1SVPROC		glVertexAttrib1sv;
extern PFNGLVERTEXATTRIB2DPROC			glVertexAttrib2d;
extern PFNGLVERTEXATTRIB2DVPROC		glVertexAttrib2dv;
extern PFNGLVERTEXATTRIB2FPROC			glVertexAttrib2f;
extern PFNGLVERTEXATTRIB2FVPROC		glVertexAttrib2fv;
extern PFNGLVERTEXATTRIB2SPROC			glVertexAttrib2s;
extern PFNGLVERTEXATTRIB2SVPROC		glVertexAttrib2sv;
extern PFNGLVERTEXATTRIB3DPROC			glVertexAttrib3d;
extern PFNGLVERTEXATTRIB3DVPROC		glVertexAttrib3dv;
extern PFNGLVERTEXATTRIB3FPROC			glVertexAttrib3f;
extern PFNGLVERTEXATTRIB3FVPROC		glVertexAttrib3fv;
extern PFNGLVERTEXATTRIB3SPROC			glVertexAttrib3s;
extern PFNGLVERTEXATTRIB3SVPROC		glVertexAttrib3sv;
extern PFNGLVERTEXATTRIB4NBVPROC		glVertexAttrib4Nbv;
extern PFNGLVERTEXATTRIB4NIVPROC		glVertexAttrib4Niv;
extern PFNGLVERTEXATTRIB4NSVPROC		glVertexAttrib4Nsv;
extern PFNGLVERTEXATTRIB4NUBPROC		glVertexAttrib4Nub;
extern PFNGLVERTEXATTRIB4NUBVPROC		glVertexAttrib4Nubv;
extern PFNGLVERTEXATTRIB4NUIVPROC		glVertexAttrib4Nuiv;
extern PFNGLVERTEXATTRIB4NUSVPROC		glVertexAttrib4Nusv;
extern PFNGLVERTEXATTRIB4BVPROC		glVertexAttrib4bv;
extern PFNGLVERTEXATTRIB4DPROC			glVertexAttrib4d;
extern PFNGLVERTEXATTRIB4DVPROC		glVertexAttrib4dv;
extern PFNGLVERTEXATTRIB4FPROC			glVertexAttrib4f;
extern PFNGLVERTEXATTRIB4FVPROC		glVertexAttrib4fv;
extern PFNGLVERTEXATTRIB4IVPROC		glVertexAttrib4iv;
extern PFNGLVERTEXATTRIB4SPROC			glVertexAttrib4s;
extern PFNGLVERTEXATTRIB4SVPROC		glVertexAttrib4sv;
extern PFNGLVERTEXATTRIB4UBVPROC		glVertexAttrib4ubv;
extern PFNGLVERTEXATTRIB4UIVPROC		glVertexAttrib4uiv;
extern PFNGLVERTEXATTRIB4USVPROC		glVertexAttrib4us;
extern PFNGLVERTEXATTRIBPOINTERPROC	glVertexAttribPointer;


#endif
