#include "primitives.hpp"

void Primitives::drawBillboard(Vector3 &point, float size)
{
	Vector3 x, y, z;
	Mathematics::antiRotate(&x, &y, &z);

    glBegin(GL_QUADS);

	Vector3 v1 = point - x*size - y*size;
	Vector3 v2 = point + x*size - y*size;
	Vector3 v3 = point + x*size + y*size;
	Vector3 v4 = point - x*size + y*size;

	glTexCoord2f(0, 0);
	glVertex3fv((float *)&v1);
	glTexCoord2f(1, 0);
	glVertex3fv((float *)&v2);
	glTexCoord2f(1, 1);
	glVertex3fv((float *)&v3);
	glTexCoord2f(0, 1);
	glVertex3fv((float *)&v4);

    glEnd();
}


void Primitives::flatTausta(float r, float g, float b, float alpha)
{
	glDisable(GL_DEPTH_TEST);
	//glDisable(GL_DEPTH_MASK);
	glDisable(GL_TEXTURE_2D);

	dmsPerspective2D(1,1);
	glLoadIdentity();

	glBegin(GL_QUADS);
    glColor4f(r,g,b, alpha);

	glVertex2f(0, 0);
	glVertex2f(1, 0);
	glVertex2f(1, 1);
	glVertex2f(0, 1);

	glEnd();

	dmsPerspective3D();
	glLoadIdentity();


}
void Primitives::textureTaustaMove(bool xflip, bool yflip, float xoff, float yoff)
{
	glDisable(GL_DEPTH_TEST);
//	glDisable(GL_DEPTH_MASK);
	glEnable(GL_TEXTURE_2D);
    glDepthMask(0);

	dmsPerspective2D(1,1);
	glLoadIdentity();

	float x0 = 0;
	float x1 = 1;
	float y0 = 1;
	float y1 = 0;

	if (xflip)
	{
		x1 = 0;
		x0 = 1;
	}
	if (yflip)
	{
		y0 = 0;
		y1 = 1;
	}

	glBegin(GL_QUADS);

	glTexCoord2f(x0+xoff, y0+yoff);
	glVertex2f(0, 0);
	glTexCoord2f(x1+xoff, y0+yoff);
	glVertex2f(1, 0);
	glTexCoord2f(x1+xoff, y1+yoff);
	glVertex2f(1, 1);
	glTexCoord2f(x0+xoff, y1+yoff);
	glVertex2f(0, 1);

	glEnd();

    glDepthMask(1);
	dmsPerspective3D();
	glLoadIdentity();
}
void Primitives::textureTaustaScale(bool xflip, bool yflip, float scale)
{
	glDisable(GL_DEPTH_TEST);
//	glDisable(GL_DEPTH_MASK);
	glEnable(GL_TEXTURE_2D);

	dmsPerspective2D(1,1);
	glLoadIdentity();

	float x0 = 0+scale;
	float x1 = 1-scale;
    float y0 = 1-scale;//*(480/640.0f);
	float y1 = 0+scale;//*(480/640.0f);

	if (xflip)
	{
        float temp = x1;
        x1 = x0;
        x0 = temp;
	}
	if (yflip)
	{
        float temp = y1;
        y1 = y0;
        y0 = temp;
	}

	glBegin(GL_QUADS);

	glTexCoord2f(x0, y0);
	glVertex2f(0, 0);
	glTexCoord2f(x1, y0);
	glVertex2f(1, 0);
	glTexCoord2f(x1, y1);
	glVertex2f(1, 1);
	glTexCoord2f(x0, y1);
	glVertex2f(0, 1);

	glEnd();

	dmsPerspective3D();
	glLoadIdentity();
}

void Primitives::textureTaustaScaleMove(bool xflip, bool yflip, float scale, float xoff, float yoff)
{
	glDisable(GL_DEPTH_TEST);
//	glDisable(GL_DEPTH_MASK);
	glEnable(GL_TEXTURE_2D);

	dmsPerspective2D(1,1);
	glLoadIdentity();

	float x0 = 0+scale;
	float x1 = 1-scale;
    float y0 = 1-scale;//*(480/640.0f);
	float y1 = 0+scale;//*(480/640.0f);

	if (xflip)
	{
        float temp = x1;
        x1 = x0;
        x0 = temp;
	}
	if (yflip)
	{
        float temp = y1;
        y1 = y0;
        y0 = temp;
	}

	glBegin(GL_QUADS);

	glTexCoord2f(x0+xoff, y0+yoff);
	glVertex2f(0, 0);
	glTexCoord2f(x1+xoff, y0+yoff);
	glVertex2f(1, 0);
	glTexCoord2f(x1+xoff, y1+yoff);
	glVertex2f(1, 1);
	glTexCoord2f(x0+xoff, y1+yoff);
	glVertex2f(0, 1);

	glEnd();

	dmsPerspective3D();
	glLoadIdentity();
}

void Primitives::textureTausta(bool xflip, bool yflip)
{
	glDisable(GL_DEPTH_TEST);
//	glDisable(GL_DEPTH_MASK);
	glEnable(GL_TEXTURE_2D);

	dmsPerspective2D(1,1);
	glLoadIdentity();

	float x0 = 0;
	float x1 = 1;
	float y0 = 1;
	float y1 = 0;

	if (xflip)
	{
		x1 = 0;
		x0 = 1;
	}
	if (yflip)
	{
		y0 = 0;
		y1 = 1;
	}

	glBegin(GL_QUADS);

	glTexCoord2f(x0, y0);
	glVertex2f(0, 0);
	glTexCoord2f(x1, y0);
	glVertex2f(1, 0);
	glTexCoord2f(x1, y1);
	glVertex2f(1, 1);
	glTexCoord2f(x0, y1);
	glVertex2f(0, 1);

	glEnd();

	dmsPerspective3D();
	glLoadIdentity();




}

void Primitives::fadeText(float x, float y, float scale, float alpha, float pos, float starttime, float endtime, float ramp,
				 		  char *fontti, char *teksti)
{
	if (pos < starttime || pos > endtime)
		return;

	float fadekohta = (pos-starttime) / (endtime-starttime);
	fadekohta = (float)sin(fadekohta*3.141592f); //yls ja alas
	fadekohta = (float)pow(fadekohta, ramp);

	dmsWrite2D(x, y, alpha*fadekohta, scale, fontti, teksti);

//void dmsWrite2D(float x, float y, float a, float scale, char *fontName, char *msg);

}


void Primitives::flatCube(float size)
{
	Vector3 upleftback = Vector3( -size, -size, -size);
	Vector3 upleftfront = Vector3(-size, -size, +size);
	Vector3 uprightback = Vector3( size, -size, -size);
	Vector3 uprightfront = Vector3(size, -size, +size);

	Vector3 downleftback = Vector3( -size, size, -size);
	Vector3 downleftfront = Vector3(-size, size, +size);
	Vector3 downrightback = Vector3( size, size, -size);
	Vector3 downrightfront = Vector3(size, size, +size);

	glBegin(GL_QUADS);

	//ylsivu
	glVertex3fv((float *)&upleftback);
	glVertex3fv((float *)&uprightback);
	glVertex3fv((float *)&uprightfront);
	glVertex3fv((float *)&upleftfront);

	//alasivu
	glVertex3fv((float *)&downleftback);
	glVertex3fv((float *)&downrightback);
	glVertex3fv((float *)&downrightfront);
	glVertex3fv((float *)&downleftfront);

	//etusivu
	glVertex3fv((float *)&upleftfront);
	glVertex3fv((float *)&uprightfront);
	glVertex3fv((float *)&downrightfront);
	glVertex3fv((float *)&downleftfront);

	//takasivu
	glVertex3fv((float *)&upleftback);
	glVertex3fv((float *)&uprightback);
	glVertex3fv((float *)&downrightback);
	glVertex3fv((float *)&downleftback);

	//vasen sivu
	glVertex3fv((float *)&upleftback);
	glVertex3fv((float *)&upleftfront);
	glVertex3fv((float *)&downleftfront);
	glVertex3fv((float *)&downleftback);

	//oikea sivu
	glVertex3fv((float *)&uprightback);
	glVertex3fv((float *)&uprightfront);
	glVertex3fv((float *)&downrightfront);
	glVertex3fv((float *)&downrightback);

	glEnd();
}






void Primitives::wireCube(float size)
{
	if (size <= 0) return;
	Vector3 upleftback = Vector3( -size, -size, -size);
	Vector3 upleftfront = Vector3(-size, -size, +size);
	Vector3 uprightback = Vector3( size, -size, -size);
	Vector3 uprightfront = Vector3(size, -size, +size);

	Vector3 downleftback = Vector3( -size, size, -size);
	Vector3 downleftfront = Vector3(-size, size, +size);
	Vector3 downrightback = Vector3( size, size, -size);
	Vector3 downrightfront = Vector3(size, size, +size);
	
	glBegin(GL_LINES);

	//ylsivu vasen
	glVertex3fv((float *)&upleftfront);
	glVertex3fv((float *)&upleftback);
	//ylsivu oikea
	glVertex3fv((float *)&uprightfront);
	glVertex3fv((float *)&uprightback);
	//ylsivu etu
	glVertex3fv((float *)&uprightfront);
	glVertex3fv((float *)&upleftfront);
	//ylsivu taka
	glVertex3fv((float *)&uprightback);
	glVertex3fv((float *)&upleftback);

	//alasivu vasen
	glVertex3fv((float *)&downleftfront);
	glVertex3fv((float *)&downleftback);
	//alasivu oikea
	glVertex3fv((float *)&downrightfront);
	glVertex3fv((float *)&downrightback);
	//alasivu etu
	glVertex3fv((float *)&downrightfront);
	glVertex3fv((float *)&downleftfront);
	//alasivu taka
	glVertex3fv((float *)&downrightback);
	glVertex3fv((float *)&downleftback);

	//oikea sivu yl
	glVertex3fv((float *)&uprightfront);
	glVertex3fv((float *)&uprightback);
	//oikea sivu ala
	glVertex3fv((float *)&downrightfront);
	glVertex3fv((float *)&downrightback);
	//oikea sivu etu
	glVertex3fv((float *)&uprightfront);
	glVertex3fv((float *)&downrightfront);
	//oikea sivu taka
	glVertex3fv((float *)&uprightback);
	glVertex3fv((float *)&downrightback);

	//vasen sivu yl
	glVertex3fv((float *)&upleftfront);
	glVertex3fv((float *)&upleftback);
	//vasen sivu ala
	glVertex3fv((float *)&downleftfront);
	glVertex3fv((float *)&downleftback);
	//vasen sivu etu
	glVertex3fv((float *)&upleftfront);
	glVertex3fv((float *)&downleftfront);
	//vasen sivu taka
	glVertex3fv((float *)&upleftback);
	glVertex3fv((float *)&downleftback);

	//etusivu yl
	glVertex3fv((float *)&uprightfront);
	glVertex3fv((float *)&upleftfront);
	//etusivu ala
	glVertex3fv((float *)&downrightfront);
	glVertex3fv((float *)&downleftfront);
	//etusivu oikea
	glVertex3fv((float *)&uprightfront);
	glVertex3fv((float *)&downrightfront);
	//etusivu vasen
	glVertex3fv((float *)&upleftfront);
	glVertex3fv((float *)&downleftfront);

	//takasivu yl
	glVertex3fv((float *)&uprightback);
	glVertex3fv((float *)&upleftback);
	//takasivu ala
	glVertex3fv((float *)&downrightback);
	glVertex3fv((float *)&downleftback);
	//takasivu oikea
	glVertex3fv((float *)&uprightback);
	glVertex3fv((float *)&downrightback);
	//takasivu vasen
	glVertex3fv((float *)&upleftback);
	glVertex3fv((float *)&downleftback);

	glEnd();
}
